/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.spot.rest.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum PendingType {
    LIMIT("LIMIT"),
    MARKET("MARKET"),
    STOP_LOSS("STOP_LOSS"),
    STOP_LOSS_LIMIT("STOP_LOSS_LIMIT"),
    TAKE_PROFIT("TAKE_PROFIT"),
    TAKE_PROFIT_LIMIT("TAKE_PROFIT_LIMIT"),
    LIMIT_MAKER("LIMIT_MAKER");

    private String value;

    private PendingType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PendingType fromValue(String value) {
        for (PendingType b : PendingType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        PendingType.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<PendingType> {
        public void write(JsonWriter jsonWriter, PendingType enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public PendingType read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return PendingType.fromValue(value);
        }
    }
}

