/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.spot.rest.api;

import com.binance.connector.client.common.ApiClient;
import com.binance.connector.client.common.ApiException;
import com.binance.connector.client.common.ApiResponse;
import com.binance.connector.client.common.configuration.ClientConfiguration;
import com.binance.connector.client.spot.rest.SpotRestApiUtil;
import com.binance.connector.client.spot.rest.api.AccountApi;
import com.binance.connector.client.spot.rest.api.GeneralApi;
import com.binance.connector.client.spot.rest.api.MarketApi;
import com.binance.connector.client.spot.rest.api.TradeApi;
import com.binance.connector.client.spot.rest.api.UserDataStreamApi;
import com.binance.connector.client.spot.rest.model.AccountCommissionResponse;
import com.binance.connector.client.spot.rest.model.AggTradesResponse;
import com.binance.connector.client.spot.rest.model.AllOrderListResponse;
import com.binance.connector.client.spot.rest.model.AllOrdersResponse;
import com.binance.connector.client.spot.rest.model.AvgPriceResponse;
import com.binance.connector.client.spot.rest.model.CancelRestrictions;
import com.binance.connector.client.spot.rest.model.DeleteOpenOrdersResponse;
import com.binance.connector.client.spot.rest.model.DeleteOrderListResponse;
import com.binance.connector.client.spot.rest.model.DeleteOrderResponse;
import com.binance.connector.client.spot.rest.model.DepthResponse;
import com.binance.connector.client.spot.rest.model.ExchangeInfoResponse;
import com.binance.connector.client.spot.rest.model.GetAccountResponse;
import com.binance.connector.client.spot.rest.model.GetOpenOrdersResponse;
import com.binance.connector.client.spot.rest.model.GetOrderListResponse;
import com.binance.connector.client.spot.rest.model.GetOrderResponse;
import com.binance.connector.client.spot.rest.model.GetTradesResponse;
import com.binance.connector.client.spot.rest.model.HistoricalTradesResponse;
import com.binance.connector.client.spot.rest.model.Interval;
import com.binance.connector.client.spot.rest.model.KlinesResponse;
import com.binance.connector.client.spot.rest.model.MyAllocationsResponse;
import com.binance.connector.client.spot.rest.model.MyPreventedMatchesResponse;
import com.binance.connector.client.spot.rest.model.MyTradesResponse;
import com.binance.connector.client.spot.rest.model.NewOrderRequest;
import com.binance.connector.client.spot.rest.model.NewOrderResponse;
import com.binance.connector.client.spot.rest.model.NewUserDataStreamResponse;
import com.binance.connector.client.spot.rest.model.OpenOrderListResponse;
import com.binance.connector.client.spot.rest.model.OrderAmendKeepPriorityRequest;
import com.binance.connector.client.spot.rest.model.OrderAmendKeepPriorityResponse;
import com.binance.connector.client.spot.rest.model.OrderAmendmentsResponse;
import com.binance.connector.client.spot.rest.model.OrderCancelReplaceRequest;
import com.binance.connector.client.spot.rest.model.OrderCancelReplaceResponse;
import com.binance.connector.client.spot.rest.model.OrderListOcoRequest;
import com.binance.connector.client.spot.rest.model.OrderListOcoResponse;
import com.binance.connector.client.spot.rest.model.OrderListOtoRequest;
import com.binance.connector.client.spot.rest.model.OrderListOtoResponse;
import com.binance.connector.client.spot.rest.model.OrderListOtocoRequest;
import com.binance.connector.client.spot.rest.model.OrderListOtocoResponse;
import com.binance.connector.client.spot.rest.model.OrderOcoRequest;
import com.binance.connector.client.spot.rest.model.OrderOcoResponse;
import com.binance.connector.client.spot.rest.model.OrderTestRequest;
import com.binance.connector.client.spot.rest.model.OrderTestResponse;
import com.binance.connector.client.spot.rest.model.Permissions;
import com.binance.connector.client.spot.rest.model.PutUserDataStreamRequest;
import com.binance.connector.client.spot.rest.model.RateLimitOrderResponse;
import com.binance.connector.client.spot.rest.model.SorOrderRequest;
import com.binance.connector.client.spot.rest.model.SorOrderResponse;
import com.binance.connector.client.spot.rest.model.SorOrderTestRequest;
import com.binance.connector.client.spot.rest.model.SorOrderTestResponse;
import com.binance.connector.client.spot.rest.model.SymbolStatus;
import com.binance.connector.client.spot.rest.model.Symbols;
import com.binance.connector.client.spot.rest.model.Ticker24hrResponse;
import com.binance.connector.client.spot.rest.model.TickerBookTickerResponse;
import com.binance.connector.client.spot.rest.model.TickerPriceResponse;
import com.binance.connector.client.spot.rest.model.TickerResponse;
import com.binance.connector.client.spot.rest.model.TickerTradingDayResponse;
import com.binance.connector.client.spot.rest.model.TickerType;
import com.binance.connector.client.spot.rest.model.TimeResponse;
import com.binance.connector.client.spot.rest.model.UiKlinesResponse;
import com.binance.connector.client.spot.rest.model.WindowSize;

public class SpotRestApi {
    private final AccountApi accountApi;
    private final GeneralApi generalApi;
    private final MarketApi marketApi;
    private final TradeApi tradeApi;
    private final UserDataStreamApi userDataStreamApi;

    public SpotRestApi(ClientConfiguration configuration) {
        this(SpotRestApiUtil.getDefaultClient(configuration));
    }

    public SpotRestApi(ApiClient apiClient) {
        this.accountApi = new AccountApi(apiClient);
        this.generalApi = new GeneralApi(apiClient);
        this.marketApi = new MarketApi(apiClient);
        this.tradeApi = new TradeApi(apiClient);
        this.userDataStreamApi = new UserDataStreamApi(apiClient);
    }

    public ApiResponse<AccountCommissionResponse> accountCommission(String symbol) throws ApiException {
        return this.accountApi.accountCommission(symbol);
    }

    public ApiResponse<AllOrderListResponse> allOrderList(Long fromId, Long startTime, Long endTime, Integer limit, Long recvWindow) throws ApiException {
        return this.accountApi.allOrderList(fromId, startTime, endTime, limit, recvWindow);
    }

    public ApiResponse<AllOrdersResponse> allOrders(String symbol, Long orderId, Long startTime, Long endTime, Integer limit, Long recvWindow) throws ApiException {
        return this.accountApi.allOrders(symbol, orderId, startTime, endTime, limit, recvWindow);
    }

    public ApiResponse<GetAccountResponse> getAccount(Boolean omitZeroBalances, Long recvWindow) throws ApiException {
        return this.accountApi.getAccount(omitZeroBalances, recvWindow);
    }

    public ApiResponse<GetOpenOrdersResponse> getOpenOrders(String symbol, Long recvWindow) throws ApiException {
        return this.accountApi.getOpenOrders(symbol, recvWindow);
    }

    public ApiResponse<GetOrderResponse> getOrder(String symbol, Long orderId, String origClientOrderId, Long recvWindow) throws ApiException {
        return this.accountApi.getOrder(symbol, orderId, origClientOrderId, recvWindow);
    }

    public ApiResponse<GetOrderListResponse> getOrderList(Long orderListId, String origClientOrderId, Long recvWindow) throws ApiException {
        return this.accountApi.getOrderList(orderListId, origClientOrderId, recvWindow);
    }

    public ApiResponse<MyAllocationsResponse> myAllocations(String symbol, Long startTime, Long endTime, Integer fromAllocationId, Integer limit, Long orderId, Long recvWindow) throws ApiException {
        return this.accountApi.myAllocations(symbol, startTime, endTime, fromAllocationId, limit, orderId, recvWindow);
    }

    public ApiResponse<MyPreventedMatchesResponse> myPreventedMatches(String symbol, Long preventedMatchId, Long orderId, Long fromPreventedMatchId, Integer limit, Long recvWindow) throws ApiException {
        return this.accountApi.myPreventedMatches(symbol, preventedMatchId, orderId, fromPreventedMatchId, limit, recvWindow);
    }

    public ApiResponse<MyTradesResponse> myTrades(String symbol, Long orderId, Long startTime, Long endTime, Long fromId, Integer limit, Long recvWindow) throws ApiException {
        return this.accountApi.myTrades(symbol, orderId, startTime, endTime, fromId, limit, recvWindow);
    }

    public ApiResponse<OpenOrderListResponse> openOrderList(Long recvWindow) throws ApiException {
        return this.accountApi.openOrderList(recvWindow);
    }

    public ApiResponse<OrderAmendmentsResponse> orderAmendments(String symbol, Long orderId, Long fromExecutionId, Long limit, Long recvWindow) throws ApiException {
        return this.accountApi.orderAmendments(symbol, orderId, fromExecutionId, limit, recvWindow);
    }

    public ApiResponse<RateLimitOrderResponse> rateLimitOrder(Long recvWindow) throws ApiException {
        return this.accountApi.rateLimitOrder(recvWindow);
    }

    public ApiResponse<ExchangeInfoResponse> exchangeInfo(String symbol, Symbols symbols, Permissions permissions, Boolean showPermissionSets, SymbolStatus symbolStatus) throws ApiException {
        return this.generalApi.exchangeInfo(symbol, symbols, permissions, showPermissionSets, symbolStatus);
    }

    public void ping() throws ApiException {
        this.generalApi.ping();
    }

    public ApiResponse<TimeResponse> time() throws ApiException {
        return this.generalApi.time();
    }

    public ApiResponse<AggTradesResponse> aggTrades(String symbol, Long fromId, Long startTime, Long endTime, Integer limit) throws ApiException {
        return this.marketApi.aggTrades(symbol, fromId, startTime, endTime, limit);
    }

    public ApiResponse<AvgPriceResponse> avgPrice(String symbol) throws ApiException {
        return this.marketApi.avgPrice(symbol);
    }

    public ApiResponse<DepthResponse> depth(String symbol, Integer limit) throws ApiException {
        return this.marketApi.depth(symbol, limit);
    }

    public ApiResponse<GetTradesResponse> getTrades(String symbol, Integer limit) throws ApiException {
        return this.marketApi.getTrades(symbol, limit);
    }

    public ApiResponse<HistoricalTradesResponse> historicalTrades(String symbol, Integer limit, Long fromId) throws ApiException {
        return this.marketApi.historicalTrades(symbol, limit, fromId);
    }

    public ApiResponse<KlinesResponse> klines(String symbol, Interval interval, Long startTime, Long endTime, String timeZone, Integer limit) throws ApiException {
        return this.marketApi.klines(symbol, interval, startTime, endTime, timeZone, limit);
    }

    public ApiResponse<TickerResponse> ticker(String symbol, Symbols symbols, WindowSize windowSize, TickerType type) throws ApiException {
        return this.marketApi.ticker(symbol, symbols, windowSize, type);
    }

    public ApiResponse<Ticker24hrResponse> ticker24hr(String symbol, Symbols symbols, TickerType type) throws ApiException {
        return this.marketApi.ticker24hr(symbol, symbols, type);
    }

    public ApiResponse<TickerBookTickerResponse> tickerBookTicker(String symbol, Symbols symbols) throws ApiException {
        return this.marketApi.tickerBookTicker(symbol, symbols);
    }

    public ApiResponse<TickerPriceResponse> tickerPrice(String symbol, Symbols symbols) throws ApiException {
        return this.marketApi.tickerPrice(symbol, symbols);
    }

    public ApiResponse<TickerTradingDayResponse> tickerTradingDay(String symbol, Symbols symbols, String timeZone, TickerType type) throws ApiException {
        return this.marketApi.tickerTradingDay(symbol, symbols, timeZone, type);
    }

    public ApiResponse<UiKlinesResponse> uiKlines(String symbol, Interval interval, Long startTime, Long endTime, String timeZone, Integer limit) throws ApiException {
        return this.marketApi.uiKlines(symbol, interval, startTime, endTime, timeZone, limit);
    }

    public ApiResponse<DeleteOpenOrdersResponse> deleteOpenOrders(String symbol, Long recvWindow) throws ApiException {
        return this.tradeApi.deleteOpenOrders(symbol, recvWindow);
    }

    public ApiResponse<DeleteOrderResponse> deleteOrder(String symbol, Long orderId, String origClientOrderId, String newClientOrderId, CancelRestrictions cancelRestrictions, Long recvWindow) throws ApiException {
        return this.tradeApi.deleteOrder(symbol, orderId, origClientOrderId, newClientOrderId, cancelRestrictions, recvWindow);
    }

    public ApiResponse<DeleteOrderListResponse> deleteOrderList(String symbol, Long orderListId, String listClientOrderId, String newClientOrderId, Long recvWindow) throws ApiException {
        return this.tradeApi.deleteOrderList(symbol, orderListId, listClientOrderId, newClientOrderId, recvWindow);
    }

    public ApiResponse<NewOrderResponse> newOrder(NewOrderRequest newOrderRequest) throws ApiException {
        return this.tradeApi.newOrder(newOrderRequest);
    }

    public ApiResponse<OrderAmendKeepPriorityResponse> orderAmendKeepPriority(OrderAmendKeepPriorityRequest orderAmendKeepPriorityRequest) throws ApiException {
        return this.tradeApi.orderAmendKeepPriority(orderAmendKeepPriorityRequest);
    }

    public ApiResponse<OrderCancelReplaceResponse> orderCancelReplace(OrderCancelReplaceRequest orderCancelReplaceRequest) throws ApiException {
        return this.tradeApi.orderCancelReplace(orderCancelReplaceRequest);
    }

    public ApiResponse<OrderListOcoResponse> orderListOco(OrderListOcoRequest orderListOcoRequest) throws ApiException {
        return this.tradeApi.orderListOco(orderListOcoRequest);
    }

    public ApiResponse<OrderListOtoResponse> orderListOto(OrderListOtoRequest orderListOtoRequest) throws ApiException {
        return this.tradeApi.orderListOto(orderListOtoRequest);
    }

    public ApiResponse<OrderListOtocoResponse> orderListOtoco(OrderListOtocoRequest orderListOtocoRequest) throws ApiException {
        return this.tradeApi.orderListOtoco(orderListOtocoRequest);
    }

    public ApiResponse<OrderOcoResponse> orderOco(OrderOcoRequest orderOcoRequest) throws ApiException {
        return this.tradeApi.orderOco(orderOcoRequest);
    }

    public ApiResponse<OrderTestResponse> orderTest(OrderTestRequest orderTestRequest) throws ApiException {
        return this.tradeApi.orderTest(orderTestRequest);
    }

    public ApiResponse<SorOrderResponse> sorOrder(SorOrderRequest sorOrderRequest) throws ApiException {
        return this.tradeApi.sorOrder(sorOrderRequest);
    }

    public ApiResponse<SorOrderTestResponse> sorOrderTest(SorOrderTestRequest sorOrderTestRequest) throws ApiException {
        return this.tradeApi.sorOrderTest(sorOrderTestRequest);
    }

    public void deleteUserDataStream(String listenKey) throws ApiException {
        this.userDataStreamApi.deleteUserDataStream(listenKey);
    }

    public ApiResponse<NewUserDataStreamResponse> newUserDataStream() throws ApiException {
        return this.userDataStreamApi.newUserDataStream();
    }

    public void putUserDataStream(PutUserDataStreamRequest putUserDataStreamRequest) throws ApiException {
        this.userDataStreamApi.putUserDataStream(putUserDataStreamRequest);
    }
}

