/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.spot.rest.api;

import com.binance.connector.client.common.ApiClient;
import com.binance.connector.client.common.ApiException;
import com.binance.connector.client.common.ApiResponse;
import com.binance.connector.client.common.JSON;
import com.binance.connector.client.common.SystemUtil;
import com.binance.connector.client.common.configuration.ClientConfiguration;
import com.binance.connector.client.common.exception.ConstraintViolationException;
import com.binance.connector.client.spot.rest.model.AggTradesResponse;
import com.binance.connector.client.spot.rest.model.AvgPriceResponse;
import com.binance.connector.client.spot.rest.model.DepthResponse;
import com.binance.connector.client.spot.rest.model.GetTradesResponse;
import com.binance.connector.client.spot.rest.model.HistoricalTradesResponse;
import com.binance.connector.client.spot.rest.model.Interval;
import com.binance.connector.client.spot.rest.model.KlinesResponse;
import com.binance.connector.client.spot.rest.model.Symbols;
import com.binance.connector.client.spot.rest.model.Ticker24hrResponse;
import com.binance.connector.client.spot.rest.model.TickerBookTickerResponse;
import com.binance.connector.client.spot.rest.model.TickerPriceResponse;
import com.binance.connector.client.spot.rest.model.TickerResponse;
import com.binance.connector.client.spot.rest.model.TickerTradingDayResponse;
import com.binance.connector.client.spot.rest.model.TickerType;
import com.binance.connector.client.spot.rest.model.UiKlinesResponse;
import com.binance.connector.client.spot.rest.model.WindowSize;
import com.google.gson.reflect.TypeToken;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.executable.ExecutableValidator;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import okhttp3.Call;
import org.hibernate.validator.messageinterpolation.ParameterMessageInterpolator;

public class MarketApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;
    private static final String USER_AGENT = String.format("binance-spot/6.0.0 (Java/%s; %s; %s)", SystemUtil.getJavaVersion(), SystemUtil.getOs(), SystemUtil.getArch());
    private static final boolean HAS_TIME_UNIT = true;

    public MarketApi(ClientConfiguration clientConfiguration) {
        this(new ApiClient(clientConfiguration));
    }

    public MarketApi(ApiClient apiClient) {
        apiClient.setUserAgent(USER_AGENT);
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call aggTradesCall(String symbol, Long fromId, Long startTime, Long endTime, Integer limit) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/aggTrades";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (symbol != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbol", (Object)symbol));
        }
        if (fromId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fromId", (Object)fromId));
        }
        if (startTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("startTime", (Object)startTime));
        }
        if (endTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("endTime", (Object)endTime));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", (Object)limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call aggTradesValidateBeforeCall(String symbol, Long fromId, Long startTime, Long endTime, Integer limit) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{symbol, fromId, startTime, endTime, limit};
            Method method = this.getClass().getMethod("aggTrades", String.class, Long.class, Long.class, Long.class, Integer.class);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.aggTradesCall(symbol, fromId, startTime, endTime, limit);
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<AggTradesResponse> aggTrades(@NotNull String symbol, Long fromId, Long startTime, Long endTime, Integer limit) throws ApiException {
        Call localVarCall = this.aggTradesValidateBeforeCall(symbol, fromId, startTime, endTime, limit);
        Type localVarReturnType = new TypeToken<AggTradesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call avgPriceCall(String symbol) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/avgPrice";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (symbol != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbol", (Object)symbol));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call avgPriceValidateBeforeCall(String symbol) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{symbol};
            Method method = this.getClass().getMethod("avgPrice", String.class);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.avgPriceCall(symbol);
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<AvgPriceResponse> avgPrice(@NotNull String symbol) throws ApiException {
        Call localVarCall = this.avgPriceValidateBeforeCall(symbol);
        Type localVarReturnType = new TypeToken<AvgPriceResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call depthCall(String symbol, Integer limit) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/depth";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (symbol != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbol", (Object)symbol));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", (Object)limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call depthValidateBeforeCall(String symbol, Integer limit) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{symbol, limit};
            Method method = this.getClass().getMethod("depth", String.class, Integer.class);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.depthCall(symbol, limit);
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<DepthResponse> depth(@NotNull String symbol, Integer limit) throws ApiException {
        Call localVarCall = this.depthValidateBeforeCall(symbol, limit);
        Type localVarReturnType = new TypeToken<DepthResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getTradesCall(String symbol, Integer limit) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/trades";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (symbol != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbol", (Object)symbol));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", (Object)limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call getTradesValidateBeforeCall(String symbol, Integer limit) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{symbol, limit};
            Method method = this.getClass().getMethod("getTrades", String.class, Integer.class);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.getTradesCall(symbol, limit);
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<GetTradesResponse> getTrades(@NotNull String symbol, Integer limit) throws ApiException {
        Call localVarCall = this.getTradesValidateBeforeCall(symbol, limit);
        Type localVarReturnType = new TypeToken<GetTradesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call historicalTradesCall(String symbol, Integer limit, Long fromId) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/historicalTrades";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (symbol != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbol", (Object)symbol));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", (Object)limit));
        }
        if (fromId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fromId", (Object)fromId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call historicalTradesValidateBeforeCall(String symbol, Integer limit, Long fromId) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{symbol, limit, fromId};
            Method method = this.getClass().getMethod("historicalTrades", String.class, Integer.class, Long.class);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.historicalTradesCall(symbol, limit, fromId);
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<HistoricalTradesResponse> historicalTrades(@NotNull String symbol, Integer limit, Long fromId) throws ApiException {
        Call localVarCall = this.historicalTradesValidateBeforeCall(symbol, limit, fromId);
        Type localVarReturnType = new TypeToken<HistoricalTradesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call klinesCall(String symbol, Interval interval, Long startTime, Long endTime, String timeZone, Integer limit) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/klines";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (symbol != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbol", (Object)symbol));
        }
        if (interval != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("interval", (Object)interval));
        }
        if (startTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("startTime", (Object)startTime));
        }
        if (endTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("endTime", (Object)endTime));
        }
        if (timeZone != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeZone", (Object)timeZone));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", (Object)limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call klinesValidateBeforeCall(String symbol, Interval interval, Long startTime, Long endTime, String timeZone, Integer limit) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{symbol, interval, startTime, endTime, timeZone, limit};
            Method method = this.getClass().getMethod("klines", String.class, Interval.class, Long.class, Long.class, String.class, Integer.class);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.klinesCall(symbol, interval, startTime, endTime, timeZone, limit);
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<KlinesResponse> klines(@NotNull String symbol, @NotNull Interval interval, Long startTime, Long endTime, String timeZone, Integer limit) throws ApiException {
        Call localVarCall = this.klinesValidateBeforeCall(symbol, interval, startTime, endTime, timeZone, limit);
        Type localVarReturnType = new TypeToken<KlinesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call tickerCall(String symbol, Symbols symbols, WindowSize windowSize, TickerType type) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/ticker";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (symbol != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbol", (Object)symbol));
        }
        if (symbols != null) {
            String json = JSON.getGson().toJson((Object)symbols);
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbols", (Object)json));
        }
        if (windowSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("windowSize", (Object)windowSize));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", (Object)type));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call tickerValidateBeforeCall(String symbol, Symbols symbols, WindowSize windowSize, TickerType type) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{symbol, symbols, windowSize, type};
            Method method = this.getClass().getMethod("ticker", String.class, Symbols.class, WindowSize.class, TickerType.class);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.tickerCall(symbol, symbols, windowSize, type);
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<TickerResponse> ticker(String symbol, Symbols symbols, WindowSize windowSize, TickerType type) throws ApiException {
        Call localVarCall = this.tickerValidateBeforeCall(symbol, symbols, windowSize, type);
        Type localVarReturnType = new TypeToken<TickerResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call ticker24hrCall(String symbol, Symbols symbols, TickerType type) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/ticker/24hr";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (symbol != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbol", (Object)symbol));
        }
        if (symbols != null) {
            String json = JSON.getGson().toJson((Object)symbols);
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbols", (Object)json));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", (Object)type));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call ticker24hrValidateBeforeCall(String symbol, Symbols symbols, TickerType type) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{symbol, symbols, type};
            Method method = this.getClass().getMethod("ticker24hr", String.class, Symbols.class, TickerType.class);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.ticker24hrCall(symbol, symbols, type);
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<Ticker24hrResponse> ticker24hr(String symbol, Symbols symbols, TickerType type) throws ApiException {
        Call localVarCall = this.ticker24hrValidateBeforeCall(symbol, symbols, type);
        Type localVarReturnType = new TypeToken<Ticker24hrResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call tickerBookTickerCall(String symbol, Symbols symbols) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/ticker/bookTicker";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (symbol != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbol", (Object)symbol));
        }
        if (symbols != null) {
            String json = JSON.getGson().toJson((Object)symbols);
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbols", (Object)json));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call tickerBookTickerValidateBeforeCall(String symbol, Symbols symbols) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{symbol, symbols};
            Method method = this.getClass().getMethod("tickerBookTicker", String.class, Symbols.class);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.tickerBookTickerCall(symbol, symbols);
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<TickerBookTickerResponse> tickerBookTicker(String symbol, Symbols symbols) throws ApiException {
        Call localVarCall = this.tickerBookTickerValidateBeforeCall(symbol, symbols);
        Type localVarReturnType = new TypeToken<TickerBookTickerResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call tickerPriceCall(String symbol, Symbols symbols) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/ticker/price";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (symbol != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbol", (Object)symbol));
        }
        if (symbols != null) {
            String json = JSON.getGson().toJson((Object)symbols);
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbols", (Object)json));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call tickerPriceValidateBeforeCall(String symbol, Symbols symbols) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{symbol, symbols};
            Method method = this.getClass().getMethod("tickerPrice", String.class, Symbols.class);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.tickerPriceCall(symbol, symbols);
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<TickerPriceResponse> tickerPrice(String symbol, Symbols symbols) throws ApiException {
        Call localVarCall = this.tickerPriceValidateBeforeCall(symbol, symbols);
        Type localVarReturnType = new TypeToken<TickerPriceResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call tickerTradingDayCall(String symbol, Symbols symbols, String timeZone, TickerType type) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/ticker/tradingDay";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (symbol != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbol", (Object)symbol));
        }
        if (symbols != null) {
            String json = JSON.getGson().toJson((Object)symbols);
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbols", (Object)json));
        }
        if (timeZone != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeZone", (Object)timeZone));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", (Object)type));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call tickerTradingDayValidateBeforeCall(String symbol, Symbols symbols, String timeZone, TickerType type) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{symbol, symbols, timeZone, type};
            Method method = this.getClass().getMethod("tickerTradingDay", String.class, Symbols.class, String.class, TickerType.class);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.tickerTradingDayCall(symbol, symbols, timeZone, type);
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<TickerTradingDayResponse> tickerTradingDay(String symbol, Symbols symbols, String timeZone, TickerType type) throws ApiException {
        Call localVarCall = this.tickerTradingDayValidateBeforeCall(symbol, symbols, timeZone, type);
        Type localVarReturnType = new TypeToken<TickerTradingDayResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call uiKlinesCall(String symbol, Interval interval, Long startTime, Long endTime, String timeZone, Integer limit) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/uiKlines";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (symbol != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbol", (Object)symbol));
        }
        if (interval != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("interval", (Object)interval));
        }
        if (startTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("startTime", (Object)startTime));
        }
        if (endTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("endTime", (Object)endTime));
        }
        if (timeZone != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeZone", (Object)timeZone));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", (Object)limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call uiKlinesValidateBeforeCall(String symbol, Interval interval, Long startTime, Long endTime, String timeZone, Integer limit) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{symbol, interval, startTime, endTime, timeZone, limit};
            Method method = this.getClass().getMethod("uiKlines", String.class, Interval.class, Long.class, Long.class, String.class, Integer.class);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.uiKlinesCall(symbol, interval, startTime, endTime, timeZone, limit);
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<UiKlinesResponse> uiKlines(@NotNull String symbol, @NotNull Interval interval, Long startTime, Long endTime, String timeZone, Integer limit) throws ApiException {
        Call localVarCall = this.uiKlinesValidateBeforeCall(symbol, interval, startTime, endTime, timeZone, limit);
        Type localVarReturnType = new TypeToken<UiKlinesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }
}

