/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.spot.rest.api;

import com.binance.connector.client.common.ApiClient;
import com.binance.connector.client.common.ApiException;
import com.binance.connector.client.common.ApiResponse;
import com.binance.connector.client.common.SystemUtil;
import com.binance.connector.client.common.configuration.ClientConfiguration;
import com.binance.connector.client.common.exception.ConstraintViolationException;
import com.binance.connector.client.spot.rest.model.AccountCommissionResponse;
import com.binance.connector.client.spot.rest.model.AllOrderListResponse;
import com.binance.connector.client.spot.rest.model.AllOrdersResponse;
import com.binance.connector.client.spot.rest.model.GetAccountResponse;
import com.binance.connector.client.spot.rest.model.GetOpenOrdersResponse;
import com.binance.connector.client.spot.rest.model.GetOrderListResponse;
import com.binance.connector.client.spot.rest.model.GetOrderResponse;
import com.binance.connector.client.spot.rest.model.MyAllocationsResponse;
import com.binance.connector.client.spot.rest.model.MyPreventedMatchesResponse;
import com.binance.connector.client.spot.rest.model.MyTradesResponse;
import com.binance.connector.client.spot.rest.model.OpenOrderListResponse;
import com.binance.connector.client.spot.rest.model.OrderAmendmentsResponse;
import com.binance.connector.client.spot.rest.model.RateLimitOrderResponse;
import com.google.gson.reflect.TypeToken;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.executable.ExecutableValidator;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import okhttp3.Call;
import org.hibernate.validator.messageinterpolation.ParameterMessageInterpolator;

public class AccountApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;
    private static final String USER_AGENT = String.format("binance-spot/6.0.0 (Java/%s; %s; %s)", SystemUtil.getJavaVersion(), SystemUtil.getOs(), SystemUtil.getArch());
    private static final boolean HAS_TIME_UNIT = true;

    public AccountApi(ClientConfiguration clientConfiguration) {
        this(new ApiClient(clientConfiguration));
    }

    public AccountApi(ApiClient apiClient) {
        apiClient.setUserAgent(USER_AGENT);
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call accountCommissionCall(String symbol) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/account/commission";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (symbol != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbol", (Object)symbol));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("binanceSignature");
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call accountCommissionValidateBeforeCall(String symbol) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{symbol};
            Method method = this.getClass().getMethod("accountCommission", String.class);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.accountCommissionCall(symbol);
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<AccountCommissionResponse> accountCommission(@NotNull String symbol) throws ApiException {
        Call localVarCall = this.accountCommissionValidateBeforeCall(symbol);
        Type localVarReturnType = new TypeToken<AccountCommissionResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call allOrderListCall(Long fromId, Long startTime, Long endTime, Integer limit, Long recvWindow) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/allOrderList";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (fromId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fromId", (Object)fromId));
        }
        if (startTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("startTime", (Object)startTime));
        }
        if (endTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("endTime", (Object)endTime));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", (Object)limit));
        }
        if (recvWindow != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("recvWindow", (Object)recvWindow));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("binanceSignature");
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call allOrderListValidateBeforeCall(Long fromId, Long startTime, Long endTime, Integer limit, Long recvWindow) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{fromId, startTime, endTime, limit, recvWindow};
            Method method = this.getClass().getMethod("allOrderList", Long.class, Long.class, Long.class, Integer.class, Long.class);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.allOrderListCall(fromId, startTime, endTime, limit, recvWindow);
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<AllOrderListResponse> allOrderList(Long fromId, Long startTime, Long endTime, Integer limit, Long recvWindow) throws ApiException {
        Call localVarCall = this.allOrderListValidateBeforeCall(fromId, startTime, endTime, limit, recvWindow);
        Type localVarReturnType = new TypeToken<AllOrderListResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call allOrdersCall(String symbol, Long orderId, Long startTime, Long endTime, Integer limit, Long recvWindow) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/allOrders";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (symbol != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbol", (Object)symbol));
        }
        if (orderId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orderId", (Object)orderId));
        }
        if (startTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("startTime", (Object)startTime));
        }
        if (endTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("endTime", (Object)endTime));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", (Object)limit));
        }
        if (recvWindow != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("recvWindow", (Object)recvWindow));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("binanceSignature");
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call allOrdersValidateBeforeCall(String symbol, Long orderId, Long startTime, Long endTime, Integer limit, Long recvWindow) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{symbol, orderId, startTime, endTime, limit, recvWindow};
            Method method = this.getClass().getMethod("allOrders", String.class, Long.class, Long.class, Long.class, Integer.class, Long.class);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.allOrdersCall(symbol, orderId, startTime, endTime, limit, recvWindow);
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<AllOrdersResponse> allOrders(@NotNull String symbol, Long orderId, Long startTime, Long endTime, Integer limit, Long recvWindow) throws ApiException {
        Call localVarCall = this.allOrdersValidateBeforeCall(symbol, orderId, startTime, endTime, limit, recvWindow);
        Type localVarReturnType = new TypeToken<AllOrdersResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getAccountCall(Boolean omitZeroBalances, Long recvWindow) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/account";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (omitZeroBalances != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("omitZeroBalances", (Object)omitZeroBalances));
        }
        if (recvWindow != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("recvWindow", (Object)recvWindow));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("binanceSignature");
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call getAccountValidateBeforeCall(Boolean omitZeroBalances, Long recvWindow) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{omitZeroBalances, recvWindow};
            Method method = this.getClass().getMethod("getAccount", Boolean.class, Long.class);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.getAccountCall(omitZeroBalances, recvWindow);
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<GetAccountResponse> getAccount(Boolean omitZeroBalances, Long recvWindow) throws ApiException {
        Call localVarCall = this.getAccountValidateBeforeCall(omitZeroBalances, recvWindow);
        Type localVarReturnType = new TypeToken<GetAccountResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getOpenOrdersCall(String symbol, Long recvWindow) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/openOrders";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (symbol != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbol", (Object)symbol));
        }
        if (recvWindow != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("recvWindow", (Object)recvWindow));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("binanceSignature");
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call getOpenOrdersValidateBeforeCall(String symbol, Long recvWindow) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{symbol, recvWindow};
            Method method = this.getClass().getMethod("getOpenOrders", String.class, Long.class);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.getOpenOrdersCall(symbol, recvWindow);
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<GetOpenOrdersResponse> getOpenOrders(String symbol, Long recvWindow) throws ApiException {
        Call localVarCall = this.getOpenOrdersValidateBeforeCall(symbol, recvWindow);
        Type localVarReturnType = new TypeToken<GetOpenOrdersResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getOrderCall(String symbol, Long orderId, String origClientOrderId, Long recvWindow) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/order";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (symbol != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbol", (Object)symbol));
        }
        if (orderId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orderId", (Object)orderId));
        }
        if (origClientOrderId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("origClientOrderId", (Object)origClientOrderId));
        }
        if (recvWindow != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("recvWindow", (Object)recvWindow));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("binanceSignature");
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call getOrderValidateBeforeCall(String symbol, Long orderId, String origClientOrderId, Long recvWindow) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{symbol, orderId, origClientOrderId, recvWindow};
            Method method = this.getClass().getMethod("getOrder", String.class, Long.class, String.class, Long.class);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.getOrderCall(symbol, orderId, origClientOrderId, recvWindow);
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<GetOrderResponse> getOrder(@NotNull String symbol, Long orderId, String origClientOrderId, Long recvWindow) throws ApiException {
        Call localVarCall = this.getOrderValidateBeforeCall(symbol, orderId, origClientOrderId, recvWindow);
        Type localVarReturnType = new TypeToken<GetOrderResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getOrderListCall(Long orderListId, String origClientOrderId, Long recvWindow) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/orderList";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (orderListId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orderListId", (Object)orderListId));
        }
        if (origClientOrderId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("origClientOrderId", (Object)origClientOrderId));
        }
        if (recvWindow != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("recvWindow", (Object)recvWindow));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("binanceSignature");
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call getOrderListValidateBeforeCall(Long orderListId, String origClientOrderId, Long recvWindow) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{orderListId, origClientOrderId, recvWindow};
            Method method = this.getClass().getMethod("getOrderList", Long.class, String.class, Long.class);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.getOrderListCall(orderListId, origClientOrderId, recvWindow);
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<GetOrderListResponse> getOrderList(Long orderListId, String origClientOrderId, Long recvWindow) throws ApiException {
        Call localVarCall = this.getOrderListValidateBeforeCall(orderListId, origClientOrderId, recvWindow);
        Type localVarReturnType = new TypeToken<GetOrderListResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call myAllocationsCall(String symbol, Long startTime, Long endTime, Integer fromAllocationId, Integer limit, Long orderId, Long recvWindow) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/myAllocations";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (symbol != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbol", (Object)symbol));
        }
        if (startTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("startTime", (Object)startTime));
        }
        if (endTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("endTime", (Object)endTime));
        }
        if (fromAllocationId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fromAllocationId", (Object)fromAllocationId));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", (Object)limit));
        }
        if (orderId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orderId", (Object)orderId));
        }
        if (recvWindow != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("recvWindow", (Object)recvWindow));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("binanceSignature");
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call myAllocationsValidateBeforeCall(String symbol, Long startTime, Long endTime, Integer fromAllocationId, Integer limit, Long orderId, Long recvWindow) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{symbol, startTime, endTime, fromAllocationId, limit, orderId, recvWindow};
            Method method = this.getClass().getMethod("myAllocations", String.class, Long.class, Long.class, Integer.class, Integer.class, Long.class, Long.class);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.myAllocationsCall(symbol, startTime, endTime, fromAllocationId, limit, orderId, recvWindow);
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<MyAllocationsResponse> myAllocations(@NotNull String symbol, Long startTime, Long endTime, Integer fromAllocationId, Integer limit, Long orderId, Long recvWindow) throws ApiException {
        Call localVarCall = this.myAllocationsValidateBeforeCall(symbol, startTime, endTime, fromAllocationId, limit, orderId, recvWindow);
        Type localVarReturnType = new TypeToken<MyAllocationsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call myPreventedMatchesCall(String symbol, Long preventedMatchId, Long orderId, Long fromPreventedMatchId, Integer limit, Long recvWindow) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/myPreventedMatches";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (symbol != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbol", (Object)symbol));
        }
        if (preventedMatchId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("preventedMatchId", (Object)preventedMatchId));
        }
        if (orderId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orderId", (Object)orderId));
        }
        if (fromPreventedMatchId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fromPreventedMatchId", (Object)fromPreventedMatchId));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", (Object)limit));
        }
        if (recvWindow != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("recvWindow", (Object)recvWindow));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("binanceSignature");
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call myPreventedMatchesValidateBeforeCall(String symbol, Long preventedMatchId, Long orderId, Long fromPreventedMatchId, Integer limit, Long recvWindow) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{symbol, preventedMatchId, orderId, fromPreventedMatchId, limit, recvWindow};
            Method method = this.getClass().getMethod("myPreventedMatches", String.class, Long.class, Long.class, Long.class, Integer.class, Long.class);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.myPreventedMatchesCall(symbol, preventedMatchId, orderId, fromPreventedMatchId, limit, recvWindow);
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<MyPreventedMatchesResponse> myPreventedMatches(@NotNull String symbol, Long preventedMatchId, Long orderId, Long fromPreventedMatchId, Integer limit, Long recvWindow) throws ApiException {
        Call localVarCall = this.myPreventedMatchesValidateBeforeCall(symbol, preventedMatchId, orderId, fromPreventedMatchId, limit, recvWindow);
        Type localVarReturnType = new TypeToken<MyPreventedMatchesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call myTradesCall(String symbol, Long orderId, Long startTime, Long endTime, Long fromId, Integer limit, Long recvWindow) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/myTrades";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (symbol != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbol", (Object)symbol));
        }
        if (orderId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orderId", (Object)orderId));
        }
        if (startTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("startTime", (Object)startTime));
        }
        if (endTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("endTime", (Object)endTime));
        }
        if (fromId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fromId", (Object)fromId));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", (Object)limit));
        }
        if (recvWindow != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("recvWindow", (Object)recvWindow));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("binanceSignature");
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call myTradesValidateBeforeCall(String symbol, Long orderId, Long startTime, Long endTime, Long fromId, Integer limit, Long recvWindow) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{symbol, orderId, startTime, endTime, fromId, limit, recvWindow};
            Method method = this.getClass().getMethod("myTrades", String.class, Long.class, Long.class, Long.class, Long.class, Integer.class, Long.class);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.myTradesCall(symbol, orderId, startTime, endTime, fromId, limit, recvWindow);
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<MyTradesResponse> myTrades(@NotNull String symbol, Long orderId, Long startTime, Long endTime, Long fromId, Integer limit, Long recvWindow) throws ApiException {
        Call localVarCall = this.myTradesValidateBeforeCall(symbol, orderId, startTime, endTime, fromId, limit, recvWindow);
        Type localVarReturnType = new TypeToken<MyTradesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call openOrderListCall(Long recvWindow) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/openOrderList";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (recvWindow != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("recvWindow", (Object)recvWindow));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("binanceSignature");
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call openOrderListValidateBeforeCall(Long recvWindow) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{recvWindow};
            Method method = this.getClass().getMethod("openOrderList", Long.class);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.openOrderListCall(recvWindow);
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<OpenOrderListResponse> openOrderList(Long recvWindow) throws ApiException {
        Call localVarCall = this.openOrderListValidateBeforeCall(recvWindow);
        Type localVarReturnType = new TypeToken<OpenOrderListResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call orderAmendmentsCall(String symbol, Long orderId, Long fromExecutionId, Long limit, Long recvWindow) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/order/amendments";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (symbol != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbol", (Object)symbol));
        }
        if (orderId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orderId", (Object)orderId));
        }
        if (fromExecutionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fromExecutionId", (Object)fromExecutionId));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", (Object)limit));
        }
        if (recvWindow != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("recvWindow", (Object)recvWindow));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("binanceSignature");
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call orderAmendmentsValidateBeforeCall(String symbol, Long orderId, Long fromExecutionId, Long limit, Long recvWindow) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{symbol, orderId, fromExecutionId, limit, recvWindow};
            Method method = this.getClass().getMethod("orderAmendments", String.class, Long.class, Long.class, Long.class, Long.class);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.orderAmendmentsCall(symbol, orderId, fromExecutionId, limit, recvWindow);
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<OrderAmendmentsResponse> orderAmendments(@NotNull String symbol, @NotNull Long orderId, Long fromExecutionId, Long limit, Long recvWindow) throws ApiException {
        Call localVarCall = this.orderAmendmentsValidateBeforeCall(symbol, orderId, fromExecutionId, limit, recvWindow);
        Type localVarReturnType = new TypeToken<OrderAmendmentsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call rateLimitOrderCall(Long recvWindow) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/rateLimit/order";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (recvWindow != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("recvWindow", (Object)recvWindow));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("binanceSignature");
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call rateLimitOrderValidateBeforeCall(Long recvWindow) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{recvWindow};
            Method method = this.getClass().getMethod("rateLimitOrder", Long.class);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.rateLimitOrderCall(recvWindow);
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<RateLimitOrderResponse> rateLimitOrder(Long recvWindow) throws ApiException {
        Call localVarCall = this.rateLimitOrderValidateBeforeCall(recvWindow);
        Type localVarReturnType = new TypeToken<RateLimitOrderResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }
}

