/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.common.websocket.dtos;

public class BaseRequestDTO {
    private String apiKey;
    private String timestamp;
    private String signature;

    public BaseRequestDTO() {
    }

    public BaseRequestDTO(String apiKey, String timestamp, String signature) {
        this.apiKey = apiKey;
        this.timestamp = timestamp;
        this.signature = signature;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String toUrlQueryString() {
        return "apiKey=" + this.apiKey + "&timestamp=" + this.timestamp;
    }

    public String toString() {
        return "apiKey=" + this.apiKey + "&timestamp=" + this.timestamp;
    }

    private BaseRequestDTO(Builder builder) {
        this.apiKey = builder.apiKey;
        this.timestamp = builder.timestamp;
        this.signature = builder.signature;
    }

    public static final class Builder {
        private String apiKey;
        private String timestamp;
        private String signature;

        public Builder apiKey(String val) {
            this.apiKey = val;
            return this;
        }

        public Builder timestamp(String val) {
            this.timestamp = val;
            return this;
        }

        public Builder signature(String val) {
            this.signature = val;
            return this;
        }

        public BaseRequestDTO build() {
            return new BaseRequestDTO(this);
        }
    }
}

