/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.common;

import com.binance.connector.client.common.ServerVariable;
import java.util.Map;

public class ServerConfiguration {
    private final String URL;
    private final String description;
    private final Map<String, ServerVariable> variables;

    public ServerConfiguration(String url, String description, Map<String, ServerVariable> variables) {
        this.URL = url;
        this.description = description;
        this.variables = variables;
    }

    public String setURL(Map<String, String> variables) {
        String url = this.URL;
        for (Map.Entry<String, ServerVariable> variable : this.variables.entrySet()) {
            String name = variable.getKey();
            ServerVariable serverVariable = variable.getValue();
            String value = serverVariable.getDefaultValue();
            if (variables != null && variables.containsKey(name)) {
                value = variables.get(name);
                if (!serverVariable.getEnumValues().isEmpty() && !serverVariable.getEnumValues().contains(value)) {
                    throw new IllegalArgumentException("The variable " + name + " in the server URL has invalid value " + value + ".");
                }
            }
            url = url.replace("{" + name + "}", value);
        }
        return url;
    }
}

