/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.common;

import com.binance.connector.client.common.AcceptEncodingInterceptor;
import com.binance.connector.client.common.ApiCallback;
import com.binance.connector.client.common.ApiException;
import com.binance.connector.client.common.ApiResponse;
import com.binance.connector.client.common.JSON;
import com.binance.connector.client.common.Pair;
import com.binance.connector.client.common.ProgressResponseBody;
import com.binance.connector.client.common.ServerConfiguration;
import com.binance.connector.client.common.ServerVariable;
import com.binance.connector.client.common.StringUtil;
import com.binance.connector.client.common.SystemUtil;
import com.binance.connector.client.common.auth.ApiKeyAuth;
import com.binance.connector.client.common.auth.Authentication;
import com.binance.connector.client.common.auth.BinanceAuthenticationFactory;
import com.binance.connector.client.common.auth.HttpBasicAuth;
import com.binance.connector.client.common.configuration.ClientConfiguration;
import com.binance.connector.client.common.configuration.SignatureConfiguration;
import com.binance.connector.client.common.dtos.RateLimit;
import com.binance.connector.client.common.dtos.RateLimitInterval;
import com.binance.connector.client.common.dtos.RateLimitType;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpMethod;
import okhttp3.internal.tls.OkHostnameVerifier;
import okhttp3.logging.HttpLoggingInterceptor;
import okio.Buffer;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.apache.commons.lang3.StringUtils;

public class ApiClient {
    public static final int MIN_FILENAME_SIZE = 3;
    public static final int HTTP_TEA_POT = 418;
    public static final int HTTP_TOO_MANY_REQS = 429;
    private static final int DIFF_TILL_POSITION_INDEX = 1;
    private static final Pattern PATTERN_USED_WEIGHT = Pattern.compile("x-mbx-used-weight-([0-9]+)([shmd])");
    private static final Pattern PATTERN_ORDER_COUNT = Pattern.compile("x-mbx-order-count-([0-9]+)([smhd])");
    private static final String HEADER_TIMEUNIT = "X-MBX-TIME-UNIT";
    private static final String HEADER_API_KEY = "X-MBX-APIKEY";
    private String basePath = "https://api.binance.com";
    protected List<ServerConfiguration> servers = new ArrayList<ServerConfiguration>(Arrays.asList(new ServerConfiguration("https://api.binance.com", "No description provided", new HashMap<String, ServerVariable>()), new ServerConfiguration("https://testnet.binance.vision", "No description provided", new HashMap<String, ServerVariable>())));
    protected Integer serverIndex = 0;
    protected Map<String, String> serverVariables = null;
    private boolean debugging = false;
    private final Map<String, String> defaultHeaderMap = new HashMap<String, String>();
    private final Map<String, String> defaultCookieMap = new HashMap<String, String>();
    private String tempFolderPath = null;
    private Map<String, Authentication> authentications;
    private InputStream sslCaCert;
    private boolean verifyingSsl;
    private KeyManager[] keyManagers;
    private OkHttpClient httpClient;
    private HttpLoggingInterceptor loggingInterceptor;
    private Gson json;

    public ApiClient(ClientConfiguration configuration) {
        this(configuration, new BinanceAuthenticationFactory(), null);
    }

    public ApiClient(ClientConfiguration configuration, BinanceAuthenticationFactory binanceAuthenticationFactory) {
        this(configuration, binanceAuthenticationFactory, null);
    }

    public ApiClient(ClientConfiguration configuration, OkHttpClient okHttpClient) {
        this(configuration, new BinanceAuthenticationFactory(), okHttpClient);
    }

    public ApiClient(ClientConfiguration configuration, BinanceAuthenticationFactory binanceAuthenticationFactory, OkHttpClient okHttpClient) {
        if (StringUtils.isNotEmpty((CharSequence)configuration.getUrl())) {
            this.basePath = configuration.getUrl();
            this.serverIndex = null;
        }
        this.init();
        Interceptor retryInterceptor = this.getRetryInterceptor(configuration.getRetries(), configuration.getBackOff());
        OkHttpClient.Builder builder = okHttpClient != null ? okHttpClient.newBuilder() : new OkHttpClient.Builder();
        builder.addInterceptor(retryInterceptor);
        if (configuration.getConnectTimeout() != null) {
            builder.connectTimeout((long)configuration.getConnectTimeout().intValue(), TimeUnit.MILLISECONDS);
        }
        if (configuration.getReadTimeout() != null) {
            builder.readTimeout((long)configuration.getReadTimeout().intValue(), TimeUnit.MILLISECONDS);
        }
        if (configuration.getCertificatePinner() != null) {
            builder.certificatePinner(configuration.getCertificatePinner());
        }
        if (configuration.getProxy() != null) {
            builder.proxy(configuration.getProxy());
            if (configuration.getProxyAuthenticator() != null) {
                builder.proxyAuthenticator(configuration.getProxyAuthenticator());
            }
        }
        if (!configuration.getCompression().booleanValue()) {
            builder.addNetworkInterceptor((Interceptor)new AcceptEncodingInterceptor());
        }
        this.httpClient = builder.build();
        Authentication timeUnit = (queryParams, headerParams, cookieParams, payload, method, uri) -> {
            if (configuration.getTimeUnit() != null && !headerParams.containsKey(HEADER_TIMEUNIT)) {
                headerParams.put(HEADER_TIMEUNIT, configuration.getTimeUnit().toString());
            }
        };
        this.authentications.put("timeUnit", timeUnit);
        SignatureConfiguration signatureConfiguration = configuration.getSignatureConfiguration();
        if (signatureConfiguration != null) {
            Authentication authentication = binanceAuthenticationFactory.getAuthentication(signatureConfiguration);
            if (authentication != null) {
                this.authentications.put("binanceSignature", authentication);
            }
            Authentication binanceApiKeyOnly = (queryParams, headerParams, cookieParams, payload, method, uri) -> headerParams.put(HEADER_API_KEY, signatureConfiguration.getApiKey());
            this.authentications.put("binanceApiKeyOnly", binanceApiKeyOnly);
        }
    }

    private void init() {
        this.verifyingSsl = true;
        String userAgent = String.format("binance-connector-java/1.0.0 (Java/%s; %s; %s)", SystemUtil.getJavaVersion(), SystemUtil.getOs(), SystemUtil.getArch());
        this.setUserAgent(userAgent);
        this.authentications = new HashMap<String, Authentication>();
    }

    public Gson getJson() {
        return this.json;
    }

    public void setJson(Gson json) {
        this.json = json;
    }

    public Interceptor getRetryInterceptor(Integer retryCount, Integer retryBackoff) {
        return chain -> {
            Request request = chain.request();
            Response response = chain.proceed(request);
            for (int tryCount = 0; this.shouldRetry(request, response) && tryCount < retryCount; ++tryCount) {
                try {
                    Thread.sleep(retryBackoff * tryCount);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                response.close();
                response = chain.proceed(request);
            }
            return response;
        };
    }

    private boolean shouldRetry(Request request, Response response) {
        boolean retryMethod = Arrays.asList("GET", "DELETE").contains(request.method());
        boolean serverError = response.code() >= 500;
        return retryMethod && serverError;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public ApiClient setBasePath(String basePath) {
        this.basePath = basePath;
        this.serverIndex = null;
        return this;
    }

    public List<ServerConfiguration> getServers() {
        return this.servers;
    }

    public ApiClient setServers(List<ServerConfiguration> servers) {
        this.servers = servers;
        return this;
    }

    public Integer getServerIndex() {
        return this.serverIndex;
    }

    public ApiClient setServerIndex(Integer serverIndex) {
        this.serverIndex = serverIndex;
        return this;
    }

    public Map<String, String> getServerVariables() {
        return this.serverVariables;
    }

    public ApiClient setServerVariables(Map<String, String> serverVariables) {
        this.serverVariables = serverVariables;
        return this;
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public ApiClient setHttpClient(OkHttpClient newHttpClient) {
        this.httpClient = Objects.requireNonNull(newHttpClient, "HttpClient must not be null!");
        return this;
    }

    public boolean isVerifyingSsl() {
        return this.verifyingSsl;
    }

    public ApiClient setVerifyingSsl(boolean verifyingSsl) {
        this.verifyingSsl = verifyingSsl;
        this.applySslSettings();
        return this;
    }

    public InputStream getSslCaCert() {
        return this.sslCaCert;
    }

    public ApiClient setSslCaCert(InputStream sslCaCert) {
        this.sslCaCert = sslCaCert;
        this.applySslSettings();
        return this;
    }

    public KeyManager[] getKeyManagers() {
        return this.keyManagers;
    }

    public ApiClient setKeyManagers(KeyManager[] managers) {
        this.keyManagers = managers;
        this.applySslSettings();
        return this;
    }

    public ApiClient setDateFormat(DateFormat dateFormat) {
        JSON.setDateFormat(dateFormat);
        return this;
    }

    public ApiClient setSqlDateFormat(DateFormat dateFormat) {
        JSON.setSqlDateFormat(dateFormat);
        return this;
    }

    public ApiClient setOffsetDateTimeFormat(DateTimeFormatter dateFormat) {
        JSON.setOffsetDateTimeFormat(dateFormat);
        return this;
    }

    public ApiClient setLocalDateFormat(DateTimeFormatter dateFormat) {
        JSON.setLocalDateFormat(dateFormat);
        return this;
    }

    public ApiClient setLenientOnJson(boolean lenientOnJson) {
        JSON.setLenientOnJson(lenientOnJson);
        return this;
    }

    public Map<String, Authentication> getAuthentications() {
        return this.authentications;
    }

    public Authentication getAuthentication(String authName) {
        return this.authentications.get(authName);
    }

    public void setUsername(String username) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HttpBasicAuth)) continue;
            ((HttpBasicAuth)auth).setUsername(username);
            return;
        }
        throw new RuntimeException("No HTTP basic authentication configured!");
    }

    public void setPassword(String password) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HttpBasicAuth)) continue;
            ((HttpBasicAuth)auth).setPassword(password);
            return;
        }
        throw new RuntimeException("No HTTP basic authentication configured!");
    }

    public void setApiKey(String apiKey) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof ApiKeyAuth)) continue;
            ((ApiKeyAuth)auth).setApiKey(apiKey);
            return;
        }
        throw new RuntimeException("No API key authentication configured!");
    }

    public void setApiKeyPrefix(String apiKeyPrefix) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof ApiKeyAuth)) continue;
            ((ApiKeyAuth)auth).setApiKeyPrefix(apiKeyPrefix);
            return;
        }
        throw new RuntimeException("No API key authentication configured!");
    }

    public void setAccessToken(String accessToken) {
        throw new RuntimeException("No OAuth2 authentication configured!");
    }

    public void setAWS4Configuration(String accessKey, String secretKey, String region, String service) {
        throw new RuntimeException("No AWS4 authentication configured!");
    }

    public void setAWS4Configuration(String accessKey, String secretKey, String sessionToken, String region, String service) {
        throw new RuntimeException("No AWS4 authentication configured!");
    }

    public ApiClient setUserAgent(String userAgent) {
        this.addDefaultHeader("User-Agent", userAgent);
        return this;
    }

    public ApiClient addDefaultHeader(String key, String value) {
        this.defaultHeaderMap.put(key, value);
        return this;
    }

    public ApiClient addDefaultCookie(String key, String value) {
        this.defaultCookieMap.put(key, value);
        return this;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public ApiClient setDebugging(boolean debugging) {
        if (debugging != this.debugging) {
            if (debugging) {
                this.loggingInterceptor = new HttpLoggingInterceptor();
                this.loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
                this.httpClient = this.httpClient.newBuilder().addInterceptor((Interceptor)this.loggingInterceptor).build();
            } else {
                OkHttpClient.Builder builder = this.httpClient.newBuilder();
                builder.interceptors().remove(this.loggingInterceptor);
                this.httpClient = builder.build();
                this.loggingInterceptor = null;
            }
        }
        this.debugging = debugging;
        return this;
    }

    public String getTempFolderPath() {
        return this.tempFolderPath;
    }

    public ApiClient setTempFolderPath(String tempFolderPath) {
        this.tempFolderPath = tempFolderPath;
        return this;
    }

    public int getConnectTimeout() {
        return this.httpClient.connectTimeoutMillis();
    }

    public ApiClient setConnectTimeout(int connectionTimeout) {
        this.httpClient = this.httpClient.newBuilder().connectTimeout((long)connectionTimeout, TimeUnit.MILLISECONDS).build();
        return this;
    }

    public int getReadTimeout() {
        return this.httpClient.readTimeoutMillis();
    }

    public ApiClient setReadTimeout(int readTimeout) {
        this.httpClient = this.httpClient.newBuilder().readTimeout((long)readTimeout, TimeUnit.MILLISECONDS).build();
        return this;
    }

    public int getWriteTimeout() {
        return this.httpClient.writeTimeoutMillis();
    }

    public ApiClient setWriteTimeout(int writeTimeout) {
        this.httpClient = this.httpClient.newBuilder().writeTimeout((long)writeTimeout, TimeUnit.MILLISECONDS).build();
        return this;
    }

    public String parameterToString(Object param) {
        if (param == null) {
            return "";
        }
        if (param instanceof Date || param instanceof OffsetDateTime || param instanceof LocalDate) {
            String jsonStr = JSON.serialize(param);
            return jsonStr.substring(1, jsonStr.length() - 1);
        }
        if (param instanceof Collection) {
            StringBuilder b = new StringBuilder();
            for (Object o : (Collection)param) {
                if (b.length() > 0) {
                    b.append(",");
                }
                b.append(o);
            }
            return b.toString();
        }
        return String.valueOf(param);
    }

    public List<Pair> parameterToPair(String name, Object value) {
        ArrayList<Pair> params = new ArrayList<Pair>();
        if (name == null || name.isEmpty() || value == null || value instanceof Collection) {
            return params;
        }
        params.add(new Pair(name, this.parameterToString(value)));
        return params;
    }

    public List<Pair> parameterToPairs(String collectionFormat, String name, Collection value) {
        ArrayList<Pair> params = new ArrayList<Pair>();
        if (name == null || name.isEmpty() || value == null || value.isEmpty()) {
            return params;
        }
        if ("multi".equals(collectionFormat)) {
            for (Object item : value) {
                params.add(new Pair(name, this.escapeString(this.parameterToString(item))));
            }
            return params;
        }
        String delimiter = ",";
        if ("ssv".equals(collectionFormat)) {
            delimiter = this.escapeString(" ");
        } else if ("tsv".equals(collectionFormat)) {
            delimiter = this.escapeString("\t");
        } else if ("pipes".equals(collectionFormat)) {
            delimiter = this.escapeString("|");
        }
        StringBuilder sb = new StringBuilder();
        for (Object item : value) {
            sb.append(delimiter);
            sb.append(this.escapeString(this.parameterToString(item)));
        }
        params.add(new Pair(name, sb.substring(delimiter.length())));
        return params;
    }

    public List<Pair> freeFormParameterToPairs(Object value) {
        ArrayList<Pair> params = new ArrayList<Pair>();
        if (value == null || !(value instanceof Map)) {
            return params;
        }
        Map valuesMap = (Map)value;
        for (Map.Entry entry : valuesMap.entrySet()) {
            params.add(new Pair((String)entry.getKey(), this.parameterToString(entry.getValue())));
        }
        return params;
    }

    public String collectionPathParameterToString(String collectionFormat, Collection value) {
        if ("multi".equals(collectionFormat)) {
            return this.parameterToString(value);
        }
        String delimiter = ",";
        if ("ssv".equals(collectionFormat)) {
            delimiter = " ";
        } else if ("tsv".equals(collectionFormat)) {
            delimiter = "\t";
        } else if ("pipes".equals(collectionFormat)) {
            delimiter = "|";
        }
        StringBuilder sb = new StringBuilder();
        for (Object item : value) {
            sb.append(delimiter);
            sb.append(this.parameterToString(item));
        }
        return sb.substring(delimiter.length());
    }

    public String sanitizeFilename(String filename) {
        return filename.replaceAll(".*[/\\\\]", "");
    }

    public boolean isJsonMime(String mime) {
        String jsonMime = "(?i)^(application/json|[^;/ \t]+/[^;/ \t]+[+]json)[ \t]*(;.*)?$";
        return mime != null && (mime.matches(jsonMime) || mime.equals("*/*"));
    }

    public String selectHeaderAccept(String[] accepts) {
        if (accepts.length == 0) {
            return null;
        }
        for (String accept : accepts) {
            if (!this.isJsonMime(accept)) continue;
            return accept;
        }
        return StringUtil.join(accepts, ",");
    }

    public String selectHeaderContentType(String[] contentTypes) {
        if (contentTypes.length == 0) {
            return null;
        }
        if (contentTypes[0].equals("*/*")) {
            return "application/json";
        }
        for (String contentType : contentTypes) {
            if (!this.isJsonMime(contentType)) continue;
            return contentType;
        }
        return contentTypes[0];
    }

    public String escapeString(String str) {
        return URLEncoder.encode(str, StandardCharsets.UTF_8).replaceAll("\\+", "%20");
    }

    public <T> T deserialize(Response response, Type returnType) throws ApiException {
        String respBody;
        if (response == null || returnType == null) {
            return null;
        }
        if ("byte[]".equals(returnType.toString())) {
            try {
                return (T)response.body().bytes();
            }
            catch (IOException e) {
                throw new ApiException(e);
            }
        }
        if (returnType.equals(File.class)) {
            return (T)this.downloadFileFromResponse(response);
        }
        try {
            respBody = response.body() != null ? response.body().string() : null;
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (respBody == null || "".equals(respBody)) {
            return null;
        }
        String contentType = response.headers().get("Content-Type");
        if (contentType == null) {
            contentType = "application/json";
        }
        if (this.isJsonMime(contentType)) {
            if (this.json != null) {
                return (T)this.json.fromJson(respBody, returnType);
            }
            return JSON.deserialize(respBody, returnType);
        }
        if (returnType.equals(String.class)) {
            return (T)respBody;
        }
        throw new ApiException("Content type \"" + contentType + "\" is not supported for type: " + String.valueOf(returnType), response.code(), (Map<String, List<String>>)response.headers().toMultimap(), respBody);
    }

    public RequestBody serialize(Object obj, String contentType) throws ApiException {
        if (obj instanceof byte[]) {
            return RequestBody.create((byte[])((byte[])obj), (MediaType)MediaType.parse((String)contentType));
        }
        if (obj instanceof File) {
            return RequestBody.create((File)((File)obj), (MediaType)MediaType.parse((String)contentType));
        }
        if ("text/plain".equals(contentType) && obj instanceof String) {
            return RequestBody.create((String)((String)obj), (MediaType)MediaType.parse((String)contentType));
        }
        if (this.isJsonMime(contentType)) {
            String content = obj != null ? JSON.serialize(obj) : null;
            return RequestBody.create((String)content, (MediaType)MediaType.parse((String)contentType));
        }
        if (obj instanceof String) {
            return RequestBody.create((String)((String)obj), (MediaType)MediaType.parse((String)contentType));
        }
        throw new ApiException("Content type \"" + contentType + "\" is not supported");
    }

    public File downloadFileFromResponse(Response response) throws ApiException {
        try {
            File file = this.prepareDownloadFile(response);
            BufferedSink sink = Okio.buffer((Sink)Okio.sink((File)file));
            sink.writeAll((Source)response.body().source());
            sink.close();
            return file;
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    public File prepareDownloadFile(Response response) throws IOException {
        Pattern pattern;
        Matcher matcher;
        String filename = null;
        String contentDisposition = response.header("Content-Disposition");
        if (contentDisposition != null && !"".equals(contentDisposition) && (matcher = (pattern = Pattern.compile("filename=['\"]?([^'\"\\s]+)['\"]?")).matcher(contentDisposition)).find()) {
            filename = this.sanitizeFilename(matcher.group(1));
        }
        Object prefix = null;
        String suffix = null;
        if (filename == null) {
            prefix = "download-";
            suffix = "";
        } else {
            int pos = filename.lastIndexOf(".");
            if (pos == -1) {
                prefix = filename + "-";
            } else {
                prefix = filename.substring(0, pos) + "-";
                suffix = filename.substring(pos);
            }
            if (((String)prefix).length() < 3) {
                prefix = "download-";
            }
        }
        if (this.tempFolderPath == null) {
            return Files.createTempFile((String)prefix, suffix, new FileAttribute[0]).toFile();
        }
        return Files.createTempFile(Paths.get(this.tempFolderPath, new String[0]), (String)prefix, suffix, new FileAttribute[0]).toFile();
    }

    public <T> ApiResponse<T> execute(Call call) throws ApiException {
        return this.execute(call, null);
    }

    public <T> ApiResponse<T> execute(Call call, Type returnType) throws ApiException {
        try {
            Response response = call.execute();
            T data = this.handleResponse(response, returnType);
            Map<RateLimitType, RateLimit> rateLimit = this.getRateLimit(response.code(), response.headers());
            return new ApiResponse<T>(response.code(), response.headers().toMultimap(), data, rateLimit);
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    public <T> T handleResponse(Response response, Type returnType) throws ApiException {
        if (response.isSuccessful()) {
            if (returnType == null || response.code() == 204) {
                if (response.body() != null) {
                    try {
                        response.body().close();
                    }
                    catch (Exception e) {
                        throw new ApiException(response.message(), (Throwable)e, response.code(), response.headers().toMultimap());
                    }
                }
                return null;
            }
            return this.deserialize(response, returnType);
        }
        String respBody = null;
        if (response.body() != null) {
            try {
                respBody = response.body().string();
            }
            catch (IOException e) {
                throw new ApiException(response.message(), (Throwable)e, response.code(), response.headers().toMultimap());
            }
        }
        throw new ApiException(response.message(), response.code(), (Map<String, List<String>>)response.headers().toMultimap(), respBody);
    }

    public Call buildCall(String baseUrl, String path, String method, List<Pair> queryParams, List<Pair> collectionQueryParams, Object body, Map<String, String> headerParams, Map<String, String> cookieParams, Map<String, Object> formParams, String[] authNames) throws ApiException {
        Request request = this.buildRequest(baseUrl, path, method, queryParams, collectionQueryParams, body, headerParams, cookieParams, formParams, authNames);
        return this.httpClient.newCall(request);
    }

    public static String joinQueryParameters(List<Pair> params) {
        return ApiClient.joinQueryParameters(new StringBuilder(), params).toString();
    }

    public static StringBuilder joinQueryParameters(StringBuilder sb, List<Pair> params) {
        if (params != null && !params.isEmpty()) {
            for (Pair param : params) {
                String key = param.getName();
                String value = param.getValue();
                sb.append(key);
                sb.append("=");
                sb.append(ApiClient.urlEncode(value));
                sb.append("&");
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb;
    }

    public static String urlEncode(String s) {
        return URLEncoder.encode(s, StandardCharsets.UTF_8);
    }

    public String buildTimestamp() {
        return String.valueOf(System.currentTimeMillis());
    }

    public Request buildRequest(String baseUrl, String path, String method, List<Pair> queryParams, List<Pair> collectionQueryParams, Object body, Map<String, String> headerParams, Map<String, String> cookieParams, Map<String, Object> formParams, String[] authNames) throws ApiException {
        String url = this.buildUrl(baseUrl, path, queryParams, collectionQueryParams);
        String contentType = headerParams.get("Content-Type");
        String contentTypePure = contentType;
        if (contentTypePure != null && contentTypePure.contains(";")) {
            contentTypePure = contentType.substring(0, contentType.indexOf(";"));
        }
        Object reqBody = !HttpMethod.permitsRequestBody((String)method) ? null : ("application/x-www-form-urlencoded".equals(contentTypePure) ? this.buildRequestBodyFormEncoding(formParams) : ("multipart/form-data".equals(contentTypePure) ? this.buildRequestBodyMultipart(formParams) : (body == null ? ("DELETE".equals(method) ? null : RequestBody.create((String)"", (MediaType)(contentType == null ? null : MediaType.parse((String)contentType)))) : this.serialize(body, contentType))));
        ArrayList<Pair> updatedQueryParams = new ArrayList<Pair>(queryParams);
        this.updateParamsForAuth(authNames, updatedQueryParams, headerParams, cookieParams, this.requestBodyToString((RequestBody)reqBody), method, URI.create(url));
        Request.Builder reqBuilder = new Request.Builder().url(this.buildUrl(baseUrl, path, updatedQueryParams, collectionQueryParams));
        this.processHeaderParams(headerParams, reqBuilder);
        this.processCookieParams(cookieParams, reqBuilder);
        return reqBuilder.method(method, reqBody).build();
    }

    public String buildUrl(String baseUrl, String path, List<Pair> queryParams, List<Pair> collectionQueryParams) {
        String value;
        String prefix;
        StringBuilder url = new StringBuilder();
        if (baseUrl != null) {
            url.append(baseUrl).append(path);
        } else {
            String baseURL;
            if (this.serverIndex != null) {
                if (this.serverIndex < 0 || this.serverIndex >= this.servers.size()) {
                    throw new ArrayIndexOutOfBoundsException(String.format("Invalid index %d when selecting the host settings. Must be less than %d", this.serverIndex, this.servers.size()));
                }
                baseURL = this.servers.get(this.serverIndex).setURL(this.serverVariables);
            } else {
                baseURL = this.basePath;
            }
            url.append(baseURL).append(path);
        }
        if (queryParams != null && !queryParams.isEmpty()) {
            prefix = path.contains("?") ? "&" : "?";
            for (Pair param : queryParams) {
                if (param.getValue() == null) continue;
                if (prefix != null) {
                    url.append(prefix);
                    prefix = null;
                } else {
                    url.append("&");
                }
                value = this.parameterToString(param.getValue());
                url.append(this.escapeString(param.getName())).append("=").append(this.escapeString(value));
            }
        }
        if (collectionQueryParams != null && !collectionQueryParams.isEmpty()) {
            prefix = url.toString().contains("?") ? "&" : "?";
            for (Pair param : collectionQueryParams) {
                if (param.getValue() == null) continue;
                if (prefix != null) {
                    url.append(prefix);
                    prefix = null;
                } else {
                    url.append("&");
                }
                value = this.parameterToString(param.getValue());
                url.append(this.escapeString(param.getName())).append("=").append(value);
            }
        }
        return url.toString();
    }

    public void processHeaderParams(Map<String, String> headerParams, Request.Builder reqBuilder) {
        for (Map.Entry<String, String> param : headerParams.entrySet()) {
            reqBuilder.header(param.getKey(), this.parameterToString(param.getValue()));
        }
        for (Map.Entry<String, String> header : this.defaultHeaderMap.entrySet()) {
            if (headerParams.containsKey(header.getKey())) continue;
            reqBuilder.header(header.getKey(), this.parameterToString(header.getValue()));
        }
    }

    public void processCookieParams(Map<String, String> cookieParams, Request.Builder reqBuilder) {
        for (Map.Entry<String, String> param : cookieParams.entrySet()) {
            reqBuilder.addHeader("Cookie", String.format("%s=%s", param.getKey(), param.getValue()));
        }
        for (Map.Entry<String, String> param : this.defaultCookieMap.entrySet()) {
            if (cookieParams.containsKey(param.getKey())) continue;
            reqBuilder.addHeader("Cookie", String.format("%s=%s", param.getKey(), param.getValue()));
        }
    }

    public void updateParamsForAuth(String[] authNames, List<Pair> queryParams, Map<String, String> headerParams, Map<String, String> cookieParams, String payload, String method, URI uri) throws ApiException {
        for (String authName : authNames) {
            Authentication auth = this.authentications.get(authName);
            if (auth == null) {
                throw new RuntimeException("Authentication undefined: " + authName);
            }
            try {
                auth.applyToParams(queryParams, headerParams, cookieParams, payload, method, uri);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public RequestBody buildRequestBodyFormEncoding(Map<String, Object> formParams) {
        FormBody.Builder formBuilder = new FormBody.Builder();
        for (Map.Entry<String, Object> param : formParams.entrySet()) {
            formBuilder.add(param.getKey(), this.parameterToString(param.getValue()));
        }
        return formBuilder.build();
    }

    public RequestBody buildRequestBodyMultipart(Map<String, Object> formParams) {
        MultipartBody.Builder mpBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        for (Map.Entry<String, Object> param : formParams.entrySet()) {
            if (param.getValue() instanceof File) {
                File file = (File)param.getValue();
                this.addPartToMultiPartBuilder(mpBuilder, param.getKey(), file);
                continue;
            }
            if (param.getValue() instanceof List) {
                List list = (List)param.getValue();
                for (Object item : list) {
                    if (item instanceof File) {
                        this.addPartToMultiPartBuilder(mpBuilder, param.getKey(), (File)item);
                        continue;
                    }
                    this.addPartToMultiPartBuilder(mpBuilder, param.getKey(), param.getValue());
                }
                continue;
            }
            this.addPartToMultiPartBuilder(mpBuilder, param.getKey(), param.getValue());
        }
        return mpBuilder.build();
    }

    public String guessContentTypeFromFile(File file) {
        String contentType = URLConnection.guessContentTypeFromName(file.getName());
        if (contentType == null) {
            return "application/octet-stream";
        }
        return contentType;
    }

    private void addPartToMultiPartBuilder(MultipartBody.Builder mpBuilder, String key, File file) {
        Headers partHeaders = Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + key + "\"; filename=\"" + file.getName() + "\""});
        MediaType mediaType = MediaType.parse((String)this.guessContentTypeFromFile(file));
        mpBuilder.addPart(partHeaders, RequestBody.create((File)file, (MediaType)mediaType));
    }

    private void addPartToMultiPartBuilder(MultipartBody.Builder mpBuilder, String key, Object obj) {
        RequestBody requestBody;
        if (obj instanceof String) {
            requestBody = RequestBody.create((String)((String)obj), (MediaType)MediaType.parse((String)"text/plain"));
        } else {
            String content = obj != null ? JSON.serialize(obj) : null;
            requestBody = RequestBody.create((String)content, (MediaType)MediaType.parse((String)"application/json"));
        }
        Headers partHeaders = Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + key + "\""});
        mpBuilder.addPart(partHeaders, requestBody);
    }

    private Interceptor getProgressInterceptor() {
        return new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request request = chain.request();
                Response originalResponse = chain.proceed(request);
                if (request.tag() instanceof ApiCallback) {
                    ApiCallback callback = (ApiCallback)request.tag();
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), callback)).build();
                }
                return originalResponse;
            }
        };
    }

    private void applySslSettings() {
        try {
            HostnameVerifier hostnameVerifier;
            TrustManager[] trustManagers;
            if (!this.verifyingSsl) {
                trustManagers = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }
                }};
                hostnameVerifier = new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                };
            } else {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                if (this.sslCaCert == null) {
                    trustManagerFactory.init((KeyStore)null);
                } else {
                    char[] password = null;
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    Collection<? extends Certificate> certificates = certificateFactory.generateCertificates(this.sslCaCert);
                    if (certificates.isEmpty()) {
                        throw new IllegalArgumentException("expected non-empty set of trusted certificates");
                    }
                    KeyStore caKeyStore = this.newEmptyKeyStore(password);
                    int index = 0;
                    for (Certificate certificate : certificates) {
                        String certificateAlias = "ca" + index++;
                        caKeyStore.setCertificateEntry(certificateAlias, certificate);
                    }
                    trustManagerFactory.init(caKeyStore);
                }
                trustManagers = trustManagerFactory.getTrustManagers();
                hostnameVerifier = OkHostnameVerifier.INSTANCE;
            }
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(this.keyManagers, trustManagers, new SecureRandom());
            this.httpClient = this.httpClient.newBuilder().sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)trustManagers[0]).hostnameVerifier(hostnameVerifier).build();
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private KeyStore newEmptyKeyStore(char[] password) throws GeneralSecurityException {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, password);
            return keyStore;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private String requestBodyToString(RequestBody requestBody) throws ApiException {
        if (requestBody != null) {
            try {
                Buffer buffer = new Buffer();
                requestBody.writeTo((BufferedSink)buffer);
                return buffer.readUtf8();
            }
            catch (IOException e) {
                throw new ApiException(e);
            }
        }
        return "";
    }

    private Map<RateLimitType, RateLimit> getRateLimit(Integer responseCode, Headers headers) {
        HashMap<RateLimitType, RateLimit> rateLimitMap = new HashMap<RateLimitType, RateLimit>();
        Integer retryAfter = null;
        if (Arrays.asList(418, 429).contains(responseCode)) {
            retryAfter = Integer.valueOf(headers.get("retry-after"));
        }
        for (String name : headers.names()) {
            if (name.startsWith("x-mbx-used-weight-")) {
                RateLimit usedWeightRateLimit = this.getRateLimitFromHeader(name, headers.get(name), PATTERN_USED_WEIGHT, retryAfter);
                rateLimitMap.put(RateLimitType.REQUEST_WEIGHT, usedWeightRateLimit);
            }
            if (!name.startsWith("x-mbx-order-count-")) continue;
            RateLimit orderCountRateLimit = this.getRateLimitFromHeader(name, headers.get(name), PATTERN_ORDER_COUNT, retryAfter);
            rateLimitMap.put(RateLimitType.ORDERS, orderCountRateLimit);
        }
        return rateLimitMap;
    }

    private RateLimit getRateLimitFromHeader(String headerName, String value, Pattern pattern, Integer retryAfter) {
        RateLimit rateLimit = new RateLimit();
        rateLimit.setRateLimitType(RateLimitType.REQUEST_WEIGHT);
        Matcher usedWeightMatcher = pattern.matcher(headerName);
        if (usedWeightMatcher.find()) {
            String intervalCount = usedWeightMatcher.group(1);
            String intervalType = usedWeightMatcher.group(2);
            rateLimit.setIntervalNum(Integer.valueOf(intervalCount));
            rateLimit.setInterval(RateLimitInterval.fromValue(intervalType.toUpperCase()));
        }
        rateLimit.setRetryAfter(retryAfter);
        rateLimit.setCount(Integer.valueOf(value));
        return rateLimit;
    }
}

