/*
 * Decompiled with CFR 0.152.
 */
package io.github.azmaah.eclipse.transformer;

import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;

public class TransformerExtension {
    private static final String DEFAULT_CLI_VERSION = "0.5.0";
    private final Property<String> version;
    private final DirectoryProperty sourceDir;
    private final DirectoryProperty distDir;
    private final RegularFileProperty selectionRules;
    private final RegularFileProperty renamesRules;
    private final RegularFileProperty versionsRules;
    private final RegularFileProperty bundlesRules;
    private final RegularFileProperty directRules;
    private final RegularFileProperty textMasterRules;

    public TransformerExtension(Project project) {
        ObjectFactory objects = project.getObjects();
        this.version = objects.property(String.class).convention((Object)DEFAULT_CLI_VERSION);
        this.distDir = objects.directoryProperty().convention(project.getLayout().getBuildDirectory().dir("transform-output"));
        this.sourceDir = objects.directoryProperty();
        this.selectionRules = objects.fileProperty();
        this.renamesRules = objects.fileProperty();
        this.versionsRules = objects.fileProperty();
        this.bundlesRules = objects.fileProperty();
        this.directRules = objects.fileProperty();
        this.textMasterRules = objects.fileProperty();
    }

    public Property<String> getVersion() {
        return this.version;
    }

    public DirectoryProperty getSourceDir() {
        return this.sourceDir;
    }

    public DirectoryProperty getDistDir() {
        return this.distDir;
    }

    public RegularFileProperty getSelectionRules() {
        return this.selectionRules;
    }

    public RegularFileProperty getRenamesRules() {
        return this.renamesRules;
    }

    public RegularFileProperty getVersionsRules() {
        return this.versionsRules;
    }

    public RegularFileProperty getBundlesRules() {
        return this.bundlesRules;
    }

    public RegularFileProperty getDirectRules() {
        return this.directRules;
    }

    public RegularFileProperty getTextMasterRules() {
        return this.textMasterRules;
    }
}

