/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.sources;

import io.github.ascopes.protobufmavenplugin.sources.ImmutableSourceListing;
import io.github.ascopes.protobufmavenplugin.sources.SourceGlobFilter;
import io.github.ascopes.protobufmavenplugin.sources.SourceListing;
import io.github.ascopes.protobufmavenplugin.utils.ConcurrentExecutor;
import io.github.ascopes.protobufmavenplugin.utils.Digests;
import io.github.ascopes.protobufmavenplugin.utils.FileUtils;
import io.github.ascopes.protobufmavenplugin.utils.TemporarySpace;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public final class SourcePathResolver {
    private static final Set<String> POM_FILE_EXTENSIONS = Set.of(".pom", ".xml");
    private static final Set<String> ZIP_FILE_EXTENSIONS = Set.of(".jar", ".zip");
    private static final Logger log = LoggerFactory.getLogger(SourcePathResolver.class);
    private final ConcurrentExecutor concurrentExecutor;
    private final TemporarySpace temporarySpace;

    @Inject
    public SourcePathResolver(ConcurrentExecutor concurrentExecutor, TemporarySpace temporarySpace) {
        this.concurrentExecutor = concurrentExecutor;
        this.temporarySpace = temporarySpace;
    }

    public Collection<SourceListing> resolveSources(Collection<Path> rootPaths, SourceGlobFilter filter) {
        return rootPaths.stream().map(FileUtils::normalize).distinct().map(path -> this.concurrentExecutor.submit(() -> this.resolveSources((Path)path, filter))).collect(this.concurrentExecutor.awaiting()).stream().flatMap(Optional::stream).collect(Collectors.toUnmodifiableList());
    }

    private Optional<SourceListing> resolveSources(Path rootPath, SourceGlobFilter filter) throws IOException {
        if (!Files.exists(rootPath, new LinkOption[0])) {
            log.debug("Skipping lookup in path {} as it does not exist", (Object)rootPath);
            return Optional.empty();
        }
        return Files.isRegularFile(rootPath, new LinkOption[0]) ? this.resolveSourcesWithinFile(rootPath, filter) : this.resolveSourcesWithinDirectory(rootPath, filter);
    }

    private Optional<SourceListing> resolveSourcesWithinFile(Path rootPath, SourceGlobFilter filter) throws IOException {
        Optional<String> fileExtension = FileUtils.getFileExtension(rootPath);
        if (fileExtension.filter(ZIP_FILE_EXTENSIONS::contains).isPresent()) {
            return this.resolveSourcesWithinArchive(rootPath, filter);
        }
        if (fileExtension.filter(POM_FILE_EXTENSIONS::contains).isPresent()) {
            log.debug("Ignoring invalid dependency on potential POM at {}", (Object)rootPath);
            return Optional.empty();
        }
        log.warn("Ignoring unknown archive type at {}", (Object)rootPath);
        return Optional.empty();
    }

    private Optional<SourceListing> resolveSourcesWithinArchive(Path rootPath, SourceGlobFilter filter) throws IOException {
        try (FileSystem vfs = FileUtils.openZipAsFileSystem(rootPath);){
            Path vfsRoot = vfs.getRootDirectories().iterator().next();
            Optional<SourceListing> sourceFiles = this.resolveSources(vfsRoot, filter);
            if (sourceFiles.isEmpty()) {
                Optional<SourceListing> optional = Optional.empty();
                return optional;
            }
            Path extractionRoot = this.getArchiveExtractionRoot().resolve(this.generateUniqueName(rootPath));
            List<Path> relocatedSourceFiles = FileUtils.rebaseFileTree(vfsRoot, extractionRoot, sourceFiles.get().getSourceProtoFiles().stream());
            Optional<SourceListing> optional = Optional.of(this.createSourceListing(relocatedSourceFiles, extractionRoot));
            return optional;
        }
    }

    private Optional<SourceListing> resolveSourcesWithinDirectory(Path rootPath, SourceGlobFilter filter) throws IOException {
        try (Stream<Path> stream = Files.walk(rootPath, new FileVisitOption[0]);){
            Optional<SourceListing> optional = stream.filter(filePath -> filter.matches(rootPath, (Path)filePath)).peek(protoFile -> log.trace("Found proto file in root {}: {}", (Object)rootPath.toUri(), protoFile)).collect(Collectors.collectingAndThen(Collectors.toCollection(LinkedHashSet::new), Optional::of)).filter(Predicate.not(Collection::isEmpty)).map(protoFiles -> this.createSourceListing((Collection<Path>)protoFiles, rootPath));
            return optional;
        }
    }

    private SourceListing createSourceListing(Collection<Path> sourceFiles, Path rootPath) {
        return ImmutableSourceListing.builder().addAllSourceProtoFiles(sourceFiles).sourceRoot(rootPath).build();
    }

    private Path getArchiveExtractionRoot() {
        return this.temporarySpace.createTemporarySpace("archives");
    }

    private String generateUniqueName(Path path) {
        String digest = Digests.sha1(FileUtils.normalize(path).toUri().toASCIIString());
        return FileUtils.getFileNameWithoutExtension(path) + "-" + digest;
    }
}

