/*
 * Decompiled with CFR 0.152.
 */
package com.rajat.pdfviewer.util;

import android.app.ActivityManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.pdf.PdfRenderer;
import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Iterator;
import java.util.LinkedList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/rajat/pdfviewer/util/CommonUtils;", "", "()V", "Companion", "pdfViewer_release"})
@StabilityInferred(parameters=1)
public final class CommonUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002\r\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u000f"}, d2={"Lcom/rajat/pdfviewer/util/CommonUtils$Companion;", "", "()V", "calculateDynamicPrefetchCount", "", "context", "Landroid/content/Context;", "pdfRenderer", "Landroid/graphics/pdf/PdfRenderer;", "estimatePdfComplexity", "", "getAvailableMemory", "", "BitmapPool", "BitmapPool1", "pdfViewer_release"})
    public static final class Companion {
        private Companion() {
        }

        public final long getAvailableMemory(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
            Object object = context.getSystemService("activity");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.ActivityManager");
            ActivityManager activityManager = (ActivityManager)object;
            activityManager.getMemoryInfo(memoryInfo);
            return memoryInfo.availMem;
        }

        public final float estimatePdfComplexity(@NotNull PdfRenderer pdfRenderer) {
            Intrinsics.checkNotNullParameter((Object)pdfRenderer, (String)"pdfRenderer");
            return pdfRenderer.getPageCount();
        }

        public final int calculateDynamicPrefetchCount(@NotNull Context context, @NotNull PdfRenderer pdfRenderer) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)pdfRenderer, (String)"pdfRenderer");
            long availableMemory = this.getAvailableMemory(context);
            float pdfComplexity = this.estimatePdfComplexity(pdfRenderer);
            return availableMemory > 0x40000000L && pdfComplexity < 100.0f ? 10 : (availableMemory > 0x20000000L && pdfComplexity < 200.0f ? 5 : 3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u0004H\u0002J \u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tR\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/rajat/pdfviewer/util/CommonUtils$Companion$BitmapPool;", "", "()V", "maxPoolSize", "", "getMaxPoolSize", "()I", "pool", "Ljava/util/LinkedList;", "Landroid/graphics/Bitmap;", "calculateMaxPoolSize", "getBitmap", "width", "height", "config", "Landroid/graphics/Bitmap$Config;", "recycleBitmap", "", "bitmap", "pdfViewer_release"})
        @StabilityInferred(parameters=0)
        public static final class BitmapPool {
            @NotNull
            public static final BitmapPool INSTANCE = new BitmapPool();
            @NotNull
            private static final LinkedList<Bitmap> pool = new LinkedList();
            public static final int $stable = 8;

            private BitmapPool() {
            }

            private final int getMaxPoolSize() {
                return this.calculateMaxPoolSize();
            }

            private final int calculateMaxPoolSize() {
                long maxMemory = Runtime.getRuntime().maxMemory() / (long)1024;
                return (int)(maxMemory / (long)20480);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final Bitmap getBitmap(int width, int height, @NotNull Bitmap.Config config) {
                Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                LinkedList<Bitmap> linkedList = pool;
                synchronized (linkedList) {
                    boolean bl = false;
                    Iterator iterator = pool.iterator();
                    Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                    Iterator iterator2 = iterator;
                    while (iterator2.hasNext()) {
                        Object e = iterator2.next();
                        Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                        Bitmap bitmap = (Bitmap)e;
                        if (bitmap.isRecycled() || bitmap.getWidth() != width || bitmap.getHeight() != height || bitmap.getConfig() != config) continue;
                        iterator2.remove();
                        Bitmap bitmap2 = bitmap;
                        return bitmap2;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
                Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(...)");
                return bitmap;
            }

            public static /* synthetic */ Bitmap getBitmap$default(BitmapPool bitmapPool, int n, int n2, Bitmap.Config config, int n3, Object object) {
                if ((n3 & 4) != 0) {
                    config = Bitmap.Config.ARGB_8888;
                }
                return bitmapPool.getBitmap(n, n2, config);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void recycleBitmap(@NotNull Bitmap bitmap) {
                Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
                if (!bitmap.isRecycled()) {
                    LinkedList<Bitmap> linkedList = pool;
                    synchronized (linkedList) {
                        Object object;
                        boolean bl = false;
                        if (pool.size() < INSTANCE.getMaxPoolSize()) {
                            object = pool.add(bitmap);
                        } else {
                            bitmap.recycle();
                            object = Unit.INSTANCE;
                        }
                        Object object2 = object;
                    }
                }
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/rajat/pdfviewer/util/CommonUtils$Companion$BitmapPool1;", "", "()V", "pool", "Ljava/util/LinkedList;", "Landroid/graphics/Bitmap;", "getBitmap", "width", "", "height", "recycleBitmap", "", "bitmap", "pdfViewer_release"})
        @StabilityInferred(parameters=0)
        public static final class BitmapPool1 {
            @NotNull
            public static final BitmapPool1 INSTANCE = new BitmapPool1();
            @NotNull
            private static final LinkedList<Bitmap> pool = new LinkedList();
            public static final int $stable = 8;

            private BitmapPool1() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final Bitmap getBitmap(int width, int height) {
                LinkedList<Bitmap> linkedList = pool;
                synchronized (linkedList) {
                    boolean bl = false;
                    Iterator iterator = pool.iterator();
                    Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                    Iterator iterator2 = iterator;
                    while (iterator2.hasNext()) {
                        Object e = iterator2.next();
                        Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                        Bitmap bitmap = (Bitmap)e;
                        if (bitmap.isRecycled() || bitmap.getWidth() != width || bitmap.getHeight() != height) continue;
                        iterator2.remove();
                        Bitmap bitmap2 = bitmap;
                        return bitmap2;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(...)");
                return bitmap;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void recycleBitmap(@NotNull Bitmap bitmap) {
                Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
                if (!bitmap.isRecycled()) {
                    LinkedList<Bitmap> linkedList = pool;
                    synchronized (linkedList) {
                        Object object;
                        boolean bl = false;
                        if (pool.size() < 10) {
                            object = pool.add(bitmap);
                        } else {
                            bitmap.recycle();
                            object = Unit.INSTANCE;
                        }
                        Object object2 = object;
                    }
                }
            }
        }
    }
}

