/*
 * Decompiled with CFR 0.152.
 */
package com.rajat.pdfviewer.util;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.Log;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.content.ContextCompat;
import com.rajat.pdfviewer.R;
import com.rajat.pdfviewer.databinding.ActivityPdfViewerBinding;
import com.rajat.pdfviewer.util.ThemeUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0087\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0018"}, d2={"Lcom/rajat/pdfviewer/util/ViewerStyle;", "", "backgroundColor", "", "progressBarDrawableResId", "<init>", "(II)V", "getBackgroundColor", "()I", "getProgressBarDrawableResId", "applyTo", "", "binding", "Lcom/rajat/pdfviewer/databinding/ActivityPdfViewerBinding;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "pdfViewer_release"})
@StabilityInferred(parameters=1)
public final class ViewerStyle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int backgroundColor;
    private final int progressBarDrawableResId;
    public static final int $stable;

    public ViewerStyle(int backgroundColor, int progressBarDrawableResId) {
        this.backgroundColor = backgroundColor;
        this.progressBarDrawableResId = progressBarDrawableResId;
    }

    public final int getBackgroundColor() {
        return this.backgroundColor;
    }

    public final int getProgressBarDrawableResId() {
        return this.progressBarDrawableResId;
    }

    public final void applyTo(@NotNull ActivityPdfViewerBinding binding) {
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        try {
            binding.parentLayout.setBackgroundColor(this.backgroundColor);
            binding.progressBar.setIndeterminateDrawable(ContextCompat.getDrawable((Context)binding.getRoot().getContext(), (int)this.progressBarDrawableResId));
        }
        catch (Exception e) {
            Log.w((String)"ViewerStyle", (String)("Failed to apply style: " + e.getLocalizedMessage()));
        }
    }

    public final int component1() {
        return this.backgroundColor;
    }

    public final int component2() {
        return this.progressBarDrawableResId;
    }

    @NotNull
    public final ViewerStyle copy(int backgroundColor, int progressBarDrawableResId) {
        return new ViewerStyle(backgroundColor, progressBarDrawableResId);
    }

    public static /* synthetic */ ViewerStyle copy$default(ViewerStyle viewerStyle, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = viewerStyle.backgroundColor;
        }
        if ((n3 & 2) != 0) {
            n2 = viewerStyle.progressBarDrawableResId;
        }
        return viewerStyle.copy(n, n2);
    }

    @NotNull
    public String toString() {
        return "ViewerStyle(backgroundColor=" + this.backgroundColor + ", progressBarDrawableResId=" + this.progressBarDrawableResId + ')';
    }

    public int hashCode() {
        int result = Integer.hashCode(this.backgroundColor);
        result = result * 31 + Integer.hashCode(this.progressBarDrawableResId);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ViewerStyle)) {
            return false;
        }
        ViewerStyle viewerStyle = (ViewerStyle)other;
        if (this.backgroundColor != viewerStyle.backgroundColor) {
            return false;
        }
        return this.progressBarDrawableResId == viewerStyle.progressBarDrawableResId;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/rajat/pdfviewer/util/ViewerStyle$Companion;", "", "<init>", "()V", "from", "Lcom/rajat/pdfviewer/util/ViewerStyle;", "context", "Landroid/content/Context;", "pdfViewer_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ViewerStyle from(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            TypedArray typedArray = context.getTheme().obtainStyledAttributes(R.styleable.PdfRendererView);
            Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
            TypedArray typedArray2 = typedArray;
            int backgroundColor = ThemeUtils.INSTANCE.getColorFromTypedArray(typedArray2, R.styleable.PdfRendererView_pdfView_backgroundColor, ContextCompat.getColor((Context)context, (int)R.color.pdf_viewer_surface));
            int progressBarDrawableResId = ThemeUtils.INSTANCE.getResIdFromTypedArray(typedArray2, R.styleable.PdfRendererView_pdfView_progressBar, R.drawable.pdf_viewer_progress_circle);
            typedArray2.recycle();
            return new ViewerStyle(backgroundColor, progressBarDrawableResId);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

