/*
 * Decompiled with CFR 0.152.
 */
package com.rajat.pdfviewer.util;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.MediaStore;
import android.util.Log;
import androidx.compose.runtime.internal.StabilityInferred;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\b\b\u0002\u0010\u0006\u001a\u00020\u0004J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0004J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0004J\u0016\u0010\u0016\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0004J\u000e\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0010J\u0016\u0010\u001d\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u0012J2\u0010\u001f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\b0#\u00a8\u0006$"}, d2={"Lcom/rajat/pdfviewer/util/FileUtils;", "", "()V", "cachedFileNameWithFormat", "", "name", "format", "clearPdfCache", "", "context", "Landroid/content/Context;", "exceptFileName", "copy", "inputStream", "Ljava/io/InputStream;", "output", "Ljava/io/File;", "createPdfDocumentUri", "Landroid/net/Uri;", "contentResolver", "Landroid/content/ContentResolver;", "fileName", "fileFromAsset", "assetName", "getCachedFileName", "url", "isValidPdf", "", "file", "uriToFile", "uri", "writeFile", "totalLength", "", "onProgress", "Lkotlin/Function1;", "pdfViewer_release"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nFileUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileUtils.kt\ncom/rajat/pdfviewer/util/FileUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,102:1\n1#2:103\n13309#3,2:104\n*S KotlinDebug\n*F\n+ 1 FileUtils.kt\ncom/rajat/pdfviewer/util/FileUtils\n*L\n70#1:104,2\n*E\n"})
public final class FileUtils {
    @NotNull
    public static final FileUtils INSTANCE = new FileUtils();
    public static final int $stable;

    private FileUtils() {
    }

    @NotNull
    public final File fileFromAsset(@NotNull Context context, @NotNull String assetName) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)assetName, (String)"assetName");
        File outFile = new File(context.getCacheDir(), String.valueOf(assetName));
        if (StringsKt.contains$default((CharSequence)assetName, (CharSequence)"/", (boolean)false, (int)2, null)) {
            File file = outFile.getParentFile();
            if (file != null) {
                file.mkdirs();
            }
        }
        InputStream inputStream = context.getAssets().open(assetName);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"open(...)");
        this.copy(inputStream, outFile);
        return outFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void copy(@NotNull InputStream inputStream, @Nullable File output) throws IOException {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        FileOutputStream outputStream = new FileOutputStream(output);
        try {
            int read = 0;
            byte[] bytes = new byte[1024];
            while (true) {
                int n;
                int it = n = inputStream.read(bytes);
                boolean bl = false;
                read = it;
                if (n != -1) {
                    outputStream.write(bytes, 0, read);
                    continue;
                }
                break;
            }
        }
        finally {
            try {
                inputStream.close();
            }
            finally {
                outputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final File uriToFile(@NotNull Context context, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        InputStream inputStream = context.getContentResolver().openInputStream(uri);
        File tempFile = File.createTempFile("pdf_temp", ".pdf", context.getCacheDir());
        Intrinsics.checkNotNull((Object)tempFile);
        Closeable closeable = new FileOutputStream(tempFile);
        Throwable throwable = null;
        try {
            FileOutputStream fileOut = (FileOutputStream)closeable;
            boolean bl = false;
            InputStream inputStream2 = inputStream;
            Long l = inputStream2 != null ? Long.valueOf(ByteStreamsKt.copyTo$default((InputStream)inputStream2, (OutputStream)fileOut, (int)0, (int)2, null)) : null;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return tempFile;
    }

    @NotNull
    public final Uri createPdfDocumentUri(@NotNull ContentResolver contentResolver, @NotNull String fileName) {
        ContentValues contentValues;
        Intrinsics.checkNotNullParameter((Object)contentResolver, (String)"contentResolver");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        ContentValues $this$createPdfDocumentUri_u24lambda_u242 = contentValues = new ContentValues();
        boolean bl = false;
        $this$createPdfDocumentUri_u24lambda_u242.put("_display_name", fileName);
        $this$createPdfDocumentUri_u24lambda_u242.put("mime_type", "application/pdf");
        if (Build.VERSION.SDK_INT >= 29) {
            $this$createPdfDocumentUri_u24lambda_u242.put("relative_path", Environment.DIRECTORY_DOCUMENTS);
        }
        ContentValues contentValues2 = contentValues;
        contentValues = contentResolver.insert(MediaStore.Files.getContentUri((String)"external"), contentValues2);
        if (contentValues == null) {
            throw new IOException("Failed to create new MediaStore record.");
        }
        return contentValues;
    }

    @NotNull
    public final String getCachedFileName(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return url.hashCode() + ".pdf";
    }

    /*
     * WARNING - void declaration
     */
    public final void clearPdfCache(@NotNull Context context, @Nullable String exceptFileName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        File cacheDir = context.getCacheDir();
        File[] fileArray = cacheDir.listFiles((arg_0, arg_1) -> FileUtils.clearPdfCache$lambda$3(exceptFileName, arg_0, arg_1));
        if (fileArray != null) {
            void $this$forEach$iv;
            File[] fileArray2 = fileArray;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv;
                void it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                it.delete();
            }
        }
    }

    public static /* synthetic */ void clearPdfCache$default(FileUtils fileUtils, Context context, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        fileUtils.clearPdfCache(context, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeFile(@NotNull InputStream inputStream, @NotNull File file, long totalLength, @NotNull Function1<? super Long, Unit> onProgress) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(onProgress, (String)"onProgress");
        Closeable closeable = new FileOutputStream(file);
        Throwable throwable = null;
        try {
            FileOutputStream outputStream = (FileOutputStream)closeable;
            boolean bl = false;
            byte[] data = new byte[8192];
            long totalBytesRead = 0L;
            int bytesRead = 0;
            while (true) {
                int n;
                int it = n = inputStream.read(data);
                boolean bl2 = false;
                bytesRead = it;
                if (n == -1) break;
                outputStream.write(data, 0, bytesRead);
                onProgress.invoke((Object)(totalBytesRead += (long)bytesRead));
            }
            outputStream.flush();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isValidPdf(@NotNull File file) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            boolean bl2;
            Closeable closeable = new FileInputStream(file);
            Throwable throwable = null;
            try {
                FileInputStream inputStream = (FileInputStream)closeable;
                boolean bl3 = false;
                byte[] signature = new byte[4];
                if (inputStream.read(signature) != 4) {
                    boolean bl4 = false;
                    return bl4;
                }
                String pdfHeader = new String(signature, Charsets.US_ASCII);
                bl2 = StringsKt.startsWith$default((String)pdfHeader, (String)"%PDF", (boolean)false, (int)2, null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            bl = bl2;
        }
        catch (Exception e) {
            Log.e((String)"FileUtils", (String)("Error checking PDF validity: " + e.getMessage()));
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final String cachedFileNameWithFormat(@NotNull Object name, @NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        return name + format;
    }

    public static /* synthetic */ String cachedFileNameWithFormat$default(FileUtils fileUtils, Object object, String string2, int n, Object object2) {
        if ((n & 2) != 0) {
            string2 = ".jpg";
        }
        return fileUtils.cachedFileNameWithFormat(object, string2);
    }

    private static final boolean clearPdfCache$lambda$3(String $exceptFileName, File file, String name) {
        Intrinsics.checkNotNull((Object)name);
        return StringsKt.endsWith$default((String)name, (String)".pdf", (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)name, (Object)$exceptFileName);
    }
}

