/*
 * Decompiled with CFR 0.152.
 */
package com.rajat.pdfviewer;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import androidx.recyclerview.widget.RecyclerView;
import com.rajat.pdfviewer.PdfRendererCore;
import com.rajat.pdfviewer.R;
import com.rajat.pdfviewer.databinding.ListItemPdfPageBinding;
import com.rajat.pdfviewer.util.ViewExtKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\f\u0012\b\u0012\u00060\u0002R\u00020\u00000\u0001:\u0001\u0014B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u001c\u0010\u0010\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/rajat/pdfviewer/PdfViewAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/rajat/pdfviewer/PdfViewAdapter$PdfPageViewHolder;", "renderer", "Lcom/rajat/pdfviewer/PdfRendererCore;", "pageSpacing", "Landroid/graphics/Rect;", "enableLoadingForPages", "", "(Lcom/rajat/pdfviewer/PdfRendererCore;Landroid/graphics/Rect;Z)V", "getItemCount", "", "onBindViewHolder", "", "holder", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "PdfPageViewHolder", "pdfViewer_release"})
public final class PdfViewAdapter
extends RecyclerView.Adapter<PdfPageViewHolder> {
    @NotNull
    private final PdfRendererCore renderer;
    @NotNull
    private final Rect pageSpacing;
    private final boolean enableLoadingForPages;

    public PdfViewAdapter(@NotNull PdfRendererCore renderer, @NotNull Rect pageSpacing, boolean enableLoadingForPages) {
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)pageSpacing, (String)"pageSpacing");
        this.renderer = renderer;
        this.pageSpacing = pageSpacing;
        this.enableLoadingForPages = enableLoadingForPages;
    }

    @NotNull
    public PdfPageViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        ListItemPdfPageBinding listItemPdfPageBinding = ListItemPdfPageBinding.inflate(LayoutInflater.from((Context)parent.getContext()), parent, false);
        Intrinsics.checkNotNullExpressionValue((Object)listItemPdfPageBinding, (String)"inflate(\n               \u2026      false\n            )");
        return new PdfPageViewHolder(listItemPdfPageBinding);
    }

    public int getItemCount() {
        return this.renderer.getPageCount();
    }

    public void onBindViewHolder(@NotNull PdfPageViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        holder.bind(position);
    }

    public static final /* synthetic */ Rect access$getPageSpacing$p(PdfViewAdapter $this) {
        return $this.pageSpacing;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\n"}, d2={"Lcom/rajat/pdfviewer/PdfViewAdapter$PdfPageViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Lcom/rajat/pdfviewer/databinding/ListItemPdfPageBinding;", "(Lcom/rajat/pdfviewer/PdfViewAdapter;Lcom/rajat/pdfviewer/databinding/ListItemPdfPageBinding;)V", "bind", "", "position", "", "handleLoadingForPage", "pdfViewer_release"})
    public final class PdfPageViewHolder
    extends RecyclerView.ViewHolder {
        public PdfPageViewHolder(ListItemPdfPageBinding itemView) {
            Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
            super((View)itemView.getRoot());
        }

        public final void bind(int position) {
            View view = this.itemView;
            PdfViewAdapter pdfViewAdapter = PdfViewAdapter.this;
            View $this$bind_u24lambda_u2d0 = view;
            boolean bl = false;
            this.handleLoadingForPage(position);
            ((ImageView)this.itemView.findViewById(R.id.pageView)).setImageBitmap(null);
            pdfViewAdapter.renderer.renderPage(position, (Function2<? super Bitmap, ? super Integer, Unit>)((Function2)new Function2<Bitmap, Integer, Unit>(position, $this$bind_u24lambda_u2d0, this, pdfViewAdapter){
                final /* synthetic */ int $position;
                final /* synthetic */ View $this_with;
                final /* synthetic */ PdfPageViewHolder this$0;
                final /* synthetic */ PdfViewAdapter this$1;
                {
                    this.$position = $position;
                    this.$this_with = $receiver;
                    this.this$0 = $receiver2;
                    this.this$1 = $receiver3;
                    super(2);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@Nullable Bitmap bitmap, int pageNo) {
                    block2: {
                        void $this$invoke_u24lambda_u2d2_u24lambda_u2d1;
                        AlphaAnimation alphaAnimation;
                        if (pageNo != this.$position) {
                            return;
                        }
                        Bitmap bitmap2 = bitmap;
                        if (bitmap2 == null) break block2;
                        Bitmap bitmap3 = bitmap2;
                        View view = this.$this_with;
                        PdfPageViewHolder pdfPageViewHolder = this.this$0;
                        PdfViewAdapter pdfViewAdapter = this.this$1;
                        Bitmap it = bitmap3;
                        boolean bl = false;
                        FrameLayout frameLayout = (FrameLayout)view.findViewById(R.id.container_view);
                        Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"container_view");
                        View $this$updateLayoutParams$iv = (View)frameLayout;
                        boolean $i$f$updateLayoutParamsTyped22 = false;
                        ViewGroup.LayoutParams layoutParams = $this$updateLayoutParams$iv.getLayoutParams();
                        if (layoutParams == null) {
                            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
                        }
                        ViewGroup.LayoutParams params$iv = (ViewGroup.LayoutParams)((ViewGroup.MarginLayoutParams)layoutParams);
                        ViewGroup.MarginLayoutParams $this$invoke_u24lambda_u2d2_u24lambda_u2d0 = (ViewGroup.MarginLayoutParams)params$iv;
                        boolean bl2 = false;
                        $this$invoke_u24lambda_u2d2_u24lambda_u2d0.height = (int)((float)((FrameLayout)view.findViewById(R.id.container_view)).getWidth() / ((float)bitmap.getWidth() / (float)bitmap.getHeight()));
                        $this$invoke_u24lambda_u2d2_u24lambda_u2d0.topMargin = PdfViewAdapter.access$getPageSpacing$p((PdfViewAdapter)pdfViewAdapter).top;
                        $this$invoke_u24lambda_u2d2_u24lambda_u2d0.leftMargin = PdfViewAdapter.access$getPageSpacing$p((PdfViewAdapter)pdfViewAdapter).left;
                        $this$invoke_u24lambda_u2d2_u24lambda_u2d0.rightMargin = PdfViewAdapter.access$getPageSpacing$p((PdfViewAdapter)pdfViewAdapter).right;
                        $this$invoke_u24lambda_u2d2_u24lambda_u2d0.bottomMargin = PdfViewAdapter.access$getPageSpacing$p((PdfViewAdapter)pdfViewAdapter).bottom;
                        $this$updateLayoutParams$iv.setLayoutParams(params$iv);
                        ((ImageView)pdfPageViewHolder.itemView.findViewById(R.id.pageView)).setImageBitmap(bitmap);
                        AlphaAnimation $i$f$updateLayoutParamsTyped22 = alphaAnimation = new AlphaAnimation(0.0f, 1.0f);
                        ImageView imageView = (ImageView)pdfPageViewHolder.itemView.findViewById(R.id.pageView);
                        boolean bl3 = false;
                        $this$invoke_u24lambda_u2d2_u24lambda_u2d1.setInterpolator((Interpolator)new LinearInterpolator());
                        $this$invoke_u24lambda_u2d2_u24lambda_u2d1.setDuration(300L);
                        imageView.setAnimation((Animation)alphaAnimation);
                        ProgressBar progressBar = (ProgressBar)view.findViewById(R.id.pdf_view_page_loading_progress);
                        Intrinsics.checkNotNullExpressionValue((Object)progressBar, (String)"pdf_view_page_loading_progress");
                        ViewExtKt.hide((View)progressBar);
                    }
                }
            }));
        }

        private final void handleLoadingForPage(int position) {
            if (!PdfViewAdapter.this.enableLoadingForPages) {
                ProgressBar progressBar = (ProgressBar)this.itemView.findViewById(R.id.pdf_view_page_loading_progress);
                Intrinsics.checkNotNullExpressionValue((Object)progressBar, (String)"itemView.pdf_view_page_loading_progress");
                ViewExtKt.hide((View)progressBar);
                return;
            }
            if (PdfViewAdapter.this.renderer.pageExistInCache(position)) {
                ProgressBar progressBar = (ProgressBar)this.itemView.findViewById(R.id.pdf_view_page_loading_progress);
                Intrinsics.checkNotNullExpressionValue((Object)progressBar, (String)"itemView.pdf_view_page_loading_progress");
                ViewExtKt.hide((View)progressBar);
            } else {
                ProgressBar progressBar = (ProgressBar)this.itemView.findViewById(R.id.pdf_view_page_loading_progress);
                Intrinsics.checkNotNullExpressionValue((Object)progressBar, (String)"itemView.pdf_view_page_loading_progress");
                ViewExtKt.show((View)progressBar);
            }
        }
    }
}

