/*
 * Decompiled with CFR 0.152.
 */
package io.github.adraffy.ens;

import io.github.adraffy.ens.IntList;
import java.util.ArrayList;
import java.util.List;

public class StringUtils {
    static final int UTF16_BMP = 65536;
    static final int UTF16_BITS = 10;
    static final int UTF16_HEAD = -1024;
    static final int UTF16_DATA = 1023;
    static final int UTF16_HI = 55296;
    static final int UTF16_LO = 56320;

    public static int UTF16Width(int cp) {
        return cp < 65536 ? 1 : 2;
    }

    public static int UTF16Length(int[] cps) {
        int n = 0;
        for (int cp : cps) {
            n += StringUtils.UTF16Width(cp);
        }
        return n;
    }

    public static void appendCodepoint(StringBuilder sb, int cp) {
        if (cp < 65536) {
            sb.append((char)cp);
        } else {
            sb.append((char)(0xD800 | (cp -= 65536) >> 10 & 0x3FF));
            sb.append((char)(0xDC00 | cp & 0x3FF));
        }
    }

    public static void appendHex(StringBuilder sb, int cp) {
        if (cp < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(cp).toUpperCase());
    }

    public static String toHex(int cp) {
        String temp = Integer.toHexString(cp);
        return temp.length() == 1 ? '0' + temp : temp;
    }

    public static String toHexSequence(int[] cps) {
        int n = cps.length;
        if (n == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(n * 5);
        StringUtils.appendHex(sb, cps[0]);
        for (int i = 1; i < n; ++i) {
            sb.append(' ');
            StringUtils.appendHex(sb, cps[i]);
        }
        return sb.toString();
    }

    public static String toHexSequence(String s) {
        return StringUtils.toHexSequence(StringUtils.explode(s));
    }

    public static String implode(int[] cps) {
        StringBuilder sb = new StringBuilder(StringUtils.UTF16Length(cps));
        for (int cp : cps) {
            StringUtils.appendCodepoint(sb, cp);
        }
        return sb.toString();
    }

    public static int[] explode(String s) {
        return StringUtils.explode(s, 0, s.length());
    }

    public static int[] explode(String s, int a, int b) {
        IntList buf = new IntList(b - a);
        while (a < b) {
            char ch1;
            char ch0;
            int head;
            if ((head = (ch0 = s.charAt(a++)) & 0xFFFFFC00) == 55296 && a < b && ((ch1 = s.charAt(a)) & 0xFFFFFC00) == 56320) {
                buf.add(65536 + ((ch0 & 0x3FF) << 10 | ch1 & 0x3FF));
                ++a;
                continue;
            }
            buf.add(ch0);
        }
        return buf.consume();
    }

    public static List<String> split(String s, char c) {
        ArrayList<String> ret = new ArrayList<String>();
        int prev = 0;
        while (true) {
            int next;
            if ((next = s.indexOf(c, prev)) < 0) {
                ret.add(s.substring(prev));
                return ret;
            }
            ret.add(s.substring(prev, next));
            prev = next + 1;
        }
    }
}

