/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.spec;

import io.a2a.spec.Message;
import io.a2a.spec.MessageSendConfiguration;
import io.a2a.util.Assert;
import java.util.Map;

public record MessageSendParams(Message message, MessageSendConfiguration configuration, Map<String, Object> metadata, String tenant) {
    public MessageSendParams {
        Assert.checkNotNullParam((String)"message", (Object)message);
        Assert.checkNotNullParam((String)"tenant", (Object)tenant);
    }

    public MessageSendParams(Message message, MessageSendConfiguration configuration, Map<String, Object> metadata) {
        this(message, configuration, metadata, "");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        Message message;
        MessageSendConfiguration configuration;
        Map<String, Object> metadata;
        String tenant;

        private Builder() {
        }

        public Builder message(Message message) {
            this.message = message;
            return this;
        }

        public Builder configuration(MessageSendConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder tenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        public MessageSendParams build() {
            return new MessageSendParams(this.message, this.configuration, this.metadata, this.tenant == null ? "" : this.tenant);
        }
    }
}

