/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.spec;

import io.a2a.spec.InvalidParamsError;
import io.a2a.spec.TaskState;
import java.time.Instant;
import org.jspecify.annotations.Nullable;

public record ListTasksParams(@Nullable String contextId, @Nullable TaskState status, @Nullable Integer pageSize, @Nullable String pageToken, @Nullable Integer historyLength, @Nullable Instant lastUpdatedAfter, @Nullable Boolean includeArtifacts, String tenant) {
    private static final int MIN_PAGE_SIZE = 1;
    private static final int MAX_PAGE_SIZE = 100;
    private static final int DEFAULT_PAGE_SIZE = 50;

    public ListTasksParams(@Nullable String contextId, @Nullable TaskState status, @Nullable Integer pageSize, @Nullable String pageToken, @Nullable Integer historyLength, @Nullable Instant lastUpdatedAfter, @Nullable Boolean includeArtifacts, String tenant) {
        if (tenant == null) {
            throw new InvalidParamsError(null, "Parameter 'tenant' may not be null", null);
        }
        if (pageSize != null && (pageSize < 1 || pageSize > 100)) {
            throw new InvalidParamsError(null, "pageSize must be between 1 and 100, got: " + pageSize, null);
        }
        if (historyLength != null && historyLength < 0) {
            throw new InvalidParamsError(null, "historyLength must be non-negative, got: " + historyLength, null);
        }
    }

    public ListTasksParams() {
        this(null, null, null, null, null, null, null, "");
    }

    public ListTasksParams(Integer pageSize, String pageToken) {
        this(null, null, pageSize, pageToken, null, null, null, "");
    }

    public int getEffectivePageSize() {
        return this.pageSize != null ? this.pageSize : 50;
    }

    public int getEffectiveHistoryLength() {
        return this.historyLength != null ? this.historyLength : 0;
    }

    public boolean shouldIncludeArtifacts() {
        return this.includeArtifacts != null && this.includeArtifacts != false;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String contextId;
        private TaskState status;
        private Integer pageSize;
        private String pageToken;
        private Integer historyLength;
        private Instant lastUpdatedAfter;
        private Boolean includeArtifacts;
        private String tenant;

        private Builder() {
        }

        public Builder contextId(String contextId) {
            this.contextId = contextId;
            return this;
        }

        public Builder status(TaskState status) {
            this.status = status;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public Builder historyLength(Integer historyLength) {
            this.historyLength = historyLength;
            return this;
        }

        public Builder lastUpdatedAfter(Instant lastUpdatedAfter) {
            this.lastUpdatedAfter = lastUpdatedAfter;
            return this;
        }

        public Builder includeArtifacts(Boolean includeArtifacts) {
            this.includeArtifacts = includeArtifacts;
            return this;
        }

        public Builder tenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        public ListTasksParams build() {
            return new ListTasksParams(this.contextId, this.status, this.pageSize, this.pageToken, this.historyLength, this.lastUpdatedAfter, this.includeArtifacts, this.tenant);
        }
    }
}

