/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.spec;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.a2a.spec.IdJsonMappingException;
import io.a2a.spec.InvalidParamsJsonMappingException;
import io.a2a.spec.JSONRPCRequest;
import io.a2a.spec.MethodNotFoundJsonMappingException;
import io.a2a.util.Utils;
import java.io.Closeable;

public abstract class JSONRPCRequestDeserializerBase<T>
extends StdDeserializer<JSONRPCRequest<?>> {
    public JSONRPCRequestDeserializerBase() {
        this(null);
    }

    public JSONRPCRequestDeserializerBase(Class<?> vc) {
        super(vc);
    }

    protected <T> T getAndValidateParams(JsonNode paramsNode, JsonParser jsonParser, JsonNode node, Class<T> paramsType) throws JsonMappingException {
        if (paramsNode == null) {
            return null;
        }
        try {
            return (T)Utils.OBJECT_MAPPER.treeToValue((TreeNode)paramsNode, paramsType);
        }
        catch (JsonProcessingException e) {
            throw new InvalidParamsJsonMappingException("Invalid params", e, this.getIdIfPossible(node, jsonParser));
        }
    }

    protected String getAndValidateJsonrpc(JsonNode treeNode, JsonParser jsonParser) throws JsonMappingException {
        JsonNode jsonrpcNode = treeNode.get("jsonrpc");
        if (jsonrpcNode == null || !jsonrpcNode.asText().equals("2.0")) {
            throw new IdJsonMappingException("Invalid JSON-RPC protocol version", this.getIdIfPossible(treeNode, jsonParser));
        }
        return jsonrpcNode.asText();
    }

    protected String getAndValidateMethod(JsonNode treeNode, JsonParser jsonParser) throws JsonMappingException {
        JsonNode methodNode = treeNode.get("method");
        if (methodNode == null) {
            throw new IdJsonMappingException("Missing method", this.getIdIfPossible(treeNode, jsonParser));
        }
        String method = methodNode.asText();
        if (!JSONRPCRequestDeserializerBase.isValidMethodName(method)) {
            throw new MethodNotFoundJsonMappingException("Invalid method", this.getIdIfPossible(treeNode, jsonParser));
        }
        return method;
    }

    protected Object getAndValidateId(JsonNode treeNode, JsonParser jsonParser) throws JsonProcessingException {
        JsonNode idNode = treeNode.get("id");
        Object id = null;
        if (idNode != null) {
            if (idNode.isTextual()) {
                id = Utils.OBJECT_MAPPER.treeToValue((TreeNode)idNode, String.class);
            } else if (idNode.isNumber()) {
                id = Utils.OBJECT_MAPPER.treeToValue((TreeNode)idNode, Integer.class);
            } else {
                throw new JsonMappingException((Closeable)jsonParser, "Invalid id");
            }
        }
        return id;
    }

    protected Object getIdIfPossible(JsonNode treeNode, JsonParser jsonParser) {
        try {
            return this.getAndValidateId(treeNode, jsonParser);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    protected static boolean isValidMethodName(String methodName) {
        return methodName != null && (methodName.equals("tasks/cancel") || methodName.equals("tasks/get") || methodName.equals("tasks/pushNotificationConfig/get") || methodName.equals("tasks/pushNotificationConfig/set") || methodName.equals("tasks/resubscribe") || methodName.equals("message/send") || methodName.equals("message/stream") || methodName.equals("tasks/pushNotificationConfig/list") || methodName.equals("tasks/pushNotificationConfig/delete") || methodName.equals("agent/getAuthenticatedExtendedCard"));
    }
}

