/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.grpc.mapper;

import com.google.protobuf.ProtocolStringList;
import io.a2a.grpc.SecurityRequirement;
import io.a2a.grpc.StringList;
import io.a2a.grpc.mapper.A2AMappers;
import io.a2a.grpc.mapper.A2AProtoMapperConfig;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mapstruct.Mapper;

@Mapper(config=A2AProtoMapperConfig.class)
public interface SecurityRequirementMapper {
    public static final SecurityRequirementMapper INSTANCE = A2AMappers.getMapper(SecurityRequirementMapper.class);

    default public SecurityRequirement mapSecurityRequirement(io.a2a.spec.SecurityRequirement domainRequirement) {
        if (domainRequirement == null) {
            return null;
        }
        SecurityRequirement.Builder securityBuilder = SecurityRequirement.newBuilder();
        Map schemes = domainRequirement.schemes();
        if (schemes != null) {
            for (Map.Entry entry : schemes.entrySet()) {
                StringList.Builder stringListBuilder = StringList.newBuilder();
                if (entry.getValue() != null) {
                    stringListBuilder.addAllList((Iterable)entry.getValue());
                }
                securityBuilder.putSchemes((String)entry.getKey(), stringListBuilder.build());
            }
        }
        return securityBuilder.build();
    }

    default public List<SecurityRequirement> toProto(List<io.a2a.spec.SecurityRequirement> domainSecurity) {
        if (domainSecurity == null) {
            return null;
        }
        ArrayList<SecurityRequirement> protoList = new ArrayList<SecurityRequirement>(domainSecurity.size());
        for (io.a2a.spec.SecurityRequirement requirement : domainSecurity) {
            protoList.add(this.mapSecurityRequirement(requirement));
        }
        return protoList;
    }

    default public List<io.a2a.spec.SecurityRequirement> fromProto(List<SecurityRequirement> protoSecurity) {
        if (protoSecurity == null) {
            return null;
        }
        ArrayList<io.a2a.spec.SecurityRequirement> domainList = new ArrayList<io.a2a.spec.SecurityRequirement>(protoSecurity.size());
        for (SecurityRequirement security : protoSecurity) {
            LinkedHashMap schemeMap = new LinkedHashMap();
            for (Map.Entry<String, StringList> entry : security.getSchemesMap().entrySet()) {
                ProtocolStringList listList = entry.getValue().getListList();
                ArrayList values = new ArrayList(listList);
                schemeMap.put(entry.getKey(), values);
            }
            domainList.add(new io.a2a.spec.SecurityRequirement(schemeMap));
        }
        return domainList;
    }
}

