/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.grpc.mapper;

import io.a2a.grpc.SendMessageRequest;
import io.a2a.grpc.mapper.A2ACommonFieldMapper;
import io.a2a.grpc.mapper.MessageMapper;
import io.a2a.grpc.mapper.MessageSendConfigurationMapper;
import io.a2a.grpc.mapper.MessageSendParamsMapper;
import io.a2a.spec.MessageSendParams;

public class MessageSendParamsMapperImpl
implements MessageSendParamsMapper {
    private final MessageMapper messageMapper = MessageMapper.INSTANCE;
    private final MessageSendConfigurationMapper messageSendConfigurationMapper = MessageSendConfigurationMapper.INSTANCE;
    private final A2ACommonFieldMapper a2ACommonFieldMapper = A2ACommonFieldMapper.INSTANCE;

    @Override
    public SendMessageRequest toProto(MessageSendParams domain) {
        if (domain == null) {
            return null;
        }
        SendMessageRequest.Builder sendMessageRequest = SendMessageRequest.newBuilder();
        if (domain.configuration() != null) {
            sendMessageRequest.setConfiguration(this.messageSendConfigurationMapper.toProto(domain.configuration()));
        }
        sendMessageRequest.setMetadata(this.a2ACommonFieldMapper.metadataToProto(domain.metadata()));
        sendMessageRequest.setTenant(domain.tenant());
        sendMessageRequest.setMessage(this.messageMapper.toProto(domain.message()));
        return sendMessageRequest.build();
    }

    @Override
    public MessageSendParams fromProto(SendMessageRequest proto) {
        if (proto == null) {
            return null;
        }
        MessageSendParams.Builder messageSendParams = MessageSendParams.builder();
        if (proto.hasMetadata()) {
            messageSendParams.metadata(this.a2ACommonFieldMapper.metadataFromProto(proto.getMetadata()));
        }
        if (proto.hasMessage()) {
            messageSendParams.message(this.messageMapper.fromProto(proto.getMessage()));
        }
        if (proto.hasConfiguration()) {
            messageSendParams.configuration(this.messageSendConfigurationMapper.fromProto(proto.getConfiguration()));
        }
        messageSendParams.tenant(proto.getTenant());
        return messageSendParams.build();
    }
}

