/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.grpc.mapper;

import io.a2a.grpc.Artifact;
import io.a2a.grpc.Part;
import io.a2a.grpc.mapper.A2ACommonFieldMapper;
import io.a2a.grpc.mapper.ArtifactMapper;
import io.a2a.grpc.mapper.PartMapper;
import io.a2a.spec.Artifact;
import java.util.List;

public class ArtifactMapperImpl
implements ArtifactMapper {
    private final PartMapper partMapper = PartMapper.INSTANCE;
    private final A2ACommonFieldMapper a2ACommonFieldMapper = A2ACommonFieldMapper.INSTANCE;

    @Override
    public Artifact toProto(io.a2a.spec.Artifact domain) {
        if (domain == null) {
            return null;
        }
        Artifact.Builder artifact = Artifact.newBuilder();
        if (domain.artifactId() != null) {
            artifact.setArtifactId(domain.artifactId());
        }
        if (domain.name() != null) {
            artifact.setName(domain.name());
        }
        if (domain.description() != null) {
            artifact.setDescription(domain.description());
        }
        artifact.setMetadata(this.a2ACommonFieldMapper.metadataToProto(domain.metadata()));
        if (domain.parts() != null) {
            for (io.a2a.spec.Part part : domain.parts()) {
                artifact.addParts(this.partMapper.toProto(part));
            }
        }
        if (domain.extensions() != null) {
            for (String extension : domain.extensions()) {
                artifact.addExtensions(extension);
            }
        }
        return artifact.build();
    }

    @Override
    public io.a2a.spec.Artifact fromProto(Artifact proto) {
        if (proto == null) {
            return null;
        }
        Artifact.Builder artifact = io.a2a.spec.Artifact.builder();
        artifact.artifactId(this.a2ACommonFieldMapper.emptyToNull(proto.getArtifactId()));
        artifact.name(this.a2ACommonFieldMapper.emptyToNull(proto.getName()));
        artifact.description(this.a2ACommonFieldMapper.emptyToNull(proto.getDescription()));
        if (proto.hasMetadata()) {
            artifact.metadata(this.a2ACommonFieldMapper.metadataFromProto(proto.getMetadata()));
        }
        artifact.extensions(this.a2ACommonFieldMapper.emptyListToNull(proto.getExtensionsList()));
        artifact.parts(this.partListToPartArray(proto.getPartsList()));
        return artifact.build();
    }

    protected io.a2a.spec.Part[] partListToPartArray(List<Part> list) {
        if (list == null) {
            return null;
        }
        io.a2a.spec.Part[] partTmp = new io.a2a.spec.Part[list.size()];
        int i = 0;
        for (Part part : list) {
            partTmp[i] = this.partMapper.fromProto(part);
            ++i;
        }
        return partTmp;
    }
}

