/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.grpc.mapper;

import com.google.protobuf.ProtocolStringList;
import io.a2a.grpc.AgentSkill;
import io.a2a.grpc.mapper.AgentSkillMapper;
import io.a2a.grpc.mapper.SecurityRequirementMapper;
import io.a2a.spec.AgentSkill;
import io.a2a.spec.SecurityRequirement;
import java.util.ArrayList;

public class AgentSkillMapperImpl
implements AgentSkillMapper {
    private final SecurityRequirementMapper securityRequirementMapper = SecurityRequirementMapper.INSTANCE;

    @Override
    public AgentSkill toProto(io.a2a.spec.AgentSkill domain) {
        if (domain == null) {
            return null;
        }
        AgentSkill.Builder agentSkill = AgentSkill.newBuilder();
        agentSkill.setId(domain.id());
        agentSkill.setName(domain.name());
        agentSkill.setDescription(domain.description());
        if (domain.tags() != null) {
            for (String tag : domain.tags()) {
                agentSkill.addTags(tag);
            }
        }
        if (domain.examples() != null) {
            for (String example : domain.examples()) {
                agentSkill.addExamples(example);
            }
        }
        if (domain.inputModes() != null) {
            for (String inputMode : domain.inputModes()) {
                agentSkill.addInputModes(inputMode);
            }
        }
        if (domain.outputModes() != null) {
            for (String outputMode : domain.outputModes()) {
                agentSkill.addOutputModes(outputMode);
            }
        }
        if (domain.securityRequirements() != null) {
            for (SecurityRequirement securityRequirement : domain.securityRequirements()) {
                agentSkill.addSecurityRequirements(this.securityRequirementMapper.mapSecurityRequirement(securityRequirement));
            }
        }
        return agentSkill.build();
    }

    @Override
    public io.a2a.spec.AgentSkill fromProto(AgentSkill proto) {
        ProtocolStringList protocolStringList3;
        ProtocolStringList protocolStringList2;
        ProtocolStringList protocolStringList1;
        if (proto == null) {
            return null;
        }
        AgentSkill.Builder agentSkill = io.a2a.spec.AgentSkill.builder();
        agentSkill.id(proto.getId());
        agentSkill.name(proto.getName());
        agentSkill.description(proto.getDescription());
        ProtocolStringList protocolStringList = proto.getTagsList();
        if (protocolStringList != null) {
            agentSkill.tags(new ArrayList(protocolStringList));
        }
        if ((protocolStringList1 = proto.getExamplesList()) != null) {
            agentSkill.examples(new ArrayList(protocolStringList1));
        }
        if ((protocolStringList2 = proto.getInputModesList()) != null) {
            agentSkill.inputModes(new ArrayList(protocolStringList2));
        }
        if ((protocolStringList3 = proto.getOutputModesList()) != null) {
            agentSkill.outputModes(new ArrayList(protocolStringList3));
        }
        agentSkill.securityRequirements(this.securityRequirementMapper.fromProto(proto.getSecurityRequirementsList()));
        return agentSkill.build();
    }
}

