/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.grpc.mapper;

import io.a2a.grpc.SendMessageConfiguration;
import io.a2a.grpc.mapper.A2ACommonFieldMapper;
import io.a2a.grpc.mapper.MessageSendConfigurationMapper;
import io.a2a.grpc.mapper.PushNotificationConfigMapper;
import io.a2a.spec.MessageSendConfiguration;

public class MessageSendConfigurationMapperImpl
implements MessageSendConfigurationMapper {
    private final PushNotificationConfigMapper pushNotificationConfigMapper = PushNotificationConfigMapper.INSTANCE;

    @Override
    public SendMessageConfiguration toProto(MessageSendConfiguration domain) {
        if (domain == null) {
            return null;
        }
        SendMessageConfiguration.Builder sendMessageConfiguration = SendMessageConfiguration.newBuilder();
        if (domain.pushNotificationConfig() != null) {
            sendMessageConfiguration.setPushNotificationConfig(this.pushNotificationConfigMapper.toProto(domain.pushNotificationConfig()));
        }
        if (domain.historyLength() != null) {
            sendMessageConfiguration.setHistoryLength(domain.historyLength());
        }
        if (domain.blocking() != null) {
            sendMessageConfiguration.setBlocking(domain.blocking());
        }
        if (domain.acceptedOutputModes() != null) {
            for (String acceptedOutputMode : domain.acceptedOutputModes()) {
                sendMessageConfiguration.addAcceptedOutputModes(acceptedOutputMode);
            }
        }
        return sendMessageConfiguration.build();
    }

    @Override
    public MessageSendConfiguration fromProto(SendMessageConfiguration proto) {
        if (proto == null) {
            return null;
        }
        MessageSendConfiguration.Builder messageSendConfiguration = MessageSendConfiguration.builder();
        if (proto.hasPushNotificationConfig()) {
            messageSendConfiguration.pushNotificationConfig(this.pushNotificationConfigMapper.fromProto(proto.getPushNotificationConfig()));
        }
        if (proto.hasHistoryLength()) {
            messageSendConfiguration.historyLength(Integer.valueOf(proto.getHistoryLength()));
        }
        messageSendConfiguration.blocking(Boolean.valueOf(proto.getBlocking()));
        messageSendConfiguration.acceptedOutputModes(A2ACommonFieldMapper.INSTANCE.emptyListToNull(proto.getAcceptedOutputModesList()));
        return messageSendConfiguration.build();
    }
}

