/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.grpc.mapper;

import io.a2a.grpc.ListTasksResponse;
import io.a2a.grpc.Task;
import io.a2a.grpc.mapper.ListTasksResultMapper;
import io.a2a.grpc.mapper.TaskMapper;
import io.a2a.jsonrpc.common.wrappers.ListTasksResult;
import java.util.ArrayList;
import java.util.List;

public class ListTasksResultMapperImpl
implements ListTasksResultMapper {
    private final TaskMapper taskMapper = TaskMapper.INSTANCE;

    @Override
    public ListTasksResponse toProto(ListTasksResult domain) {
        if (domain == null) {
            return null;
        }
        ListTasksResponse.Builder listTasksResponse = ListTasksResponse.newBuilder();
        if (domain.nextPageToken() != null) {
            listTasksResponse.setNextPageToken(domain.nextPageToken());
        }
        listTasksResponse.setPageSize(domain.pageSize());
        listTasksResponse.setTotalSize(domain.totalSize());
        if (domain.tasks() != null) {
            for (io.a2a.spec.Task task : domain.tasks()) {
                listTasksResponse.addTasks(this.taskMapper.toProto(task));
            }
        }
        return listTasksResponse.build();
    }

    @Override
    public ListTasksResult fromProto(ListTasksResponse proto) {
        if (proto == null) {
            return null;
        }
        ListTasksResult.Builder listTasksResult = ListTasksResult.builder();
        if (proto.getNextPageToken() != null) {
            listTasksResult.nextPageToken(proto.getNextPageToken());
        }
        listTasksResult.tasks(this.taskListToTaskList(proto.getTasksList()));
        listTasksResult.totalSize(proto.getTotalSize());
        listTasksResult.pageSize(proto.getPageSize());
        return listTasksResult.build();
    }

    protected List<io.a2a.spec.Task> taskListToTaskList(List<Task> list) {
        if (list == null) {
            return null;
        }
        ArrayList<io.a2a.spec.Task> list1 = new ArrayList<io.a2a.spec.Task>(list.size());
        for (Task task : list) {
            list1.add(this.taskMapper.fromProto(task));
        }
        return list1;
    }
}

