/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.server;

import io.a2a.server.auth.User;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ServerCallContext {
    private final Map<Object, Object> modelConfig = new ConcurrentHashMap<Object, Object>();
    private final Map<String, Object> state;
    private final User user;
    private final Set<String> requestedExtensions;
    private final Set<String> activatedExtensions;

    public ServerCallContext(User user, Map<String, Object> state, Set<String> requestedExtensions) {
        this.user = user;
        this.state = state;
        this.requestedExtensions = new HashSet<String>(requestedExtensions);
        this.activatedExtensions = new HashSet<String>();
    }

    public Map<String, Object> getState() {
        return this.state;
    }

    public User getUser() {
        return this.user;
    }

    public Set<String> getRequestedExtensions() {
        return new HashSet<String>(this.requestedExtensions);
    }

    public Set<String> getActivatedExtensions() {
        return new HashSet<String>(this.activatedExtensions);
    }

    public void activateExtension(String extensionUri) {
        this.activatedExtensions.add(extensionUri);
    }

    public void deactivateExtension(String extensionUri) {
        this.activatedExtensions.remove(extensionUri);
    }

    public boolean isExtensionActivated(String extensionUri) {
        return this.activatedExtensions.contains(extensionUri);
    }

    public boolean isExtensionRequested(String extensionUri) {
        return this.requestedExtensions.contains(extensionUri);
    }
}

