/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.server.grpc.quarkus;

import io.a2a.transport.grpc.context.GrpcContextKeys;
import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Grpc;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import jakarta.enterprise.context.ApplicationScoped;

@ApplicationScoped
public class A2AExtensionsInterceptor
implements ServerInterceptor {
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> serverCallHandler) {
        Metadata.Key extensionsKey = Metadata.Key.of((String)"X-A2A-Extensions", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
        String extensions = (String)metadata.get(extensionsKey);
        Context context = Context.current().withValue(GrpcContextKeys.METADATA_KEY, (Object)metadata).withValue(GrpcContextKeys.METHOD_NAME_KEY, (Object)serverCall.getMethodDescriptor().getFullMethodName()).withValue(GrpcContextKeys.PEER_INFO_KEY, (Object)this.getPeerInfo(serverCall));
        if (extensions != null) {
            context = context.withValue(GrpcContextKeys.EXTENSIONS_HEADER_KEY, (Object)extensions);
        }
        return Contexts.interceptCall((Context)context, serverCall, (Metadata)metadata, serverCallHandler);
    }

    private String getPeerInfo(ServerCall<?, ?> serverCall) {
        try {
            Object remoteAddr = serverCall.getAttributes().get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR);
            return remoteAddr != null ? remoteAddr.toString() : "unknown";
        }
        catch (Exception e) {
            return "unknown";
        }
    }
}

