/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.jsonrpc.common.wrappers;

import io.a2a.jsonrpc.common.wrappers.A2AMessage;
import io.a2a.spec.A2AError;
import io.a2a.util.Assert;
import io.a2a.util.Utils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class A2AResponse<T>
implements A2AMessage {
    protected String jsonrpc;
    protected Object id;
    protected T result;
    protected A2AError error;

    public A2AResponse() {
    }

    public A2AResponse(String jsonrpc, Object id, T result, A2AError error, Class<T> resultType) {
        if (jsonrpc != null && !jsonrpc.equals("2.0")) {
            throw new IllegalArgumentException("Invalid JSON-RPC protocol version");
        }
        if (error != null && result != null) {
            throw new IllegalArgumentException("Invalid JSON-RPC error response");
        }
        if (error == null && result == null && !Void.class.equals(resultType)) {
            throw new IllegalArgumentException("Invalid JSON-RPC success response");
        }
        Assert.isNullOrStringOrInteger((Object)id);
        this.jsonrpc = (String)Utils.defaultIfNull((Object)jsonrpc, (Object)"2.0");
        this.id = id;
        this.result = result;
        this.error = error;
    }

    @Override
    public String getJsonrpc() {
        return this.jsonrpc;
    }

    @Override
    public Object getId() {
        return this.id;
    }

    public T getResult() {
        return this.result;
    }

    public A2AError getError() {
        return this.error;
    }
}

