/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.client.http;

import io.a2a.client.http.A2AHttpClient;
import io.a2a.client.http.A2AHttpClientProvider;
import io.a2a.client.http.JdkA2AHttpClient;
import java.util.Comparator;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;

public final class A2AHttpClientFactory {
    private A2AHttpClientFactory() {
    }

    public static A2AHttpClient create() {
        ServiceLoader<A2AHttpClientProvider> loader = ServiceLoader.load(A2AHttpClientProvider.class);
        return StreamSupport.stream(loader.spliterator(), false).max(Comparator.comparingInt(A2AHttpClientProvider::priority)).map(A2AHttpClientProvider::create).orElseGet(JdkA2AHttpClient::new);
    }

    public static A2AHttpClient create(String providerName) {
        if (providerName == null || providerName.isEmpty()) {
            throw new IllegalArgumentException("Provider name must not be null or empty");
        }
        ServiceLoader<A2AHttpClientProvider> loader = ServiceLoader.load(A2AHttpClientProvider.class);
        return StreamSupport.stream(loader.spliterator(), false).filter(provider -> providerName.equals(provider.name())).findFirst().map(A2AHttpClientProvider::create).orElseThrow(() -> new IllegalArgumentException("No A2AHttpClientProvider found with name: " + providerName));
    }
}

