/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.client.http;

import com.google.protobuf.Message;
import io.a2a.client.http.A2AHttpClient;
import io.a2a.client.http.A2AHttpClientFactory;
import io.a2a.client.http.A2AHttpResponse;
import io.a2a.grpc.AgentCard;
import io.a2a.grpc.AgentCardOrBuilder;
import io.a2a.grpc.utils.JSONRPCUtils;
import io.a2a.grpc.utils.ProtoUtils;
import io.a2a.jsonrpc.common.json.JsonProcessingException;
import io.a2a.spec.A2AClientError;
import io.a2a.spec.A2AClientJSONError;
import io.a2a.spec.A2AError;
import io.a2a.spec.AgentCard;
import io.a2a.spec.AgentInterface;
import io.a2a.util.Assert;
import io.a2a.util.Utils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.jspecify.annotations.Nullable;

public class A2ACardResolver {
    private final A2AHttpClient httpClient;
    private final String url;
    private final @Nullable Map<String, String> authHeaders;
    private static final String DEFAULT_AGENT_CARD_PATH = "/.well-known/agent-card.json";

    public A2ACardResolver(String baseUrl) throws A2AClientError {
        this(A2AHttpClientFactory.create(), baseUrl, null, null);
    }

    public A2ACardResolver(String baseUrl, @Nullable String tenant) throws A2AClientError {
        this(A2AHttpClientFactory.create(), baseUrl, tenant, null);
    }

    public A2ACardResolver(A2AHttpClient httpClient, String baseUrl, @Nullable String tenant) throws A2AClientError {
        this(httpClient, baseUrl, tenant, null);
    }

    public A2ACardResolver(A2AHttpClient httpClient, String baseUrl, @Nullable String tenant, @Nullable String agentCardPath) throws A2AClientError {
        this(httpClient, baseUrl, tenant, agentCardPath, null);
    }

    public A2ACardResolver(A2AHttpClient httpClient, String baseUrl, @Nullable String tenant, @Nullable String agentCardPath, @Nullable Map<String, String> authHeaders) throws A2AClientError {
        Assert.checkNotNullParam((String)"httpClient", (Object)httpClient);
        Assert.checkNotNullParam((String)"baseUrl", (Object)baseUrl);
        this.httpClient = httpClient;
        String effectiveAgentCardPath = agentCardPath == null || agentCardPath.isEmpty() ? DEFAULT_AGENT_CARD_PATH : agentCardPath;
        try {
            this.url = new URI(Utils.buildBaseUrl((AgentInterface)new AgentInterface("JSONRPC", baseUrl, ""), (String)tenant)).resolve(effectiveAgentCardPath).toString();
        }
        catch (URISyntaxException e) {
            throw new A2AClientError("Invalid agent URL", (Throwable)e);
        }
        this.authHeaders = authHeaders;
    }

    public AgentCard getAgentCard() throws A2AClientError, A2AClientJSONError {
        String body;
        A2AHttpClient.GetBuilder builder = (A2AHttpClient.GetBuilder)((A2AHttpClient.GetBuilder)this.httpClient.createGet().url(this.url)).addHeader("Content-Type", "application/json");
        if (this.authHeaders != null) {
            for (Map.Entry<String, String> entry : this.authHeaders.entrySet()) {
                builder.addHeader(entry.getKey(), entry.getValue());
            }
        }
        try {
            A2AHttpResponse response = builder.get();
            if (!response.success()) {
                throw new A2AClientError("Failed to obtain agent card: " + response.status());
            }
            body = response.body();
        }
        catch (IOException | InterruptedException e) {
            throw new A2AClientError("Failed to obtain agent card", (Throwable)e);
        }
        try {
            AgentCard.Builder agentCardBuilder = io.a2a.grpc.AgentCard.newBuilder();
            JSONRPCUtils.parseJsonString((String)body, (Message.Builder)agentCardBuilder, (Object)"");
            return ProtoUtils.FromProto.agentCard((AgentCardOrBuilder)agentCardBuilder);
        }
        catch (JsonProcessingException | A2AError e) {
            throw new A2AClientJSONError("Could not unmarshal agent card response", e);
        }
    }
}

