/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.client.http;

import io.a2a.client.http.A2AHttpClient;
import io.a2a.client.http.A2AHttpResponse;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.ext.web.codec.BodyCodec;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jspecify.annotations.Nullable;

public class VertxA2AHttpClient
implements A2AHttpClient,
AutoCloseable {
    private final Vertx vertx;
    private final WebClient webClient;
    private boolean ownsVertx;
    private static final Logger log = Logger.getLogger(VertxA2AHttpClient.class.getName());

    public VertxA2AHttpClient() {
        this.vertx = this.createVertx();
        WebClientOptions options = new WebClientOptions().setFollowRedirects(true).setKeepAlive(true);
        this.webClient = WebClient.create((Vertx)this.vertx, (WebClientOptions)options);
        log.fine("Vert.x client is ready.");
    }

    private Vertx createVertx() {
        try {
            BeanManager beanManager = CDI.current().getBeanManager();
            Set beans = beanManager.getBeans(Vertx.class, new Annotation[0]);
            if (beans != null && !beans.isEmpty()) {
                this.ownsVertx = false;
                Bean bean = (Bean)beans.iterator().next();
                CreationalContext context = beanManager.createCreationalContext((Contextual)bean);
                return (Vertx)beanManager.getReference(bean, Vertx.class, context);
            }
        }
        catch (Exception ex) {
            log.log(Level.FINE, "Error loading vertx from CDI error details", ex);
        }
        this.ownsVertx = true;
        return Vertx.vertx();
    }

    public VertxA2AHttpClient(Vertx vertx) {
        if (vertx == null) {
            throw new NullPointerException("vertx must not be null");
        }
        this.vertx = vertx;
        this.ownsVertx = false;
        WebClientOptions options = new WebClientOptions().setFollowRedirects(true).setKeepAlive(true);
        this.webClient = WebClient.create((Vertx)vertx, (WebClientOptions)options);
        log.fine("Vert.x client is ready.");
    }

    @Override
    public void close() {
        this.webClient.close();
        if (this.ownsVertx) {
            this.vertx.close();
        }
    }

    public A2AHttpClient.GetBuilder createGet() {
        return new VertxGetBuilder();
    }

    public A2AHttpClient.PostBuilder createPost() {
        return new VertxPostBuilder();
    }

    public A2AHttpClient.DeleteBuilder createDelete() {
        return new VertxDeleteBuilder();
    }

    private A2AHttpResponse executeSyncRequest(HttpRequest<Buffer> request, Map<String, String> headers, @Nullable Buffer bodyBuffer) throws IOException, InterruptedException {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            request.putHeader(entry.getKey(), entry.getValue());
        }
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference responseRef = new AtomicReference();
        AtomicReference errorRef = new AtomicReference();
        if (bodyBuffer != null) {
            request.sendBuffer(bodyBuffer, ar -> this.handleResponse((AsyncResult<HttpResponse<Buffer>>)ar, responseRef, errorRef, latch));
        } else {
            request.send(ar -> this.handleResponse((AsyncResult<HttpResponse<Buffer>>)ar, responseRef, errorRef, latch));
        }
        latch.await();
        if (errorRef.get() != null) {
            Throwable error = (Throwable)errorRef.get();
            if (error instanceof IOException) {
                throw (IOException)error;
            }
            if (error instanceof InterruptedException) {
                throw (InterruptedException)error;
            }
            throw new IOException("Request failed", error);
        }
        A2AHttpResponse finalResponse = (A2AHttpResponse)responseRef.get();
        if (finalResponse == null) {
            throw new IllegalStateException("No response from http request");
        }
        return finalResponse;
    }

    private void handleResponse(AsyncResult<HttpResponse<Buffer>> ar, AtomicReference<A2AHttpResponse> responseRef, AtomicReference<Throwable> errorRef, CountDownLatch latch) {
        if (ar.succeeded()) {
            HttpResponse response = (HttpResponse)ar.result();
            int status = response.statusCode();
            switch (status) {
                case 401: {
                    errorRef.set(new IOException("Authentication failed: Client credentials are missing or invalid"));
                    break;
                }
                case 403: {
                    errorRef.set(new IOException("Authorization failed: Client does not have permission for the operation"));
                    break;
                }
                default: {
                    String body = response.bodyAsString();
                    responseRef.set(new VertxHttpResponse(status, body != null ? body : ""));
                    break;
                }
            }
        } else {
            errorRef.set(ar.cause());
        }
        latch.countDown();
    }

    private CompletableFuture<Void> executeAsyncSSE(HttpRequest<Buffer> baseRequest, Map<String, String> headers, @Nullable Buffer bodyBuffer, Consumer<String> messageConsumer, Consumer<Throwable> errorConsumer, Runnable completeRunnable) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        AtomicBoolean successOccurred = new AtomicBoolean(false);
        AtomicBoolean streamEnded = new AtomicBoolean(false);
        AtomicBoolean futureCompleted = new AtomicBoolean(false);
        HttpRequest request = baseRequest.putHeader("Accept", "text/event-stream").as(BodyCodec.sseStream(stream -> {
            stream.handler(event -> {
                String data = event.data();
                if (data != null && !(data = data.trim()).isEmpty()) {
                    messageConsumer.accept(data);
                }
            });
            stream.endHandler(v -> {
                streamEnded.set(true);
                if (successOccurred.get() && futureCompleted.compareAndSet(false, true)) {
                    completeRunnable.run();
                    future.complete(null);
                }
            });
            stream.exceptionHandler(error -> {
                if (futureCompleted.compareAndSet(false, true)) {
                    errorConsumer.accept((Throwable)error);
                    future.complete(null);
                }
            });
        }));
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            request.putHeader(entry.getKey(), entry.getValue());
        }
        Future sendFuture = bodyBuffer != null ? request.sendBuffer(bodyBuffer) : request.send();
        sendFuture.onSuccess(response -> {
            int statusCode = response.statusCode();
            if (statusCode < 200 || statusCode >= 300) {
                if (futureCompleted.compareAndSet(false, true)) {
                    IOException error = switch (statusCode) {
                        case 401 -> new IOException("Authentication failed: Client credentials are missing or invalid");
                        case 403 -> new IOException("Authorization failed: Client does not have permission for the operation");
                        default -> new IOException("HTTP " + statusCode + ": " + response.bodyAsString());
                    };
                    errorConsumer.accept(error);
                    future.complete(null);
                }
            } else {
                successOccurred.set(true);
                if (streamEnded.get() && futureCompleted.compareAndSet(false, true)) {
                    completeRunnable.run();
                    future.complete(null);
                }
            }
        }).onFailure(cause -> {
            if (futureCompleted.compareAndSet(false, true)) {
                errorConsumer.accept((Throwable)cause);
                future.complete(null);
            }
        });
        return future;
    }

    private class VertxGetBuilder
    extends VertxBuilder<A2AHttpClient.GetBuilder>
    implements A2AHttpClient.GetBuilder {
        private VertxGetBuilder() {
        }

        public A2AHttpResponse get() throws IOException, InterruptedException {
            return VertxA2AHttpClient.this.executeSyncRequest((HttpRequest<Buffer>)VertxA2AHttpClient.this.webClient.getAbs(this.url), this.headers, null);
        }

        public CompletableFuture<Void> getAsyncSSE(Consumer<String> messageConsumer, Consumer<Throwable> errorConsumer, Runnable completeRunnable) throws IOException, InterruptedException {
            HttpRequest request = VertxA2AHttpClient.this.webClient.getAbs(this.url);
            return VertxA2AHttpClient.this.executeAsyncSSE((HttpRequest<Buffer>)request, this.headers, null, messageConsumer, errorConsumer, completeRunnable);
        }
    }

    private class VertxPostBuilder
    extends VertxBuilder<A2AHttpClient.PostBuilder>
    implements A2AHttpClient.PostBuilder {
        private String body;

        private VertxPostBuilder() {
            this.body = "";
        }

        public A2AHttpClient.PostBuilder body(String body) {
            this.body = body;
            return (A2AHttpClient.PostBuilder)this.self();
        }

        public A2AHttpResponse post() throws IOException, InterruptedException {
            Buffer bodyBuffer = Buffer.buffer((String)this.body, (String)StandardCharsets.UTF_8.name());
            return VertxA2AHttpClient.this.executeSyncRequest((HttpRequest<Buffer>)VertxA2AHttpClient.this.webClient.postAbs(this.url), this.headers, bodyBuffer);
        }

        public CompletableFuture<Void> postAsyncSSE(Consumer<String> messageConsumer, Consumer<Throwable> errorConsumer, Runnable completeRunnable) throws IOException, InterruptedException {
            HttpRequest request = VertxA2AHttpClient.this.webClient.postAbs(this.url);
            Buffer bodyBuffer = Buffer.buffer((String)this.body, (String)StandardCharsets.UTF_8.name());
            return VertxA2AHttpClient.this.executeAsyncSSE((HttpRequest<Buffer>)request, this.headers, bodyBuffer, messageConsumer, errorConsumer, completeRunnable);
        }
    }

    private class VertxDeleteBuilder
    extends VertxBuilder<A2AHttpClient.DeleteBuilder>
    implements A2AHttpClient.DeleteBuilder {
        private VertxDeleteBuilder() {
        }

        public A2AHttpResponse delete() throws IOException, InterruptedException {
            return VertxA2AHttpClient.this.executeSyncRequest((HttpRequest<Buffer>)VertxA2AHttpClient.this.webClient.deleteAbs(this.url), this.headers, null);
        }
    }

    private record VertxHttpResponse(int status, String body) implements A2AHttpResponse
    {
        public boolean success() {
            return this.status >= 200 && this.status < 300;
        }
    }

    private abstract class VertxBuilder<T extends A2AHttpClient.Builder<T>>
    implements A2AHttpClient.Builder<T> {
        protected String url = "";
        protected Map<String, String> headers = new HashMap<String, String>();

        private VertxBuilder() {
        }

        public T url(String url) {
            this.url = url;
            return this.self();
        }

        public T addHeader(String name, String value) {
            this.headers.put(name, value);
            return this.self();
        }

        public T addHeaders(Map<String, String> headers) {
            if (headers != null && !headers.isEmpty()) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    this.addHeader(entry.getKey(), entry.getValue());
                }
            }
            return this.self();
        }

        T self() {
            return (T)this;
        }
    }
}

