/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.examples.cloud;

import io.a2a.server.agentexecution.AgentExecutor;
import io.a2a.server.agentexecution.RequestContext;
import io.a2a.server.events.EventQueue;
import io.a2a.server.tasks.TaskUpdater;
import io.a2a.spec.InternalError;
import io.a2a.spec.JSONRPCError;
import io.a2a.spec.Message;
import io.a2a.spec.Part;
import io.a2a.spec.TextPart;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class CloudAgentExecutorProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloudAgentExecutorProducer.class);

    @Produces
    public AgentExecutor agentExecutor() {
        return new CloudAgentExecutor();
    }

    private static class CloudAgentExecutor
    implements AgentExecutor {
        private CloudAgentExecutor() {
        }

        public void execute(RequestContext context, EventQueue eventQueue) throws JSONRPCError {
            TaskUpdater updater = new TaskUpdater(context, eventQueue);
            try {
                String messageText = this.extractTextFromMessage(context.getMessage()).trim().toLowerCase();
                LOGGER.info("Received message: '{}'", (Object)messageText);
                String podName = System.getenv("POD_NAME");
                if (podName == null || podName.isEmpty()) {
                    podName = "unknown-pod";
                }
                LOGGER.info("Processing on pod: {}", (Object)podName);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InternalError("Processing interrupted");
                }
                if ("complete".equals(messageText)) {
                    LOGGER.info("Completion requested on pod: {}", (Object)podName);
                    String artifactText = "Completed by " + podName;
                    List<TextPart> parts = List.of(new TextPart(artifactText, null));
                    updater.addArtifact(parts);
                    updater.complete();
                    LOGGER.info("Task completed on pod: {}", (Object)podName);
                } else if (context.getTask() == null) {
                    LOGGER.info("Creating new task on pod: {}", (Object)podName);
                    updater.submit();
                    updater.startWork();
                    String artifactText = "Started by " + podName;
                    List<TextPart> parts = List.of(new TextPart(artifactText, null));
                    updater.addArtifact(parts);
                    LOGGER.info("Task created and started on pod: {}", (Object)podName);
                } else {
                    LOGGER.info("Adding artifact on pod: {}", (Object)podName);
                    String artifactText = "Processed by " + podName;
                    List<TextPart> parts = List.of(new TextPart(artifactText, null));
                    updater.addArtifact(parts);
                    LOGGER.info("Artifact added on pod: {}", (Object)podName);
                }
            }
            catch (JSONRPCError e) {
                LOGGER.error("JSONRPC error processing task", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                LOGGER.error("Error processing task", (Throwable)e);
                throw new InternalError("Processing failed: " + e.getMessage());
            }
        }

        public void cancel(RequestContext context, EventQueue eventQueue) throws JSONRPCError {
            LOGGER.info("Task cancellation requested");
            TaskUpdater updater = new TaskUpdater(context, eventQueue);
            updater.cancel();
        }

        private String extractTextFromMessage(Message message) {
            StringBuilder textBuilder = new StringBuilder();
            if (message.getParts() != null) {
                for (Part part : message.getParts()) {
                    if (!(part instanceof TextPart)) continue;
                    TextPart textPart = (TextPart)part;
                    textBuilder.append(textPart.getText());
                }
            }
            return textBuilder.toString();
        }
    }
}

