/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.client;

import io.a2a.client.AbstractClient;
import io.a2a.client.ClientBuilder;
import io.a2a.client.ClientEvent;
import io.a2a.client.ClientTaskManager;
import io.a2a.client.MessageEvent;
import io.a2a.client.TaskEvent;
import io.a2a.client.TaskUpdateEvent;
import io.a2a.client.config.ClientConfig;
import io.a2a.client.transport.spi.ClientTransport;
import io.a2a.client.transport.spi.interceptors.ClientCallContext;
import io.a2a.jsonrpc.common.wrappers.ListTasksResult;
import io.a2a.spec.A2AClientError;
import io.a2a.spec.A2AClientException;
import io.a2a.spec.A2AClientInvalidStateError;
import io.a2a.spec.AgentCard;
import io.a2a.spec.DeleteTaskPushNotificationConfigParams;
import io.a2a.spec.EventKind;
import io.a2a.spec.GetTaskPushNotificationConfigParams;
import io.a2a.spec.ListTaskPushNotificationConfigParams;
import io.a2a.spec.ListTaskPushNotificationConfigResult;
import io.a2a.spec.ListTasksParams;
import io.a2a.spec.Message;
import io.a2a.spec.MessageSendConfiguration;
import io.a2a.spec.MessageSendParams;
import io.a2a.spec.PushNotificationConfig;
import io.a2a.spec.StreamingEventKind;
import io.a2a.spec.Task;
import io.a2a.spec.TaskArtifactUpdateEvent;
import io.a2a.spec.TaskIdParams;
import io.a2a.spec.TaskPushNotificationConfig;
import io.a2a.spec.TaskQueryParams;
import io.a2a.spec.TaskStatusUpdateEvent;
import io.a2a.spec.UpdateEvent;
import io.a2a.util.Assert;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class Client
extends AbstractClient {
    private final ClientConfig clientConfig;
    private final ClientTransport clientTransport;
    private AgentCard agentCard;

    Client(AgentCard agentCard, ClientConfig clientConfig, ClientTransport clientTransport, List<BiConsumer<ClientEvent, AgentCard>> consumers, @Nullable Consumer<Throwable> streamingErrorHandler) {
        super(consumers, streamingErrorHandler);
        Assert.checkNotNullParam((String)"agentCard", (Object)agentCard);
        this.agentCard = agentCard;
        this.clientConfig = clientConfig;
        this.clientTransport = clientTransport;
    }

    public static ClientBuilder builder(AgentCard agentCard) {
        return new ClientBuilder(agentCard);
    }

    @Override
    public void sendMessage(@NonNull Message request, @NonNull List<BiConsumer<ClientEvent, AgentCard>> consumers, @Nullable Consumer<Throwable> streamingErrorHandler, @Nullable ClientCallContext context) throws A2AClientException {
        MessageSendParams messageSendParams = this.getMessageSendParams(request, this.clientConfig);
        this.sendMessage(messageSendParams, consumers, streamingErrorHandler, context);
    }

    @Override
    public void sendMessage(@NonNull Message request, @Nullable PushNotificationConfig pushNotificationConfiguration, @Nullable Map<String, Object> metadata, @Nullable ClientCallContext context) throws A2AClientException {
        MessageSendConfiguration messageSendConfiguration = this.createMessageSendConfiguration(pushNotificationConfiguration);
        MessageSendParams messageSendParams = MessageSendParams.builder().message(request).configuration(messageSendConfiguration).metadata(metadata).build();
        this.sendMessage(messageSendParams, (List<BiConsumer<ClientEvent, AgentCard>>)this.consumers, (Consumer<Throwable>)this.streamingErrorHandler, context);
    }

    @Override
    public Task getTask(TaskQueryParams request, @Nullable ClientCallContext context) throws A2AClientException {
        return this.clientTransport.getTask(request, context);
    }

    @Override
    public ListTasksResult listTasks(ListTasksParams request, @Nullable ClientCallContext context) throws A2AClientException {
        return this.clientTransport.listTasks(request, context);
    }

    @Override
    public Task cancelTask(TaskIdParams request, @Nullable ClientCallContext context) throws A2AClientException {
        return this.clientTransport.cancelTask(request, context);
    }

    @Override
    public TaskPushNotificationConfig setTaskPushNotificationConfiguration(TaskPushNotificationConfig request, @Nullable ClientCallContext context) throws A2AClientException {
        return this.clientTransport.setTaskPushNotificationConfiguration(request, context);
    }

    @Override
    public TaskPushNotificationConfig getTaskPushNotificationConfiguration(GetTaskPushNotificationConfigParams request, @Nullable ClientCallContext context) throws A2AClientException {
        return this.clientTransport.getTaskPushNotificationConfiguration(request, context);
    }

    @Override
    public ListTaskPushNotificationConfigResult listTaskPushNotificationConfigurations(ListTaskPushNotificationConfigParams request, @Nullable ClientCallContext context) throws A2AClientException {
        return this.clientTransport.listTaskPushNotificationConfigurations(request, context);
    }

    @Override
    public void deleteTaskPushNotificationConfigurations(DeleteTaskPushNotificationConfigParams request, @Nullable ClientCallContext context) throws A2AClientException {
        this.clientTransport.deleteTaskPushNotificationConfigurations(request, context);
    }

    @Override
    public void resubscribe(@NonNull TaskIdParams request, @NonNull List<BiConsumer<ClientEvent, AgentCard>> consumers, @Nullable Consumer<Throwable> streamingErrorHandler, @Nullable ClientCallContext context) throws A2AClientException {
        if (!this.clientConfig.isStreaming() || !this.agentCard.capabilities().streaming()) {
            throw new A2AClientException("Client and/or server does not support resubscription");
        }
        ClientTaskManager tracker = new ClientTaskManager();
        Consumer<Throwable> overriddenErrorHandler = this.getOverriddenErrorHandler(streamingErrorHandler);
        Consumer<StreamingEventKind> eventHandler = event -> {
            try {
                ClientEvent clientEvent = this.getClientEvent((StreamingEventKind)event, tracker);
                this.consume(clientEvent, this.agentCard, consumers);
            }
            catch (A2AClientError e) {
                overriddenErrorHandler.accept(e);
            }
        };
        this.clientTransport.resubscribe(request, eventHandler, overriddenErrorHandler, context);
    }

    @Override
    public AgentCard getAgentCard(@Nullable ClientCallContext context) throws A2AClientException {
        this.agentCard = this.clientTransport.getAgentCard(context);
        return this.agentCard;
    }

    @Override
    public void close() {
        this.clientTransport.close();
    }

    private ClientEvent getClientEvent(StreamingEventKind event, ClientTaskManager taskManager) throws A2AClientError {
        if (event instanceof Message) {
            Message message = (Message)event;
            return new MessageEvent(message);
        }
        if (event instanceof Task) {
            Task task = (Task)event;
            taskManager.saveTaskEvent(task);
            return new TaskEvent(taskManager.getCurrentTask());
        }
        if (event instanceof TaskStatusUpdateEvent) {
            TaskStatusUpdateEvent updateEvent = (TaskStatusUpdateEvent)event;
            taskManager.saveTaskEvent(updateEvent);
            return new TaskUpdateEvent(taskManager.getCurrentTask(), (UpdateEvent)updateEvent);
        }
        if (event instanceof TaskArtifactUpdateEvent) {
            TaskArtifactUpdateEvent updateEvent = (TaskArtifactUpdateEvent)event;
            taskManager.saveTaskEvent(updateEvent);
            return new TaskUpdateEvent(taskManager.getCurrentTask(), (UpdateEvent)updateEvent);
        }
        throw new A2AClientInvalidStateError("Invalid client event");
    }

    private MessageSendConfiguration createMessageSendConfiguration(@Nullable PushNotificationConfig pushNotificationConfig) {
        return MessageSendConfiguration.builder().acceptedOutputModes(this.clientConfig.getAcceptedOutputModes()).blocking(Boolean.valueOf(!this.clientConfig.isPolling())).historyLength(this.clientConfig.getHistoryLength()).pushNotificationConfig(pushNotificationConfig).build();
    }

    private void sendMessage(@NonNull MessageSendParams messageSendParams, @NonNull List<BiConsumer<ClientEvent, AgentCard>> consumers, @Nullable Consumer<Throwable> errorHandler, @Nullable ClientCallContext context) throws A2AClientException {
        if (!this.clientConfig.isStreaming() || !this.agentCard.capabilities().streaming()) {
            ClientEvent clientEvent;
            EventKind eventKind = this.clientTransport.sendMessage(messageSendParams, context);
            if (eventKind instanceof Task) {
                Task task = (Task)eventKind;
                clientEvent = new TaskEvent(task);
            } else {
                clientEvent = new MessageEvent((Message)eventKind);
            }
            this.consume(clientEvent, this.agentCard, consumers);
        } else {
            ClientTaskManager tracker = new ClientTaskManager();
            Consumer<Throwable> overriddenErrorHandler = this.getOverriddenErrorHandler(errorHandler);
            Consumer<StreamingEventKind> eventHandler = event -> {
                try {
                    ClientEvent clientEvent = this.getClientEvent((StreamingEventKind)event, tracker);
                    this.consume(clientEvent, this.agentCard, consumers);
                }
                catch (A2AClientError e) {
                    overriddenErrorHandler.accept(e);
                }
            };
            this.clientTransport.sendMessageStreaming(messageSendParams, eventHandler, overriddenErrorHandler, context);
        }
    }

    private @NonNull Consumer<Throwable> getOverriddenErrorHandler(@Nullable Consumer<Throwable> errorHandler) {
        return e -> {
            if (errorHandler != null) {
                errorHandler.accept((Throwable)e);
            } else if (this.getStreamingErrorHandler() != null) {
                this.getStreamingErrorHandler().accept((Throwable)e);
            }
        };
    }

    private void consume(ClientEvent clientEvent, AgentCard agentCard, @NonNull List<BiConsumer<ClientEvent, AgentCard>> consumers) {
        for (BiConsumer<ClientEvent, AgentCard> consumer : consumers) {
            consumer.accept(clientEvent, agentCard);
        }
    }

    private MessageSendParams getMessageSendParams(Message request, ClientConfig clientConfig) {
        MessageSendConfiguration messageSendConfiguration = this.createMessageSendConfiguration(clientConfig.getPushNotificationConfig());
        return MessageSendParams.builder().message(request).configuration(messageSendConfiguration).metadata(clientConfig.getMetadata()).build();
    }
}

