/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.client.transport.rest;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.a2a.client.http.A2AHttpClient;
import io.a2a.client.http.A2AHttpClientFactory;
import io.a2a.client.http.A2AHttpResponse;
import io.a2a.client.transport.rest.RestErrorMapper;
import io.a2a.client.transport.rest.sse.SSEEventListener;
import io.a2a.client.transport.spi.ClientTransport;
import io.a2a.client.transport.spi.interceptors.ClientCallContext;
import io.a2a.client.transport.spi.interceptors.ClientCallInterceptor;
import io.a2a.client.transport.spi.interceptors.PayloadAndHeaders;
import io.a2a.grpc.CancelTaskRequest;
import io.a2a.grpc.CreateTaskPushNotificationConfigRequest;
import io.a2a.grpc.DeleteTaskPushNotificationConfigRequest;
import io.a2a.grpc.GetTaskPushNotificationConfigRequest;
import io.a2a.grpc.GetTaskRequest;
import io.a2a.grpc.ListTaskPushNotificationConfigRequest;
import io.a2a.grpc.ListTaskPushNotificationConfigResponse;
import io.a2a.grpc.ListTaskPushNotificationConfigResponseOrBuilder;
import io.a2a.grpc.ListTasksRequest;
import io.a2a.grpc.ListTasksResponse;
import io.a2a.grpc.SendMessageRequest;
import io.a2a.grpc.SendMessageResponse;
import io.a2a.grpc.SubscribeToTaskRequest;
import io.a2a.grpc.Task;
import io.a2a.grpc.TaskOrBuilder;
import io.a2a.grpc.TaskPushNotificationConfig;
import io.a2a.grpc.TaskPushNotificationConfigOrBuilder;
import io.a2a.grpc.utils.ProtoUtils;
import io.a2a.jsonrpc.common.json.JsonProcessingException;
import io.a2a.jsonrpc.common.json.JsonUtil;
import io.a2a.jsonrpc.common.wrappers.ListTasksResult;
import io.a2a.spec.A2AClientError;
import io.a2a.spec.A2AClientException;
import io.a2a.spec.AgentCard;
import io.a2a.spec.AgentInterface;
import io.a2a.spec.DeleteTaskPushNotificationConfigParams;
import io.a2a.spec.EventKind;
import io.a2a.spec.GetTaskPushNotificationConfigParams;
import io.a2a.spec.ListTaskPushNotificationConfigParams;
import io.a2a.spec.ListTaskPushNotificationConfigResult;
import io.a2a.spec.ListTasksParams;
import io.a2a.spec.MessageSendParams;
import io.a2a.spec.StreamingEventKind;
import io.a2a.spec.TaskIdParams;
import io.a2a.spec.TaskQueryParams;
import io.a2a.spec.TaskState;
import io.a2a.util.Assert;
import io.a2a.util.Utils;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.jspecify.annotations.Nullable;

public class RestTransport
implements ClientTransport {
    private static final Logger log = Logger.getLogger(RestTransport.class.getName());
    private final A2AHttpClient httpClient;
    private final AgentInterface agentInterface;
    private final @Nullable List<ClientCallInterceptor> interceptors;
    private final AgentCard agentCard;

    public RestTransport(AgentCard agentCard) {
        this(null, agentCard, Utils.getFavoriteInterface((AgentCard)agentCard), null);
    }

    public RestTransport(@Nullable A2AHttpClient httpClient, AgentCard agentCard, AgentInterface agentInterface, @Nullable List<ClientCallInterceptor> interceptors) {
        this.httpClient = httpClient == null ? A2AHttpClientFactory.create() : httpClient;
        this.agentCard = agentCard;
        this.agentInterface = agentInterface;
        this.interceptors = interceptors;
    }

    public EventKind sendMessage(MessageSendParams messageSendParams, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"messageSendParams", (Object)messageSendParams);
        SendMessageRequest.Builder builder = SendMessageRequest.newBuilder((SendMessageRequest)ProtoUtils.ToProto.sendMessageRequest((MessageSendParams)messageSendParams));
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("SendMessage", (MessageOrBuilder)builder, this.agentCard, context);
        try {
            String httpResponseBody = this.sendPostRequest(Utils.buildBaseUrl((AgentInterface)this.agentInterface, (String)messageSendParams.tenant()) + "/message:send", payloadAndHeaders);
            SendMessageResponse.Builder responseBuilder = SendMessageResponse.newBuilder();
            JsonFormat.parser().merge(httpResponseBody, (Message.Builder)responseBuilder);
            if (responseBuilder.hasMessage()) {
                return ProtoUtils.FromProto.message((io.a2a.grpc.MessageOrBuilder)responseBuilder.getMessage());
            }
            if (responseBuilder.hasTask()) {
                return ProtoUtils.FromProto.task((TaskOrBuilder)responseBuilder.getTask());
            }
            throw new A2AClientException("Failed to send message, wrong response:" + httpResponseBody);
        }
        catch (A2AClientException e) {
            throw e;
        }
        catch (JsonProcessingException | IOException | InterruptedException e) {
            throw new A2AClientException("Failed to send message: " + String.valueOf(e), e);
        }
    }

    public void sendMessageStreaming(MessageSendParams messageSendParams, Consumer<StreamingEventKind> eventConsumer, Consumer<Throwable> errorConsumer, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)messageSendParams);
        Assert.checkNotNullParam((String)"eventConsumer", eventConsumer);
        Assert.checkNotNullParam((String)"messageSendParams", (Object)messageSendParams);
        SendMessageRequest.Builder builder = SendMessageRequest.newBuilder((SendMessageRequest)ProtoUtils.ToProto.sendMessageRequest((MessageSendParams)messageSendParams));
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("SendStreamingMessage", (MessageOrBuilder)builder, this.agentCard, context);
        AtomicReference<CompletableFuture> ref = new AtomicReference<CompletableFuture>();
        SSEEventListener sseEventListener = new SSEEventListener(eventConsumer, errorConsumer);
        try {
            A2AHttpClient.PostBuilder postBuilder = this.createPostBuilder(Utils.buildBaseUrl((AgentInterface)this.agentInterface, (String)messageSendParams.tenant()) + "/message:stream", payloadAndHeaders);
            ref.set(postBuilder.postAsyncSSE(msg -> sseEventListener.onMessage((String)msg, (Future)ref.get()), throwable -> sseEventListener.onError((Throwable)throwable, (Future)ref.get()), () -> {}));
        }
        catch (IOException e) {
            throw new A2AClientException("Failed to send streaming message request: " + String.valueOf(e), (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new A2AClientException("Send streaming message request timed out: " + String.valueOf(e), (Throwable)e);
        }
        catch (JsonProcessingException e) {
            throw new A2AClientException("Failed to process JSON for streaming message request: " + String.valueOf((Object)e), (Throwable)e);
        }
    }

    public io.a2a.spec.Task getTask(TaskQueryParams taskQueryParams, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"taskQueryParams", (Object)taskQueryParams);
        GetTaskRequest.Builder builder = GetTaskRequest.newBuilder();
        builder.setId(taskQueryParams.id());
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("GetTask", (MessageOrBuilder)builder, this.agentCard, context);
        try {
            A2AHttpResponse response;
            StringBuilder url = new StringBuilder(Utils.buildBaseUrl((AgentInterface)this.agentInterface, (String)taskQueryParams.tenant()));
            if (taskQueryParams.historyLength() != null && taskQueryParams.historyLength() > 0) {
                url.append(String.format("/tasks/%1s?historyLength=%2d", taskQueryParams.id(), taskQueryParams.historyLength()));
            } else {
                url.append(String.format("/tasks/%1s", taskQueryParams.id()));
            }
            A2AHttpClient.GetBuilder getBuilder = (A2AHttpClient.GetBuilder)this.httpClient.createGet().url(url.toString());
            if (payloadAndHeaders.getHeaders() != null) {
                for (Map.Entry entry : payloadAndHeaders.getHeaders().entrySet()) {
                    getBuilder.addHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (!(response = getBuilder.get()).success()) {
                throw RestErrorMapper.mapRestError(response);
            }
            String httpResponseBody = response.body();
            Task.Builder responseBuilder = Task.newBuilder();
            JsonFormat.parser().merge(httpResponseBody, (Message.Builder)responseBuilder);
            return ProtoUtils.FromProto.task((TaskOrBuilder)responseBuilder);
        }
        catch (A2AClientException e) {
            throw e;
        }
        catch (IOException | InterruptedException e) {
            throw new A2AClientException("Failed to get task: " + String.valueOf(e), (Throwable)e);
        }
    }

    public io.a2a.spec.Task cancelTask(TaskIdParams taskIdParams, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"taskIdParams", (Object)taskIdParams);
        CancelTaskRequest.Builder builder = CancelTaskRequest.newBuilder();
        builder.setId(taskIdParams.id());
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("CancelTask", (MessageOrBuilder)builder, this.agentCard, context);
        try {
            String httpResponseBody = this.sendPostRequest(Utils.buildBaseUrl((AgentInterface)this.agentInterface, (String)taskIdParams.tenant()) + String.format("/tasks/%1s:cancel", taskIdParams.id()), payloadAndHeaders);
            Task.Builder responseBuilder = Task.newBuilder();
            JsonFormat.parser().merge(httpResponseBody, (Message.Builder)responseBuilder);
            return ProtoUtils.FromProto.task((TaskOrBuilder)responseBuilder);
        }
        catch (A2AClientException e) {
            throw e;
        }
        catch (JsonProcessingException | IOException | InterruptedException e) {
            throw new A2AClientException("Failed to cancel task: " + String.valueOf(e), e);
        }
    }

    public ListTasksResult listTasks(ListTasksParams request, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        ListTasksRequest.Builder builder = ListTasksRequest.newBuilder();
        if (request.contextId() != null) {
            builder.setContextId(request.contextId());
        }
        if (request.status() != null) {
            builder.setStatus(ProtoUtils.ToProto.taskState((TaskState)request.status()));
        }
        if (request.pageSize() != null) {
            builder.setPageSize(request.pageSize().intValue());
        }
        if (request.pageToken() != null) {
            builder.setPageToken(request.pageToken());
        }
        if (request.historyLength() != null) {
            builder.setHistoryLength(request.historyLength().intValue());
        }
        if (request.tenant() != null) {
            builder.setTenant(request.tenant());
        }
        if (request.includeArtifacts() != null && request.includeArtifacts().booleanValue()) {
            builder.setIncludeArtifacts(true);
        }
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("ListTasks", (MessageOrBuilder)builder, this.agentCard, context);
        try {
            A2AHttpResponse response;
            StringBuilder urlBuilder = new StringBuilder(Utils.buildBaseUrl((AgentInterface)this.agentInterface, (String)request.tenant()));
            urlBuilder.append("/tasks");
            String queryParams = this.buildListTasksQueryString(request);
            if (!queryParams.isEmpty()) {
                urlBuilder.append("?").append(queryParams);
            }
            A2AHttpClient.GetBuilder getBuilder = (A2AHttpClient.GetBuilder)this.httpClient.createGet().url(urlBuilder.toString());
            if (payloadAndHeaders.getHeaders() != null) {
                for (Map.Entry entry : payloadAndHeaders.getHeaders().entrySet()) {
                    getBuilder.addHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (!(response = getBuilder.get()).success()) {
                throw RestErrorMapper.mapRestError(response);
            }
            String httpResponseBody = response.body();
            ListTasksResponse.Builder responseBuilder = ListTasksResponse.newBuilder();
            JsonFormat.parser().merge(httpResponseBody, (Message.Builder)responseBuilder);
            return new ListTasksResult(responseBuilder.getTasksList().stream().map(ProtoUtils.FromProto::task).toList(), responseBuilder.getTotalSize(), responseBuilder.getTasksCount(), responseBuilder.getNextPageToken().isEmpty() ? null : responseBuilder.getNextPageToken());
        }
        catch (IOException | InterruptedException e) {
            throw new A2AClientException("Failed to list tasks: " + String.valueOf(e), (Throwable)e);
        }
    }

    private String buildListTasksQueryString(ListTasksParams request) {
        ArrayList<Object> queryParts = new ArrayList<Object>();
        if (request.contextId() != null) {
            queryParts.add("contextId=" + URLEncoder.encode(request.contextId(), StandardCharsets.UTF_8));
        }
        if (request.status() != null) {
            queryParts.add("status=" + request.status().asString());
        }
        if (request.pageSize() != null) {
            queryParts.add("pageSize=" + request.pageSize());
        }
        if (request.pageToken() != null) {
            queryParts.add("pageToken=" + URLEncoder.encode(request.pageToken(), StandardCharsets.UTF_8));
        }
        if (request.historyLength() != null) {
            queryParts.add("historyLength=" + request.historyLength());
        }
        if (request.includeArtifacts() != null && request.includeArtifacts().booleanValue()) {
            queryParts.add("includeArtifacts=true");
        }
        return String.join((CharSequence)"&", queryParts);
    }

    public io.a2a.spec.TaskPushNotificationConfig createTaskPushNotificationConfiguration(io.a2a.spec.TaskPushNotificationConfig request, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        CreateTaskPushNotificationConfigRequest.Builder builder = CreateTaskPushNotificationConfigRequest.newBuilder();
        builder.setConfig(ProtoUtils.ToProto.taskPushNotificationConfig((io.a2a.spec.TaskPushNotificationConfig)request).getPushNotificationConfig()).setTaskId(request.taskId());
        if (request.pushNotificationConfig().id() != null) {
            builder.setConfigId(request.pushNotificationConfig().id());
        }
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("CreateTaskPushNotificationConfig", (MessageOrBuilder)builder, this.agentCard, context);
        try {
            String httpResponseBody = this.sendPostRequest(Utils.buildBaseUrl((AgentInterface)this.agentInterface, (String)request.tenant()) + String.format("/tasks/%1s/pushNotificationConfigs", request.taskId()), payloadAndHeaders);
            TaskPushNotificationConfig.Builder responseBuilder = TaskPushNotificationConfig.newBuilder();
            JsonFormat.parser().merge(httpResponseBody, (Message.Builder)responseBuilder);
            return ProtoUtils.FromProto.taskPushNotificationConfig((TaskPushNotificationConfigOrBuilder)responseBuilder);
        }
        catch (A2AClientException e) {
            throw e;
        }
        catch (JsonProcessingException | IOException | InterruptedException e) {
            throw new A2AClientException("Failed to set task push notification config: " + String.valueOf(e), e);
        }
    }

    public io.a2a.spec.TaskPushNotificationConfig getTaskPushNotificationConfiguration(GetTaskPushNotificationConfigParams request, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        GetTaskPushNotificationConfigRequest.Builder builder = GetTaskPushNotificationConfigRequest.newBuilder();
        StringBuilder url = new StringBuilder(Utils.buildBaseUrl((AgentInterface)this.agentInterface, (String)request.tenant()));
        String configId = request.pushNotificationConfigId();
        if (configId != null && !configId.isEmpty()) {
            builder.setId(configId).setTaskId(request.id());
            url.append(String.format("/tasks/%1s/pushNotificationConfigs/%2s", request.id(), configId));
        } else {
            builder.setTaskId(request.id());
            url.append(String.format("/tasks/%1s/pushNotificationConfigs/", request.id()));
        }
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("GetTaskPushNotificationConfig", (MessageOrBuilder)builder, this.agentCard, context);
        try {
            A2AHttpResponse response;
            A2AHttpClient.GetBuilder getBuilder = (A2AHttpClient.GetBuilder)this.httpClient.createGet().url(url.toString());
            if (payloadAndHeaders.getHeaders() != null) {
                for (Map.Entry entry : payloadAndHeaders.getHeaders().entrySet()) {
                    getBuilder.addHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (!(response = getBuilder.get()).success()) {
                throw RestErrorMapper.mapRestError(response);
            }
            String httpResponseBody = response.body();
            TaskPushNotificationConfig.Builder responseBuilder = TaskPushNotificationConfig.newBuilder();
            JsonFormat.parser().merge(httpResponseBody, (Message.Builder)responseBuilder);
            return ProtoUtils.FromProto.taskPushNotificationConfig((TaskPushNotificationConfigOrBuilder)responseBuilder);
        }
        catch (A2AClientException e) {
            throw e;
        }
        catch (IOException | InterruptedException e) {
            throw new A2AClientException("Failed to get push notifications: " + String.valueOf(e), (Throwable)e);
        }
    }

    public ListTaskPushNotificationConfigResult listTaskPushNotificationConfigurations(ListTaskPushNotificationConfigParams request, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        ListTaskPushNotificationConfigRequest.Builder builder = ListTaskPushNotificationConfigRequest.newBuilder();
        builder.setTaskId(request.id());
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("ListTaskPushNotificationConfig", (MessageOrBuilder)builder, this.agentCard, context);
        try {
            A2AHttpResponse response;
            String url = Utils.buildBaseUrl((AgentInterface)this.agentInterface, (String)request.tenant()) + String.format("/tasks/%1s/pushNotificationConfigs", request.id());
            A2AHttpClient.GetBuilder getBuilder = (A2AHttpClient.GetBuilder)this.httpClient.createGet().url(url);
            if (payloadAndHeaders.getHeaders() != null) {
                for (Map.Entry entry : payloadAndHeaders.getHeaders().entrySet()) {
                    getBuilder.addHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (!(response = getBuilder.get()).success()) {
                throw RestErrorMapper.mapRestError(response);
            }
            String httpResponseBody = response.body();
            ListTaskPushNotificationConfigResponse.Builder responseBuilder = ListTaskPushNotificationConfigResponse.newBuilder();
            JsonFormat.parser().merge(httpResponseBody, (Message.Builder)responseBuilder);
            return ProtoUtils.FromProto.listTaskPushNotificationConfigResult((ListTaskPushNotificationConfigResponseOrBuilder)responseBuilder);
        }
        catch (A2AClientException e) {
            throw e;
        }
        catch (IOException | InterruptedException e) {
            throw new A2AClientException("Failed to list push notifications: " + String.valueOf(e), (Throwable)e);
        }
    }

    public void deleteTaskPushNotificationConfigurations(DeleteTaskPushNotificationConfigParams request, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        DeleteTaskPushNotificationConfigRequest.Builder builder = DeleteTaskPushNotificationConfigRequest.newBuilder();
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("DeleteTaskPushNotificationConfig", (MessageOrBuilder)builder, this.agentCard, context);
        try {
            A2AHttpResponse response;
            String url = Utils.buildBaseUrl((AgentInterface)this.agentInterface, (String)request.tenant()) + String.format("/tasks/%1s/pushNotificationConfigs/%2s", request.id(), request.pushNotificationConfigId());
            A2AHttpClient.DeleteBuilder deleteBuilder = (A2AHttpClient.DeleteBuilder)this.httpClient.createDelete().url(url);
            if (payloadAndHeaders.getHeaders() != null) {
                for (Map.Entry entry : payloadAndHeaders.getHeaders().entrySet()) {
                    deleteBuilder.addHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (!(response = deleteBuilder.delete()).success()) {
                throw RestErrorMapper.mapRestError(response);
            }
        }
        catch (A2AClientException e) {
            throw e;
        }
        catch (IOException | InterruptedException e) {
            throw new A2AClientException("Failed to delete push notification config: " + String.valueOf(e), (Throwable)e);
        }
    }

    public void subscribeToTask(TaskIdParams request, Consumer<StreamingEventKind> eventConsumer, Consumer<Throwable> errorConsumer, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        SubscribeToTaskRequest.Builder builder = SubscribeToTaskRequest.newBuilder();
        builder.setId(request.id());
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("SubscribeToTask", (MessageOrBuilder)builder, this.agentCard, context);
        AtomicReference<CompletableFuture> ref = new AtomicReference<CompletableFuture>();
        SSEEventListener sseEventListener = new SSEEventListener(eventConsumer, errorConsumer);
        try {
            String url = Utils.buildBaseUrl((AgentInterface)this.agentInterface, (String)request.tenant()) + String.format("/tasks/%1s:subscribe", request.id());
            A2AHttpClient.PostBuilder postBuilder = this.createPostBuilder(url, payloadAndHeaders);
            ref.set(postBuilder.postAsyncSSE(msg -> sseEventListener.onMessage((String)msg, (Future)ref.get()), throwable -> sseEventListener.onError((Throwable)throwable, (Future)ref.get()), () -> {}));
        }
        catch (IOException e) {
            throw new A2AClientException("Failed to send streaming message request: " + String.valueOf(e), (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new A2AClientException("Send streaming message request timed out: " + String.valueOf(e), (Throwable)e);
        }
        catch (JsonProcessingException e) {
            throw new A2AClientException("Failed to process JSON for streaming message request: " + String.valueOf((Object)e), (Throwable)e);
        }
    }

    public AgentCard getExtendedAgentCard(@Nullable ClientCallContext context) throws A2AClientException {
        try {
            A2AHttpResponse response;
            PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("GetExtendedAgentCard", null, this.agentCard, context);
            String url = Utils.buildBaseUrl((AgentInterface)this.agentInterface, (String)"") + "/extendedAgentCard";
            A2AHttpClient.GetBuilder getBuilder = (A2AHttpClient.GetBuilder)this.httpClient.createGet().url(url);
            if (payloadAndHeaders.getHeaders() != null) {
                for (Map.Entry entry : payloadAndHeaders.getHeaders().entrySet()) {
                    getBuilder.addHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (!(response = getBuilder.get()).success()) {
                throw RestErrorMapper.mapRestError(response);
            }
            String httpResponseBody = response.body();
            return (AgentCard)JsonUtil.fromJson((String)httpResponseBody, AgentCard.class);
        }
        catch (JsonProcessingException | IOException | InterruptedException e) {
            throw new A2AClientException("Failed to get authenticated extended agent card: " + String.valueOf(e), e);
        }
        catch (A2AClientError e) {
            throw new A2AClientException("Failed to get agent card: " + String.valueOf((Object)e), (Throwable)e);
        }
    }

    public void close() {
    }

    private PayloadAndHeaders applyInterceptors(String methodName, @Nullable MessageOrBuilder payload, AgentCard agentCard, @Nullable ClientCallContext clientCallContext) {
        PayloadAndHeaders payloadAndHeaders = new PayloadAndHeaders((Object)payload, this.getHttpHeaders(clientCallContext));
        if (this.interceptors != null && !this.interceptors.isEmpty()) {
            for (ClientCallInterceptor interceptor : this.interceptors) {
                payloadAndHeaders = interceptor.intercept(methodName, payloadAndHeaders.getPayload(), payloadAndHeaders.getHeaders(), agentCard, clientCallContext);
            }
        }
        return payloadAndHeaders;
    }

    private String sendPostRequest(String url, PayloadAndHeaders payloadAndHeaders) throws IOException, InterruptedException, JsonProcessingException {
        A2AHttpClient.PostBuilder builder = this.createPostBuilder(url, payloadAndHeaders);
        A2AHttpResponse response = builder.post();
        if (!response.success()) {
            log.fine("Error on POST processing " + JsonFormat.printer().print((MessageOrBuilder)payloadAndHeaders.getPayload()));
            throw RestErrorMapper.mapRestError(response);
        }
        return response.body();
    }

    private A2AHttpClient.PostBuilder createPostBuilder(String url, PayloadAndHeaders payloadAndHeaders) throws JsonProcessingException, InvalidProtocolBufferException {
        log.fine(JsonFormat.printer().print((MessageOrBuilder)payloadAndHeaders.getPayload()));
        A2AHttpClient.PostBuilder postBuilder = ((A2AHttpClient.PostBuilder)((A2AHttpClient.PostBuilder)this.httpClient.createPost().url(url)).addHeader("Content-Type", "application/json")).body(JsonFormat.printer().print((MessageOrBuilder)payloadAndHeaders.getPayload()));
        if (payloadAndHeaders.getHeaders() != null) {
            for (Map.Entry entry : payloadAndHeaders.getHeaders().entrySet()) {
                postBuilder.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return postBuilder;
    }

    private Map<String, String> getHttpHeaders(@Nullable ClientCallContext context) {
        return context != null ? context.getHeaders() : Collections.emptyMap();
    }
}

