/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.client.transport.rest;

import com.google.gson.JsonObject;
import io.a2a.client.http.A2AHttpResponse;
import io.a2a.jsonrpc.common.json.JsonProcessingException;
import io.a2a.jsonrpc.common.json.JsonUtil;
import io.a2a.spec.A2AClientException;
import io.a2a.spec.ContentTypeNotSupportedError;
import io.a2a.spec.ExtendedAgentCardNotConfiguredError;
import io.a2a.spec.ExtensionSupportRequiredError;
import io.a2a.spec.InternalError;
import io.a2a.spec.InvalidAgentResponseError;
import io.a2a.spec.InvalidParamsError;
import io.a2a.spec.InvalidRequestError;
import io.a2a.spec.JSONParseError;
import io.a2a.spec.MethodNotFoundError;
import io.a2a.spec.PushNotificationNotSupportedError;
import io.a2a.spec.TaskNotCancelableError;
import io.a2a.spec.TaskNotFoundError;
import io.a2a.spec.UnsupportedOperationError;
import io.a2a.spec.VersionNotSupportedError;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RestErrorMapper {
    public static A2AClientException mapRestError(A2AHttpResponse response) {
        return RestErrorMapper.mapRestError(response.body(), response.status());
    }

    public static A2AClientException mapRestError(String body, int code) {
        try {
            if (body != null && !body.isBlank()) {
                JsonObject node = (JsonObject)JsonUtil.fromJson((String)body, JsonObject.class);
                String className = node.has("error") ? node.get("error").getAsString() : "";
                String errorMessage = node.has("message") ? node.get("message").getAsString() : "";
                return RestErrorMapper.mapRestError(className, errorMessage, code);
            }
            return RestErrorMapper.mapRestError("", "", code);
        }
        catch (JsonProcessingException ex) {
            Logger.getLogger(RestErrorMapper.class.getName()).log(Level.SEVERE, null, ex);
            return new A2AClientException("Failed to parse error response: " + ex.getMessage());
        }
    }

    public static A2AClientException mapRestError(String className, String errorMessage, int code) {
        return switch (className) {
            case "io.a2a.spec.TaskNotFoundError" -> new A2AClientException(errorMessage, (Throwable)new TaskNotFoundError());
            case "io.a2a.spec.ExtendedCardNotConfiguredError" -> new A2AClientException(errorMessage, (Throwable)new ExtendedAgentCardNotConfiguredError(null, errorMessage, null));
            case "io.a2a.spec.ContentTypeNotSupportedError" -> new A2AClientException(errorMessage, (Throwable)new ContentTypeNotSupportedError(null, null, (Object)errorMessage));
            case "io.a2a.spec.InternalError" -> new A2AClientException(errorMessage, (Throwable)new InternalError(errorMessage));
            case "io.a2a.spec.InvalidAgentResponseError" -> new A2AClientException(errorMessage, (Throwable)new InvalidAgentResponseError(null, null, (Object)errorMessage));
            case "io.a2a.spec.InvalidParamsError" -> new A2AClientException(errorMessage, (Throwable)new InvalidParamsError());
            case "io.a2a.spec.InvalidRequestError" -> new A2AClientException(errorMessage, (Throwable)new InvalidRequestError());
            case "io.a2a.spec.JSONParseError" -> new A2AClientException(errorMessage, (Throwable)new JSONParseError());
            case "io.a2a.spec.MethodNotFoundError" -> new A2AClientException(errorMessage, (Throwable)new MethodNotFoundError());
            case "io.a2a.spec.PushNotificationNotSupportedError" -> new A2AClientException(errorMessage, (Throwable)new PushNotificationNotSupportedError());
            case "io.a2a.spec.TaskNotCancelableError" -> new A2AClientException(errorMessage, (Throwable)new TaskNotCancelableError());
            case "io.a2a.spec.UnsupportedOperationError" -> new A2AClientException(errorMessage, (Throwable)new UnsupportedOperationError());
            case "io.a2a.spec.ExtensionSupportRequiredError" -> new A2AClientException(errorMessage, (Throwable)new ExtensionSupportRequiredError(null, errorMessage, null));
            case "io.a2a.spec.VersionNotSupportedError" -> new A2AClientException(errorMessage, (Throwable)new VersionNotSupportedError(null, errorMessage, null));
            default -> new A2AClientException(errorMessage);
        };
    }
}

