/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.client.transport.jsonrpc.sse;

import io.a2a.client.transport.spi.sse.AbstractSSEEventListener;
import io.a2a.grpc.StreamResponse;
import io.a2a.grpc.StreamResponseOrBuilder;
import io.a2a.grpc.utils.JSONRPCUtils;
import io.a2a.grpc.utils.ProtoUtils;
import io.a2a.jsonrpc.common.json.JsonProcessingException;
import io.a2a.spec.A2AError;
import io.a2a.spec.StreamingEventKind;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.jspecify.annotations.Nullable;

public class SSEEventListener
extends AbstractSSEEventListener {
    private static final Logger log = Logger.getLogger(SSEEventListener.class.getName());
    private volatile boolean completed = false;

    public SSEEventListener(Consumer<StreamingEventKind> eventHandler, @Nullable Consumer<Throwable> errorHandler) {
        super(eventHandler, errorHandler);
    }

    public void onMessage(String message, @Nullable Future<Void> completableFuture) {
        this.parseAndHandleMessage(message, completableFuture);
    }

    public void onComplete() {
        if (this.completed) {
            log.fine("SSEEventListener.onComplete() called again - ignoring (already completed)");
            return;
        }
        this.completed = true;
        log.fine("SSEEventListener.onComplete() called - signaling successful stream completion");
        if (this.getErrorHandler() != null) {
            log.fine("Calling errorHandler.accept(null) to signal successful completion");
            this.getErrorHandler().accept(null);
        } else {
            log.warning("errorHandler is null, cannot signal completion");
        }
    }

    private void parseAndHandleMessage(String message, @Nullable Future<Void> future) {
        try {
            StreamResponse response = JSONRPCUtils.parseResponseEvent((String)message);
            StreamingEventKind event = ProtoUtils.FromProto.streamingEventKind((StreamResponseOrBuilder)response);
            this.handleEvent(event, future);
        }
        catch (A2AError error) {
            if (this.getErrorHandler() != null) {
                this.getErrorHandler().accept(error);
            }
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

