/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.client.transport.grpc;

import io.a2a.spec.A2AClientException;
import io.a2a.spec.ContentTypeNotSupportedError;
import io.a2a.spec.ExtendedCardNotConfiguredError;
import io.a2a.spec.ExtensionSupportRequiredError;
import io.a2a.spec.InternalError;
import io.a2a.spec.InvalidAgentResponseError;
import io.a2a.spec.InvalidParamsError;
import io.a2a.spec.InvalidRequestError;
import io.a2a.spec.JSONParseError;
import io.a2a.spec.MethodNotFoundError;
import io.a2a.spec.PushNotificationNotSupportedError;
import io.a2a.spec.TaskNotCancelableError;
import io.a2a.spec.TaskNotFoundError;
import io.a2a.spec.UnsupportedOperationError;
import io.a2a.spec.VersionNotSupportedError;
import io.grpc.Status;

public class GrpcErrorMapper {
    public static A2AClientException mapGrpcError(Throwable e) {
        return GrpcErrorMapper.mapGrpcError(e, "gRPC error: ");
    }

    public static A2AClientException mapGrpcError(Throwable e, String errorPrefix) {
        Status status = Status.fromThrowable((Throwable)e);
        Status.Code code = status.getCode();
        String description = status.getDescription();
        if (description != null) {
            if (description.contains("TaskNotFoundError")) {
                return new A2AClientException(errorPrefix + description, (Throwable)new TaskNotFoundError());
            }
            if (description.contains("UnsupportedOperationError")) {
                return new A2AClientException(errorPrefix + description, (Throwable)new UnsupportedOperationError());
            }
            if (description.contains("InvalidParamsError")) {
                return new A2AClientException(errorPrefix + description, (Throwable)new InvalidParamsError());
            }
            if (description.contains("InvalidRequestError")) {
                return new A2AClientException(errorPrefix + description, (Throwable)new InvalidRequestError());
            }
            if (description.contains("MethodNotFoundError")) {
                return new A2AClientException(errorPrefix + description, (Throwable)new MethodNotFoundError());
            }
            if (description.contains("TaskNotCancelableError")) {
                return new A2AClientException(errorPrefix + description, (Throwable)new TaskNotCancelableError());
            }
            if (description.contains("PushNotificationNotSupportedError")) {
                return new A2AClientException(errorPrefix + description, (Throwable)new PushNotificationNotSupportedError());
            }
            if (description.contains("JSONParseError")) {
                return new A2AClientException(errorPrefix + description, (Throwable)new JSONParseError());
            }
            if (description.contains("ContentTypeNotSupportedError")) {
                return new A2AClientException(errorPrefix + description, (Throwable)new ContentTypeNotSupportedError(null, description, null));
            }
            if (description.contains("InvalidAgentResponseError")) {
                return new A2AClientException(errorPrefix + description, (Throwable)new InvalidAgentResponseError(null, description, null));
            }
            if (description.contains("ExtendedCardNotConfiguredError")) {
                return new A2AClientException(errorPrefix + description, (Throwable)new ExtendedCardNotConfiguredError(null, description, null));
            }
            if (description.contains("ExtensionSupportRequiredError")) {
                return new A2AClientException(errorPrefix + description, (Throwable)new ExtensionSupportRequiredError(null, description, null));
            }
            if (description.contains("VersionNotSupportedError")) {
                return new A2AClientException(errorPrefix + description, (Throwable)new VersionNotSupportedError(null, description, null));
            }
        }
        switch (code) {
            case NOT_FOUND: {
                return new A2AClientException(errorPrefix + (description != null ? description : e.getMessage()), (Throwable)new TaskNotFoundError());
            }
            case UNIMPLEMENTED: {
                return new A2AClientException(errorPrefix + (description != null ? description : e.getMessage()), (Throwable)new UnsupportedOperationError());
            }
            case INVALID_ARGUMENT: {
                return new A2AClientException(errorPrefix + (description != null ? description : e.getMessage()), (Throwable)new InvalidParamsError());
            }
            case INTERNAL: {
                return new A2AClientException(errorPrefix + (description != null ? description : e.getMessage()), (Throwable)new InternalError(null, e.getMessage(), null));
            }
            case UNAUTHENTICATED: {
                return new A2AClientException(errorPrefix + "Authentication failed: Client credentials are missing or invalid");
            }
            case PERMISSION_DENIED: {
                return new A2AClientException(errorPrefix + "Authorization failed: Client does not have permission for the operation");
            }
        }
        return new A2AClientException(errorPrefix + e.getMessage(), e);
    }
}

