/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.extras.pushnotificationconfigstore.database.jpa;

import io.a2a.extras.pushnotificationconfigstore.database.jpa.TaskConfigId;
import io.a2a.jsonrpc.common.json.JsonProcessingException;
import io.a2a.jsonrpc.common.json.JsonUtil;
import io.a2a.spec.PushNotificationConfig;
import jakarta.persistence.Column;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.time.Instant;

@Entity
@Table(name="a2a_push_notification_configs")
public class JpaPushNotificationConfig {
    @EmbeddedId
    private TaskConfigId id;
    @Column(name="task_data", columnDefinition="TEXT", nullable=false)
    private String configJson;
    @Column(name="created_at")
    private Instant createdAt;
    @Transient
    private PushNotificationConfig config;

    public JpaPushNotificationConfig() {
    }

    public JpaPushNotificationConfig(TaskConfigId id, String configJson) {
        this.id = id;
        this.configJson = configJson;
    }

    @PrePersist
    protected void onCreate() {
        if (this.createdAt == null) {
            this.createdAt = Instant.now();
        }
    }

    public TaskConfigId getId() {
        return this.id;
    }

    public void setId(TaskConfigId id) {
        this.id = id;
    }

    public void setConfigJson(String configJson) {
        this.configJson = configJson;
    }

    public PushNotificationConfig getConfig() throws JsonProcessingException {
        if (this.config == null) {
            this.config = (PushNotificationConfig)JsonUtil.fromJson((String)this.configJson, PushNotificationConfig.class);
        }
        return this.config;
    }

    public void setConfig(PushNotificationConfig config) throws JsonProcessingException {
        if (config.id() == null || !config.id().equals(this.id.getConfigId())) {
            throw new IllegalArgumentException("Mismatched config id. Expected '" + this.id.getConfigId() + "'. Got: '" + config.id() + "'");
        }
        this.configJson = JsonUtil.toJson((Object)config);
        this.config = config;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    static JpaPushNotificationConfig createFromConfig(String taskId, PushNotificationConfig config) throws JsonProcessingException {
        String json = JsonUtil.toJson((Object)config);
        JpaPushNotificationConfig jpaPushNotificationConfig = new JpaPushNotificationConfig(new TaskConfigId(taskId, config.id()), json);
        jpaPushNotificationConfig.config = config;
        return jpaPushNotificationConfig;
    }
}

