/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.extras.pushnotificationconfigstore.database.jpa;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.a2a.extras.pushnotificationconfigstore.database.jpa.JpaPushNotificationConfig;
import io.a2a.extras.pushnotificationconfigstore.database.jpa.TaskConfigId;
import io.a2a.server.tasks.PushNotificationConfigStore;
import io.a2a.spec.PushNotificationConfig;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Alternative;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.transaction.Transactional;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Alternative
@Priority(value=50)
public class JpaDatabasePushNotificationConfigStore
implements PushNotificationConfigStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(JpaDatabasePushNotificationConfigStore.class);
    @PersistenceContext(unitName="a2a-java")
    EntityManager em;

    @Transactional
    public PushNotificationConfig setInfo(String taskId, PushNotificationConfig notificationConfig) {
        PushNotificationConfig.Builder builder = new PushNotificationConfig.Builder(notificationConfig);
        if (notificationConfig.id() == null || notificationConfig.id().isEmpty()) {
            builder.id(taskId);
        }
        notificationConfig = builder.build();
        LOGGER.debug("Saving PushNotificationConfig for Task '{}' with ID: {}", (Object)taskId, (Object)notificationConfig.id());
        try {
            TaskConfigId configId = new TaskConfigId(taskId, notificationConfig.id());
            JpaPushNotificationConfig existingJpaConfig = (JpaPushNotificationConfig)this.em.find(JpaPushNotificationConfig.class, (Object)configId);
            if (existingJpaConfig != null) {
                existingJpaConfig.setConfig(notificationConfig);
                LOGGER.debug("Updated existing PushNotificationConfig for Task '{}' with ID: {}", (Object)taskId, (Object)notificationConfig.id());
            } else {
                JpaPushNotificationConfig jpaConfig = JpaPushNotificationConfig.createFromConfig(taskId, notificationConfig);
                this.em.persist((Object)jpaConfig);
                LOGGER.debug("Persisted new PushNotificationConfig for Task '{}' with ID: {}", (Object)taskId, (Object)notificationConfig.id());
            }
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Failed to serialize PushNotificationConfig for Task '{}' with ID: {}", new Object[]{taskId, notificationConfig.id(), e});
            throw new RuntimeException("Failed to serialize PushNotificationConfig for Task '" + taskId + "' with ID: " + notificationConfig.id(), e);
        }
        return notificationConfig;
    }

    @Transactional
    public List<PushNotificationConfig> getInfo(String taskId) {
        LOGGER.debug("Retrieving PushNotificationConfigs for Task '{}'", (Object)taskId);
        try {
            List jpaConfigs = this.em.createQuery("SELECT c FROM JpaPushNotificationConfig c WHERE c.id.taskId = :taskId", JpaPushNotificationConfig.class).setParameter("taskId", (Object)taskId).getResultList();
            List<PushNotificationConfig> configs = jpaConfigs.stream().map(jpaConfig -> {
                try {
                    return jpaConfig.getConfig();
                }
                catch (JsonProcessingException e) {
                    LOGGER.error("Failed to deserialize PushNotificationConfig for Task '{}' with ID: {}", new Object[]{taskId, jpaConfig.getId().getConfigId(), e});
                    throw new RuntimeException("Failed to deserialize PushNotificationConfig for Task '" + taskId + "' with ID: " + jpaConfig.getId().getConfigId(), e);
                }
            }).toList();
            LOGGER.debug("Successfully retrieved {} PushNotificationConfigs for Task '{}'", (Object)configs.size(), (Object)taskId);
            return configs;
        }
        catch (Exception e) {
            LOGGER.error("Failed to retrieve PushNotificationConfigs for Task '{}'", (Object)taskId, (Object)e);
            throw e;
        }
    }

    @Transactional
    public void deleteInfo(String taskId, String configId) {
        if (configId == null) {
            configId = taskId;
        }
        LOGGER.debug("Deleting PushNotificationConfig for Task '{}' with Config ID: {}", (Object)taskId, (Object)configId);
        JpaPushNotificationConfig jpaConfig = (JpaPushNotificationConfig)this.em.find(JpaPushNotificationConfig.class, (Object)new TaskConfigId(taskId, configId));
        if (jpaConfig != null) {
            this.em.remove((Object)jpaConfig);
            LOGGER.debug("Successfully deleted PushNotificationConfig for Task '{}' with Config ID: {}", (Object)taskId, (Object)configId);
        } else {
            LOGGER.debug("PushNotificationConfig not found for deletion with Task '{}' and Config ID: {}", (Object)taskId, (Object)configId);
        }
    }
}

