/*
 * Decompiled with CFR 0.152.
 */
package org.tron.trident.core.contract;

import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.util.encoders.Hex;
import org.tron.trident.abi.TypeEncoder;
import org.tron.trident.abi.datatypes.Type;
import org.tron.trident.core.exceptions.ContractCreateException;
import org.tron.trident.proto.Common;

public class ContractConstructor {
    private Common.SmartContract.ABI.Entry rawConstructor;
    private List<String> paramTypes;
    private boolean payable;
    private ByteString bytecode = null;

    public ContractConstructor(Common.SmartContract.ABI.Entry raw2) {
        this.rawConstructor = raw2;
        this.paramTypes = new ArrayList<String>();
        for (Common.SmartContract.ABI.Entry.Param p : raw2.getInputsList()) {
            this.paramTypes.add(p.getType());
        }
        this.payable = raw2.getPayable();
    }

    public Common.SmartContract.ABI.Entry getRawConstructor() {
        return this.rawConstructor;
    }

    public List<String> getParamTypes() {
        return this.paramTypes;
    }

    public boolean getPayable() {
        return this.payable;
    }

    public ByteString getBytecode() {
        return this.bytecode;
    }

    public void encodeParameter(List<Type<?>> params) throws ContractCreateException {
        if (params.size() != this.paramTypes.size()) {
            throw new ContractCreateException("Parameter amount doesn't match.");
        }
        StringBuilder builder = new StringBuilder();
        for (Type<?> p : params) {
            builder.append(TypeEncoder.encode(p));
        }
        this.bytecode = ByteString.copyFrom((byte[])Hex.decode((String)builder.toString()));
    }
}

