/*
 * Decompiled with CFR 0.152.
 */
package org.mx.time;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemClock {
    private final Logger logger = LoggerFactory.getLogger(SystemClock.class);
    private ScheduledExecutorService scheduler = null;
    private final long precision;
    private final AtomicLong now;

    public SystemClock() {
        this(1L);
    }

    public SystemClock(long precision) {
        this.precision = precision;
        this.now = new AtomicLong(System.currentTimeMillis());
    }

    public void init() {
        this.scheduler = Executors.newSingleThreadScheduledExecutor(runnable -> {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            return thread;
        });
        this.scheduler.scheduleAtFixedRate(() -> this.now.set(System.currentTimeMillis()), this.precision, this.precision, TimeUnit.MILLISECONDS);
        if (this.logger.isInfoEnabled()) {
            this.logger.info(String.format("Initialize the SystemClock success, precision: %d ms.", this.precision));
        }
    }

    public void close() {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
            this.scheduler = null;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Close the SystemClock thread success.");
            }
        }
    }

    public long now() {
        return this.now.get();
    }
}

