/*
 * Decompiled with CFR 0.152.
 */
package org.mx;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mx.StringUtils;
import org.mx.error.UserInterfaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeUtils {
    public static final long KB = 1024L;
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;
    public static final long TB = 0x10000000000L;
    public static final long PB = 0x4000000000000L;
    public static final long SEC = 1000L;
    public static final long MIN = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    public static final long WEEK = 604800000L;
    public static final long MON = 2592000000L;
    public static final long QUAR = 7776000000L;
    public static final long YEAR = 31104000000L;
    private static final Logger logger = LoggerFactory.getLogger(TypeUtils.class);
    private static final String regex = ",(?=([^\"^']*\"[^\"^']*\")*[^\"^']*$)";
    private static final Pattern SPACE_PATTERN = Pattern.compile("([0-9]+([.,][0-9]+)?)\\s*(|K|M|G|T|P)B?", 2);
    private static final Pattern TIME_PERIOD_PATTERN = Pattern.compile("^\\s*([0-9]+(.[0-9]+)?)\\s*([A-Za-z]*)$", 2);

    private TypeUtils() {
    }

    public static <T> T map2Object(Map<String, Object> input, Class<T> clazz) {
        if (input == null || input.isEmpty()) {
            return null;
        }
        return (T)JSON.parseObject((String)new JSONObject(input).toJSONString(), clazz);
    }

    public static int byteArray2Int(byte[] bytes) {
        if (bytes == null) {
            return 0;
        }
        int i = 0;
        for (int index = 0; index < Math.min(bytes.length, 4); ++index) {
            i <<= 8;
            i |= bytes[index] & 0xFF;
        }
        return i;
    }

    public static long byteArray2Long(byte[] bytes) {
        if (bytes == null) {
            return 0L;
        }
        long l = 0L;
        for (int index = 0; index < Math.min(bytes.length, 8); ++index) {
            l <<= 8;
            l |= (long)(bytes[index] & 0xFF);
        }
        return l;
    }

    public static byte[] int2ByteArray(int i) {
        byte[] bytes = new byte[4];
        for (int index = 0; index < 4; ++index) {
            bytes[index] = (byte)(i >> 32 - (index + 1) * 8 & 0xFF);
        }
        return bytes;
    }

    public static byte[] bigint2ByteArray(BigInteger n) {
        byte[] out = null;
        if (n == null) {
            return null;
        }
        if (n.toByteArray().length == 33) {
            out = new byte[32];
            System.arraycopy(n.toByteArray(), 1, out, 0, 32);
        } else if (n.toByteArray().length == 32) {
            out = n.toByteArray();
        } else {
            out = new byte[32];
            for (int i = 0; i < 32 - n.toByteArray().length; ++i) {
                out[i] = 0;
            }
            System.arraycopy(n.toByteArray(), 0, out, 32 - n.toByteArray().length, n.toByteArray().length);
        }
        return out;
    }

    public static byte[] long2ByteArray(long l) {
        byte[] bytes = new byte[8];
        for (int index = 0; index < 8; ++index) {
            bytes[index] = (byte)(l >> 64 - (index + 1) * 8 & 0xFFL);
        }
        return bytes;
    }

    public static String byteArray2Ipv4(byte[] bytes) {
        if (bytes == null || bytes.length <= 0) {
            return "NA";
        }
        StringBuilder sb = new StringBuilder(String.valueOf(TypeUtils.byte2IpInt(bytes[0])));
        for (int index = 1; index < bytes.length; ++index) {
            sb.append(".");
            sb.append(TypeUtils.byte2IpInt(bytes[index]));
        }
        return sb.toString();
    }

    public static String byteArray2Ipv6(byte[] bytes) {
        if (bytes == null || bytes.length != 16) {
            return "NA";
        }
        BigInteger big = new BigInteger(bytes);
        BigInteger ff = BigInteger.valueOf(65535L);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 8; ++i) {
            sb.insert(0, ":");
            sb.insert(0, big.and(ff).toString(16));
            big = big.shiftRight(16);
        }
        String str = sb.substring(0, sb.length() - 1);
        return str.replaceFirst("(^|:)(0+(:|$)){2,8}", "::");
    }

    public static String byteArray2Ip(byte[] bytes) {
        if (bytes == null || bytes.length <= 0) {
            return "NA";
        }
        if (bytes.length > 4) {
            return TypeUtils.byteArray2Ipv6(bytes);
        }
        return TypeUtils.byteArray2Ipv4(bytes);
    }

    private static int byte2IpInt(byte b) {
        return b >= 0 ? b : b + 256;
    }

    public static List<String> csv2List(String line) {
        ArrayList<String> list = new ArrayList<String>();
        if (!StringUtils.isBlank(line)) {
            String[] segs = line.split(regex, -1);
            list.addAll(Arrays.asList(segs));
        }
        return list;
    }

    public static byte[] Ip2byteArrayV4(String ipv4) {
        if (StringUtils.isBlank(ipv4)) {
            return new byte[0];
        }
        String[] splits = ipv4.split("\\.");
        int len = Math.min(splits.length, 4);
        byte[] values = new byte[len];
        for (int index = 0; index < len; ++index) {
            values[index] = Integer.valueOf(splits[index], 10).byteValue();
        }
        return values;
    }

    private static BigInteger ipv6toInt(String ipv6) {
        int compressIndex = ipv6.indexOf("::");
        if (compressIndex != -1) {
            char[] ch;
            String part1s = ipv6.substring(0, compressIndex);
            String part2s = ipv6.substring(compressIndex + 1);
            BigInteger part1 = TypeUtils.ipv6toInt(part1s);
            BigInteger part2 = TypeUtils.ipv6toInt(part2s);
            int part1hasDot = 0;
            for (char c : ch = part1s.toCharArray()) {
                if (c != ':') continue;
                ++part1hasDot;
            }
            return part1.shiftLeft(16 * (7 - part1hasDot)).add(part2);
        }
        String[] str = ipv6.split(":");
        BigInteger big = BigInteger.ZERO;
        for (int i = 0; i < str.length; ++i) {
            if (str[i].isEmpty()) {
                str[i] = "0";
            }
            big = big.add(BigInteger.valueOf(Long.valueOf(str[i], 16)).shiftLeft(16 * (str.length - i - 1)));
        }
        return big;
    }

    public static byte[] Ip2byteArrayV6(String ipv6) {
        if (StringUtils.isBlank(ipv6)) {
            return new byte[0];
        }
        byte[] values = TypeUtils.ipv6toInt(ipv6).toByteArray();
        byte[] tar = new byte[16];
        if (values.length > 16) {
            System.arraycopy(values, values.length - 16, tar, 0, 16);
            return tar;
        }
        if (values.length < 16) {
            System.arraycopy(values, 0, tar, 16 - values.length, values.length);
            return tar;
        }
        return values;
    }

    public static byte[] Ip2byteArray(String ip) {
        if (StringUtils.isBlank(ip)) {
            return new byte[0];
        }
        if (ip.contains(":")) {
            return TypeUtils.Ip2byteArrayV6(ip);
        }
        return TypeUtils.Ip2byteArrayV4(ip);
    }

    public static String byteArray2HexString(byte[] byteArray) {
        if (byteArray == null || byteArray.length <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (byte b : byteArray) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString().toUpperCase();
    }

    public static String intArray2HexString(int[] intArray) {
        if (intArray == null || intArray.length <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i : intArray) {
            sb.append(String.format("%04x", i));
        }
        return sb.toString().toUpperCase();
    }

    public static String longArray2HexString(int[] longArray) {
        if (longArray == null || longArray.length <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int l : longArray) {
            sb.append(String.format("%08x", l));
        }
        return sb.toString().toUpperCase();
    }

    public static String byteArray2Base64(byte[] value) {
        return Base64.getEncoder().encodeToString(value);
    }

    public static byte[] base642ByteArray(String base64Str) {
        return Base64.getDecoder().decode(base64Str);
    }

    public static String byte2HexString(byte b) {
        String hex = Integer.toHexString(b);
        int length = hex.length();
        switch (length) {
            case 0: {
                return "00";
            }
            case 1: {
                return String.format("0%s", hex);
            }
            case 2: {
                return hex;
            }
        }
        return hex.substring(length - 2);
    }

    public static byte char2Byte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static byte[] hexString2ByteArray(String input) throws NumberFormatException {
        if (StringUtils.isBlank(input)) {
            return null;
        }
        input = input.toUpperCase();
        int length = input.length() / 2;
        char[] hexChars = input.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(TypeUtils.char2Byte(hexChars[pos]) << 4 | TypeUtils.char2Byte(hexChars[pos + 1]));
        }
        return d;
    }

    public static boolean string2Boolean(String str, boolean defaultValue) {
        if ("true".equalsIgnoreCase(str)) {
            return true;
        }
        if ("false".equalsIgnoreCase(str)) {
            return false;
        }
        return defaultValue;
    }

    public static int string2Int(String str, Radix radix, int defaultValue) {
        block4: {
            try {
                if (!StringUtils.isBlank(str)) {
                    String check = str.toLowerCase();
                    if (check.startsWith("0b") || check.startsWith("08") && radix == Radix.Octonary || check.startsWith("0x")) {
                        str = str.substring(2);
                    }
                    return Integer.parseInt(str, radix.getRadix());
                }
            }
            catch (NumberFormatException ex) {
                if (!logger.isWarnEnabled()) break block4;
                logger.warn(String.format("Parse %s to int fail, radix: %s, default: %d.", str, radix.name(), defaultValue));
            }
        }
        return defaultValue;
    }

    public static long string2Long(String str, Radix radix, long defaultValue) {
        block4: {
            try {
                if (!StringUtils.isBlank(str)) {
                    String check = str.toLowerCase();
                    if (check.startsWith("0b") || check.startsWith("08") && radix == Radix.Octonary || check.startsWith("0x")) {
                        str = str.substring(2);
                    }
                    return Long.parseLong(str, radix.getRadix());
                }
            }
            catch (NumberFormatException ex) {
                if (!logger.isWarnEnabled()) break block4;
                logger.warn(String.format("Parse %s to long fail, radix: %s, default: %d.", str, radix.name(), defaultValue));
            }
        }
        return defaultValue;
    }

    public static float string2Float(String str, float defaultValue) {
        block3: {
            try {
                if (!StringUtils.isBlank(str)) {
                    return Float.parseFloat(str);
                }
            }
            catch (NumberFormatException ex) {
                if (!logger.isWarnEnabled()) break block3;
                logger.warn(String.format("Parse %s to float fail, default: %f.", str, Float.valueOf(defaultValue)));
            }
        }
        return defaultValue;
    }

    public static double string2Double(String str, double defaultValue) {
        block3: {
            try {
                if (!StringUtils.isBlank(str)) {
                    return Double.parseDouble(str);
                }
            }
            catch (NumberFormatException ex) {
                if (!logger.isWarnEnabled()) break block3;
                logger.warn(String.format("Parse %s to double fail, default: %f.", str, defaultValue));
            }
        }
        return defaultValue;
    }

    public static long string2Size(String size, long defaultValue) {
        block10: {
            if (StringUtils.isBlank(size)) {
                return defaultValue;
            }
            Matcher matcher = SPACE_PATTERN.matcher(size);
            if (matcher.matches()) {
                try {
                    double value = NumberFormat.getNumberInstance(Locale.getDefault()).parse(matcher.group(1)).doubleValue();
                    String units = matcher.group(3);
                    if (units.isEmpty()) {
                        return (long)value;
                    }
                    if (units.equalsIgnoreCase("K")) {
                        return (long)(value * 1024.0);
                    }
                    if (units.equalsIgnoreCase("M")) {
                        return (long)(value * 1048576.0);
                    }
                    if (units.equalsIgnoreCase("G")) {
                        return (long)(value * 1.073741824E9);
                    }
                    if (units.equalsIgnoreCase("T")) {
                        return (long)(value * 1.099511627776E12);
                    }
                    if (units.equalsIgnoreCase("P")) {
                        return (long)(value * 1.125899906842624E15);
                    }
                }
                catch (ParseException e) {
                    if (!logger.isWarnEnabled()) break block10;
                    logger.warn(String.format("Parse %s to int fail, default: %d.", size, defaultValue));
                }
            }
        }
        return defaultValue;
    }

    public static long string2TimePeriod(String timePeriod, long defaultValue) {
        if (StringUtils.isBlank(timePeriod)) {
            return defaultValue;
        }
        Matcher matcher = TIME_PERIOD_PATTERN.matcher(timePeriod);
        if (matcher.matches()) {
            try {
                double value = NumberFormat.getNumberInstance(Locale.getDefault()).parse(matcher.group(1)).doubleValue();
                String units = matcher.group(3);
                if (StringUtils.isBlank(units)) {
                    return (long)value;
                }
                switch (units.toLowerCase()) {
                    case "sec": 
                    case "s": {
                        return (long)(value * 1000.0);
                    }
                    case "min": 
                    case "m": {
                        return (long)(value * 60000.0);
                    }
                    case "hour": 
                    case "h": {
                        return (long)(value * 3600000.0);
                    }
                    case "day": 
                    case "d": {
                        return (long)(value * 8.64E7);
                    }
                    case "week": 
                    case "w": {
                        return (long)(value * 6.048E8);
                    }
                    case "mon": {
                        return (long)(value * 2.592E9);
                    }
                    case "quar": {
                        return (long)(value * 7.776E9);
                    }
                    case "year": {
                        return (long)(value * 3.1104E10);
                    }
                }
                throw new UserInterfaceException(-1, "\u4e0d\u652f\u6301\u7684\u65f6\u95f4\u5355\u4f4d\u683c\u5f0f\uff0c\u8bf7\u68c0\u67e5\u3002");
            }
            catch (ParseException e) {
                if (logger.isWarnEnabled()) {
                    logger.warn(String.format("Parse %s to time period fail, default: %d.", timePeriod, defaultValue));
                }
                throw new UserInterfaceException(-1, "\u89e3\u6790\u65f6\u95f4\u683c\u5f0f\u6570\u636e\u5931\u8d25\u3002");
            }
        }
        return defaultValue;
    }

    public static <T> boolean equals(T t1, T t2) {
        if (t1 == null && t2 == null) {
            return true;
        }
        if (t1 != null && t2 != null) {
            return t1.toString().equals(t2.toString());
        }
        return false;
    }

    public static <T> boolean maybeUpdate(T tar, T src) {
        return !TypeUtils.equals(tar, src) && src != null;
    }

    public static enum Radix {
        Binary(2),
        Octonary(8),
        Decimal(10),
        Hexadecimal(16);

        int radix;

        private Radix(int radix) {
            this.radix = radix;
        }

        int getRadix() {
            return this.radix;
        }
    }
}

