/*
 * Decompiled with CFR 0.152.
 */
package org.mx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.mx.TypeUtils;

public class StringUtils {
    public static final char DEFAULT_SEPARATOR = ',';
    public static final String DELIMITERS = ",; \t\n";

    private StringUtils() {
    }

    public static String byte2Base64String(byte[] value) {
        return TypeUtils.byteArray2Base64(value);
    }

    public static byte[] Base64String2Byte(String base64Str) {
        return TypeUtils.base642ByteArray(base64Str);
    }

    public static byte[] hexString2Byte(String input) throws NumberFormatException {
        return TypeUtils.hexString2ByteArray(input);
    }

    public static String byte2HexString(byte[] bs) {
        return TypeUtils.byteArray2HexString(bs);
    }

    public static boolean isBlank(String str) {
        if (str == null) {
            return true;
        }
        if ((str = str.trim()).length() <= 0) {
            return true;
        }
        return "null".equalsIgnoreCase(str) || "undefined".equalsIgnoreCase(str);
    }

    public static boolean isChinese(String str) {
        boolean flg = false;
        if (!StringUtils.isBlank(str)) {
            char[] ch;
            for (char c : ch = str.toCharArray()) {
                if (!StringUtils.isChinese(c)) continue;
                flg = true;
                break;
            }
        }
        return flg;
    }

    public static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A;
    }

    public static boolean isXML(String text) {
        if (StringUtils.isBlank(text)) {
            return false;
        }
        String content = text.trim();
        return content.startsWith("<") && content.endsWith(">");
    }

    public static boolean isJSON(String text) {
        if (StringUtils.isBlank(text)) {
            return false;
        }
        String content = text.trim();
        return content.startsWith("{") && content.endsWith("}") || content.startsWith("[") && content.endsWith("]");
    }

    public static boolean leftEquals(String src, String target, boolean ignoreCase) {
        if (src != null && target != null) {
            int size = Math.min(src.length(), target.length());
            if (ignoreCase) {
                return src.substring(0, size).equalsIgnoreCase(target);
            }
            return src.substring(0, size).equals(target);
        }
        return src == null && target == null;
    }

    public static boolean leftEquals(String src, String[] targets, boolean ignoreCase) {
        if (src == null && targets == null) {
            return true;
        }
        if (targets != null && targets.length > 0) {
            boolean equals = false;
            for (int index = 0; index < targets.length && !equals; ++index) {
                equals = StringUtils.leftEquals(src, targets[index], ignoreCase);
            }
            return equals;
        }
        return false;
    }

    public static String merge(Collection<?> coll) {
        return StringUtils.merge(coll, ',');
    }

    public static String merge(Collection<?> coll, char separate) {
        return StringUtils.merge(coll, String.valueOf(separate));
    }

    public static String merge(Collection<?> coll, String separate) {
        StringBuilder sb = new StringBuilder();
        for (Object obj : coll) {
            sb.append(obj.toString());
            sb.append(separate);
        }
        return sb.length() >= separate.length() ? sb.substring(0, sb.length() - separate.length()) : sb.toString();
    }

    public static String merge(Object[] str) {
        return StringUtils.merge(str, ',');
    }

    public static String merge(Object[] str, char separate) {
        return StringUtils.merge(str, String.valueOf(separate));
    }

    public static String merge(Object[] str, String separate) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length; ++i) {
            sb.append(str[i].toString());
            if (i >= str.length - 1) continue;
            sb.append(separate);
        }
        return sb.toString();
    }

    public static String merge(Object str, int length) {
        return StringUtils.merge(str, length, ',');
    }

    public static String merge(Object str, int length, String separate) {
        return StringUtils.merge(str, length, StringUtils.isBlank(separate) ? (char)',' : separate.charAt(0));
    }

    public static String merge(Object str, int length, char separate) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append(str.toString());
            if (i >= length - 1) continue;
            sb.append(separate);
        }
        return sb.toString();
    }

    public static String repeat(int length, String str) {
        if (length <= 0) {
            return "";
        }
        if (StringUtils.isBlank(str)) {
            str = " ";
        }
        StringBuilder sb = new StringBuilder(length + str.length());
        for (int index = 0; index < length / str.length() + 1; ++index) {
            sb.append(str);
        }
        return sb.substring(0, length);
    }

    public static String[] split(String s) {
        return StringUtils.split(s, DELIMITERS, true, true);
    }

    public static String[] split(String s, boolean trimTokens, boolean ignoreEmptyTokens) {
        return StringUtils.split(s, DELIMITERS, trimTokens, ignoreEmptyTokens);
    }

    public static String[] split(String s, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        if (s == null) {
            s = "";
        }
        StringTokenizer st = new StringTokenizer(s, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (ignoreEmptyTokens && token.length() == 0) continue;
            tokens.add(token);
        }
        return tokens.toArray(new String[0]);
    }

    public static String truncate(String src, int length) {
        if (src == null || src.length() <= length) {
            return src;
        }
        return String.format("%s...", src.substring(0, length));
    }

    public static String xmlEscape(String str) {
        if (str == null || str.length() <= 0) {
            return "";
        }
        int i = str.indexOf(10);
        while (i >= 0) {
            str = str.substring(0, i) + "<br>" + str.substring(i + 1);
            i = str.indexOf(10);
        }
        return str.replaceAll("&", "&amp;").replaceAll(">", "&gt;").replaceAll("<", "&lt;").replaceAll("'", "&apos;").replaceAll("\"", "&quot;");
    }

    public static String xmlUnescape(String str) {
        if (str == null || str.length() <= 0) {
            return "";
        }
        str = str.replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&amp;", "&").replaceAll("&apos;", "'").replaceAll("&quot;", "\"");
        int i = str.indexOf("<br>");
        while (i >= 0) {
            str = str.substring(0, i) + "\n" + str.substring(i + 5);
            i = str.indexOf("<br>");
        }
        return str;
    }
}

