/*
 * Decompiled with CFR 0.152.
 */
package org.mx;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import org.mx.DateUtils;
import org.mx.DigestUtils;
import org.mx.StringUtils;
import org.mx.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileUtils.class);

    private FileUtils() {
    }

    public static String adjustPath(String path) {
        String adjust = SystemUtils.getType() == SystemUtils.SystemType.Windows ? path.replace('/', '\\') : path.replace('\\', '/');
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Adjust the path: %s -> %s.", path, adjust));
        }
        return adjust;
    }

    public static String getType(String name) {
        return name.substring(name.lastIndexOf(".") + 1);
    }

    public static void deleteFile(String filePath) throws IOException {
        FileUtils.deleteFile(Paths.get(filePath, new String[0]));
    }

    public static void deleteFile(Path file) throws IOException {
        if (file == null || !Files.exists(file, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(file, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException ex) throws IOException {
                if (ex == null) {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
                if (logger.isErrorEnabled()) {
                    logger.error(String.format("Visit directory fail, path: %s.", dir.getFileName().toString()), (Throwable)ex);
                }
                throw ex;
            }
        });
    }

    public static void deleteFile(File file) {
        if (file == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("The file object is null.");
            }
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null) {
                if (logger.isWarnEnabled()) {
                    logger.warn(String.format("There has not any children in the path: %s.", file.getAbsolutePath()));
                }
                return;
            }
            if (files.length > 0) {
                for (File child : files) {
                    FileUtils.deleteFile(child);
                    if (!file.delete() || !logger.isDebugEnabled()) continue;
                    logger.debug(String.format("Delete path successfully, path: %s.", file.getAbsolutePath()));
                }
            } else if (file.delete() && logger.isDebugEnabled()) {
                logger.debug(String.format("Delete path successfully, path: %s.", file.getAbsolutePath()));
            }
        } else if (file.delete() && logger.isDebugEnabled()) {
            logger.debug(String.format("Delete path successfully, path: %s.", file.getAbsolutePath()));
        }
    }

    public static void moveFile(String src, String target) throws IOException {
        Path path = Paths.get(target, new String[0]);
        Path parent = path.getParent();
        if (!Files.exists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        Files.move(Paths.get(src, new String[0]), Paths.get(target, new String[0]), StandardCopyOption.REPLACE_EXISTING);
    }

    public static String saveFile(String filePath, InputStream is) throws IOException {
        String date = DateUtils.get8TimeNow();
        String fileName = DigestUtils.uuid().replaceAll("-", "");
        Path path = Paths.get(filePath, date, fileName);
        Path parent = path.getParent();
        if (!Files.exists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        Files.copy(is, path, StandardCopyOption.REPLACE_EXISTING);
        return path.toFile().getAbsolutePath();
    }

    public static String saveFile(String filePath, String fileName, InputStream is) throws IOException {
        Path path = Paths.get(filePath, fileName);
        Path parent = path.getParent();
        if (!Files.exists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        Files.copy(is, path, StandardCopyOption.REPLACE_EXISTING);
        return path.toFile().getAbsolutePath();
    }

    public static void copyFile(String source, String target) throws IOException {
        if (StringUtils.isBlank(source) || StringUtils.isBlank(target) || source.equals(target)) {
            throw new IllegalArgumentException(String.format("source: %s, target: %s. ", source, target));
        }
        Path path = Paths.get(target, new String[0]);
        Path parent = path.getParent();
        if (parent != null && !Files.exists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        FileUtils.copyFile(Paths.get(source, new String[0]), path);
    }

    public static void copyFile(final Path source, final Path target) throws IOException {
        Files.walkFileTree(source, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                block2: {
                    Path targetdir = target.resolve(source.relativize(dir));
                    try {
                        Files.copy(dir, targetdir, new CopyOption[0]);
                    }
                    catch (FileAlreadyExistsException ex) {
                        if (Files.isDirectory(targetdir, new LinkOption[0])) break block2;
                        throw ex;
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.copy(file, target.resolve(source.relativize(file)), new CopyOption[0]);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

