/*
 * Decompiled with CFR 0.152.
 */
package io.getunleash;

import io.getunleash.EvaluatedToggle;
import io.getunleash.FeatureToggle;
import io.getunleash.MoreOperations;
import io.getunleash.Unleash;
import io.getunleash.UnleashContext;
import io.getunleash.UnleashContextProvider;
import io.getunleash.Variant;
import io.getunleash.event.EventDispatcher;
import io.getunleash.event.ToggleEvaluated;
import io.getunleash.lang.Nullable;
import io.getunleash.metric.UnleashMetricService;
import io.getunleash.metric.UnleashMetricServiceImpl;
import io.getunleash.repository.FeatureToggleRepository;
import io.getunleash.repository.HttpToggleFetcher;
import io.getunleash.repository.ToggleBackupHandlerFile;
import io.getunleash.repository.ToggleRepository;
import io.getunleash.strategy.ApplicationHostnameStrategy;
import io.getunleash.strategy.DefaultStrategy;
import io.getunleash.strategy.FlexibleRolloutStrategy;
import io.getunleash.strategy.GradualRolloutRandomStrategy;
import io.getunleash.strategy.GradualRolloutSessionIdStrategy;
import io.getunleash.strategy.GradualRolloutUserIdStrategy;
import io.getunleash.strategy.RemoteAddressStrategy;
import io.getunleash.strategy.Strategy;
import io.getunleash.strategy.UnknownStrategy;
import io.getunleash.strategy.UserWithIdStrategy;
import io.getunleash.util.UnleashConfig;
import io.getunleash.variant.VariantUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUnleash
implements Unleash {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultUnleash.class);
    private static final List<Strategy> BUILTIN_STRATEGIES = Arrays.asList(new DefaultStrategy(), new ApplicationHostnameStrategy(), new GradualRolloutRandomStrategy(), new GradualRolloutSessionIdStrategy(), new GradualRolloutUserIdStrategy(), new RemoteAddressStrategy(), new UserWithIdStrategy(), new FlexibleRolloutStrategy());
    public static final UnknownStrategy UNKNOWN_STRATEGY = new UnknownStrategy();
    private final UnleashMetricService metricService;
    private final ToggleRepository toggleRepository;
    private final Map<String, Strategy> strategyMap;
    private final UnleashContextProvider contextProvider;
    private final EventDispatcher eventDispatcher;
    private final UnleashConfig config;

    private static FeatureToggleRepository defaultToggleRepository(UnleashConfig unleashConfig) {
        return new FeatureToggleRepository(unleashConfig, new HttpToggleFetcher(unleashConfig), new ToggleBackupHandlerFile(unleashConfig));
    }

    public DefaultUnleash(UnleashConfig unleashConfig, Strategy ... strategies) {
        this(unleashConfig, (ToggleRepository)DefaultUnleash.defaultToggleRepository(unleashConfig), strategies);
    }

    public DefaultUnleash(UnleashConfig unleashConfig, ToggleRepository toggleRepository, Strategy ... strategies) {
        this(unleashConfig, toggleRepository, DefaultUnleash.buildStrategyMap(strategies), unleashConfig.getContextProvider(), new EventDispatcher(unleashConfig), new UnleashMetricServiceImpl(unleashConfig, unleashConfig.getScheduledExecutor()));
    }

    public DefaultUnleash(UnleashConfig unleashConfig, ToggleRepository toggleRepository, Map<String, Strategy> strategyMap, UnleashContextProvider contextProvider, EventDispatcher eventDispatcher, UnleashMetricService metricService) {
        this.config = unleashConfig;
        this.toggleRepository = toggleRepository;
        this.strategyMap = strategyMap;
        this.contextProvider = contextProvider;
        this.eventDispatcher = eventDispatcher;
        this.metricService = metricService;
        metricService.register(strategyMap.keySet());
    }

    @Override
    public boolean isEnabled(String toggleName) {
        return this.isEnabled(toggleName, false);
    }

    @Override
    public boolean isEnabled(String toggleName, boolean defaultSetting) {
        return this.isEnabled(toggleName, this.contextProvider.getContext(), defaultSetting);
    }

    @Override
    public boolean isEnabled(String toggleName, UnleashContext context, boolean defaultSetting) {
        return this.isEnabled(toggleName, context, (n, c) -> defaultSetting);
    }

    @Override
    public boolean isEnabled(String toggleName, BiFunction<String, UnleashContext, Boolean> fallbackAction) {
        return this.isEnabled(toggleName, this.contextProvider.getContext(), fallbackAction);
    }

    @Override
    public boolean isEnabled(String toggleName, UnleashContext context, BiFunction<String, UnleashContext, Boolean> fallbackAction) {
        boolean enabled = this.checkEnabled(toggleName, context, fallbackAction);
        this.count(toggleName, enabled);
        this.eventDispatcher.dispatch(new ToggleEvaluated(toggleName, enabled));
        return enabled;
    }

    private boolean checkEnabled(String toggleName, UnleashContext context, BiFunction<String, UnleashContext, Boolean> fallbackAction) {
        boolean enabled;
        this.checkIfToggleMatchesNamePrefix(toggleName);
        FeatureToggle featureToggle = this.toggleRepository.getToggle(toggleName);
        UnleashContext enhancedContext = context.applyStaticFields(this.config);
        if (featureToggle == null) {
            enabled = fallbackAction.apply(toggleName, enhancedContext);
        } else if (!featureToggle.isEnabled()) {
            enabled = false;
        } else {
            if (featureToggle.getStrategies().size() == 0) {
                return true;
            }
            enabled = featureToggle.getStrategies().stream().anyMatch(strategy -> {
                Strategy configuredStrategy = this.getStrategy(strategy.getName());
                if (configuredStrategy == UNKNOWN_STRATEGY) {
                    LOGGER.warn("Unable to find matching strategy for toggle:{} strategy:{}", (Object)toggleName, (Object)strategy.getName());
                }
                return configuredStrategy.isEnabled(strategy.getParameters(), enhancedContext, strategy.getConstraints());
            });
        }
        return enabled;
    }

    private void checkIfToggleMatchesNamePrefix(String toggleName) {
        if (this.config.getNamePrefix() != null && !toggleName.startsWith(this.config.getNamePrefix())) {
            LOGGER.warn("Toggle [{}] doesnt start with configured name prefix of [{}] so it will always be disabled", (Object)toggleName, (Object)this.config.getNamePrefix());
        }
    }

    @Override
    public Variant getVariant(String toggleName, UnleashContext context) {
        return this.getVariant(toggleName, context, Variant.DISABLED_VARIANT);
    }

    @Override
    public Variant getVariant(String toggleName, UnleashContext context, Variant defaultValue) {
        FeatureToggle featureToggle = this.toggleRepository.getToggle(toggleName);
        boolean enabled = this.checkEnabled(toggleName, context, (n, c) -> false);
        Variant variant = enabled ? VariantUtil.selectVariant(featureToggle, context, defaultValue) : defaultValue;
        this.metricService.countVariant(toggleName, variant.getName());
        return variant;
    }

    @Override
    public Variant getVariant(String toggleName) {
        return this.getVariant(toggleName, this.contextProvider.getContext());
    }

    @Override
    public Variant getVariant(String toggleName, Variant defaultValue) {
        return this.getVariant(toggleName, this.contextProvider.getContext(), defaultValue);
    }

    public Optional<FeatureToggle> getFeatureToggleDefinition(String toggleName) {
        return Optional.ofNullable(this.toggleRepository.getToggle(toggleName));
    }

    @Override
    @Deprecated
    public List<String> getFeatureToggleNames() {
        return this.toggleRepository.getFeatureNames();
    }

    @Deprecated
    public void count(String toggleName, boolean enabled) {
        this.metricService.count(toggleName, enabled);
    }

    private static Map<String, Strategy> buildStrategyMap(@Nullable Strategy[] strategies) {
        HashMap<String, Strategy> map = new HashMap<String, Strategy>();
        BUILTIN_STRATEGIES.forEach(strategy -> map.put(strategy.getName(), (Strategy)strategy));
        if (strategies != null) {
            for (Strategy strategy2 : strategies) {
                map.put(strategy2.getName(), strategy2);
            }
        }
        return map;
    }

    private Strategy getStrategy(String strategy) {
        return this.strategyMap.getOrDefault(strategy, this.config.getFallbackStrategy());
    }

    @Override
    public void shutdown() {
        this.config.getScheduledExecutor().shutdown();
    }

    @Override
    public MoreOperations more() {
        return new DefaultMore();
    }

    public class DefaultMore
    implements MoreOperations {
        @Override
        public List<String> getFeatureToggleNames() {
            return DefaultUnleash.this.toggleRepository.getFeatureNames();
        }

        @Override
        public List<EvaluatedToggle> evaluateAllToggles() {
            return this.evaluateAllToggles(DefaultUnleash.this.contextProvider.getContext());
        }

        @Override
        public List<EvaluatedToggle> evaluateAllToggles(UnleashContext context) {
            return this.getFeatureToggleNames().stream().map(toggleName -> {
                boolean enabled = DefaultUnleash.this.checkEnabled(toggleName, context, (n, c) -> false);
                FeatureToggle featureToggle = DefaultUnleash.this.toggleRepository.getToggle((String)toggleName);
                Variant variant = enabled ? VariantUtil.selectVariant(featureToggle, context, Variant.DISABLED_VARIANT) : Variant.DISABLED_VARIANT;
                return new EvaluatedToggle((String)toggleName, enabled, variant);
            }).collect(Collectors.toList());
        }

        @Override
        public void count(String toggleName, boolean enabled) {
            DefaultUnleash.this.metricService.count(toggleName, enabled);
        }

        @Override
        public void countVariant(String toggleName, String variantName) {
            DefaultUnleash.this.metricService.countVariant(toggleName, variantName);
        }
    }
}

