/*
 * Decompiled with CFR 0.152.
 */
package io.getunleash.util;

import java.net.URL;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Throttler {
    private static final Logger LOGGER = LoggerFactory.getLogger(Throttler.class);
    private final int maxSkips;
    private final int intervalLength;
    private final AtomicInteger skips = new AtomicInteger(0);
    private final AtomicInteger failures = new AtomicInteger(0);
    private final URL target;

    public Throttler(int intervalLengthSeconds, int longestAcceptableIntervalSeconds, URL target) {
        this.maxSkips = Integer.max(longestAcceptableIntervalSeconds / Integer.max(intervalLengthSeconds, 1), 1);
        this.target = target;
        this.intervalLength = intervalLengthSeconds;
    }

    public void decrementFailureCountAndResetSkips() {
        if (this.failures.get() > 0) {
            this.skips.set(Math.max(this.failures.decrementAndGet(), 0));
        }
    }

    public void increaseSkipCount() {
        this.skips.set(Math.min(this.failures.incrementAndGet(), this.maxSkips));
    }

    public void maximizeSkips() {
        this.skips.set(this.maxSkips);
        this.failures.incrementAndGet();
    }

    public boolean performAction() {
        return this.skips.get() <= 0;
    }

    public void skipped() {
        this.skips.decrementAndGet();
    }

    public void handleHttpErrorCodes(int responseCode) {
        if (responseCode == 401 || responseCode == 403) {
            this.maximizeSkips();
            LOGGER.error("Client was not authorized to talk to the Unleash API at {}. Backing off to {} times our poll interval (of {} seconds) to avoid overloading server", new Object[]{this.target, this.maxSkips, this.intervalLength});
        }
        if (responseCode == 404) {
            this.maximizeSkips();
            LOGGER.error("Server said that the endpoint at {} does not exist. Backing off to {} times our poll interval (of {} seconds) to avoid overloading server", new Object[]{this.target, this.maxSkips, this.intervalLength});
        } else if (responseCode == 429) {
            this.increaseSkipCount();
            LOGGER.info("RATE LIMITED for the {}. time. Further backing off. Current backoff at {} times our interval (of {} seconds)", new Object[]{this.failures.get(), this.skips.get(), this.intervalLength});
        } else if (responseCode >= 500) {
            this.increaseSkipCount();
            LOGGER.info("Server failed with a {} status code. Backing off. Current backoff at {} times our poll interval (of {} seconds)", new Object[]{responseCode, this.skips.get(), this.intervalLength});
        }
    }

    public int getSkips() {
        return this.skips.get();
    }

    public int getFailures() {
        return this.failures.get();
    }
}

