/*
 * Decompiled with CFR 0.152.
 */
package io.getunleash.repository;

import io.getunleash.UnleashException;
import io.getunleash.event.ClientFeaturesResponse;
import io.getunleash.repository.FeatureFetcher;
import io.getunleash.util.UnleashConfig;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpFeatureFetcher
implements FeatureFetcher {
    private static final Logger LOG = LoggerFactory.getLogger(HttpFeatureFetcher.class);
    private Optional<String> etag = Optional.empty();
    private final UnleashConfig config;
    private final URL toggleUrl;

    public HttpFeatureFetcher(UnleashConfig config) {
        this.config = config;
        this.toggleUrl = config.getUnleashURLs().getFetchTogglesURL(config.getProjectName(), config.getNamePrefix());
    }

    @Override
    public ClientFeaturesResponse fetchFeatures() throws UnleashException {
        HttpURLConnection connection = null;
        try {
            connection = this.openConnection(this.toggleUrl);
            connection.setRequestProperty("UNLEASH-INTERVAL", this.config.getFetchTogglesIntervalMillis());
            connection.connect();
            ClientFeaturesResponse clientFeaturesResponse = this.getFeatureResponse(connection, true);
            return clientFeaturesResponse;
        }
        catch (IOException e) {
            throw new UnleashException("Could not fetch toggles", e);
        }
        catch (IllegalStateException e) {
            throw new UnleashException(e.getMessage(), e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private ClientFeaturesResponse getFeatureResponse(HttpURLConnection request, boolean followRedirect) throws IOException {
        int responseCode = request.getResponseCode();
        if (responseCode < 300) {
            this.etag = Optional.ofNullable(request.getHeaderField("ETag"));
            String contentEncoding = request.getHeaderField("Content-Encoding");
            if ("gzip".equalsIgnoreCase(contentEncoding)) {
                try (GZIPInputStream stream = new GZIPInputStream(request.getInputStream());){
                    ClientFeaturesResponse clientFeaturesResponse;
                    try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                        int len;
                        byte[] buffer = new byte[1024];
                        while ((len = stream.read(buffer)) != -1) {
                            outputStream.write(buffer, 0, len);
                        }
                        String clientFeatures = outputStream.toString(StandardCharsets.UTF_8);
                        clientFeaturesResponse = ClientFeaturesResponse.updated(clientFeatures);
                    }
                    return clientFeaturesResponse;
                }
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)request.getContent(), StandardCharsets.UTF_8));){
                String clientFeatures = reader.lines().collect(Collectors.joining("\n"));
                ClientFeaturesResponse clientFeaturesResponse = ClientFeaturesResponse.updated(clientFeatures);
                return clientFeaturesResponse;
            }
        }
        if (followRedirect && (responseCode == 302 || responseCode == 301 || responseCode == 303)) {
            return this.followRedirect(request);
        }
        if (responseCode == 304) {
            return ClientFeaturesResponse.notChanged();
        }
        return ClientFeaturesResponse.unavailable(responseCode, this.getLocationHeader(request));
    }

    private ClientFeaturesResponse followRedirect(HttpURLConnection request) throws IOException {
        String newUrl = this.getLocationHeader(request).orElseThrow(() -> new IllegalStateException("No Location header found in redirect response."));
        request = this.openConnection(new URL(newUrl));
        request.connect();
        LOG.info("Redirecting from {} to {}. Please consider updating your config.", (Object)this.toggleUrl, (Object)newUrl);
        return this.getFeatureResponse(request, false);
    }

    private Optional<String> getLocationHeader(HttpURLConnection connection) {
        return Optional.ofNullable(connection.getHeaderField("Location"));
    }

    private HttpURLConnection openConnection(URL url) throws IOException {
        HttpURLConnection connection = this.config.getProxy() != null ? (HttpURLConnection)url.openConnection(this.config.getProxy()) : (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout((int)this.config.getFetchTogglesConnectTimeout().toMillis());
        connection.setReadTimeout((int)this.config.getFetchTogglesReadTimeout().toMillis());
        connection.setRequestProperty("Accept", "application/json");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("Accept-Encoding", "gzip,deflate");
        UnleashConfig.setRequestProperties(connection, this.config);
        this.etag.ifPresent(val -> connection.setRequestProperty("If-None-Match", (String)val));
        connection.setUseCaches(true);
        return connection;
    }
}

