/*
 * Decompiled with CFR 0.152.
 */
package io.getunleash;

import io.getunleash.EngineProxy;
import io.getunleash.EngineProxyImpl;
import io.getunleash.EvaluatedToggle;
import io.getunleash.FeatureDefinition;
import io.getunleash.MoreOperations;
import io.getunleash.Unleash;
import io.getunleash.UnleashContext;
import io.getunleash.UnleashContextProvider;
import io.getunleash.engine.FlatResponse;
import io.getunleash.engine.VariantDef;
import io.getunleash.event.EventDispatcher;
import io.getunleash.event.IsEnabledImpressionEvent;
import io.getunleash.event.ToggleEvaluated;
import io.getunleash.event.VariantImpressionEvent;
import io.getunleash.repository.FeatureRepository;
import io.getunleash.repository.YggdrasilAdapters;
import io.getunleash.strategy.Strategy;
import io.getunleash.util.UnleashConfig;
import io.getunleash.variant.Variant;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUnleash
implements Unleash {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultUnleash.class);
    private static ConcurrentHashMap<String, LongAdder> initCounts = new ConcurrentHashMap();
    private final FeatureRepository featureRepository;
    private final UnleashContextProvider contextProvider;
    private final EventDispatcher eventDispatcher;
    private final UnleashConfig config;

    private static EngineProxy defaultToggleRepository(UnleashConfig unleashConfig, Strategy ... strategies) {
        return new EngineProxyImpl(unleashConfig, strategies);
    }

    public DefaultUnleash(UnleashConfig unleashConfig, Strategy ... strategies) {
        this(unleashConfig, DefaultUnleash.defaultToggleRepository(unleashConfig, strategies));
    }

    public DefaultUnleash(UnleashConfig unleashConfig, EngineProxy engineProxy) {
        this(unleashConfig, engineProxy, unleashConfig.getContextProvider(), new EventDispatcher(unleashConfig), false);
    }

    public DefaultUnleash(UnleashConfig unleashConfig, EngineProxy engineProxy, UnleashContextProvider contextProvider, EventDispatcher eventDispatcher) {
        this(unleashConfig, engineProxy, contextProvider, eventDispatcher, false);
    }

    public DefaultUnleash(UnleashConfig unleashConfig, EngineProxy engineProxy, UnleashContextProvider contextProvider, EventDispatcher eventDispatcher, boolean failOnMultipleInstantiations) {
        this.config = unleashConfig;
        this.featureRepository = engineProxy;
        this.contextProvider = contextProvider;
        this.eventDispatcher = eventDispatcher;
        initCounts.compute(this.config.getClientIdentifier(), (key, inits) -> {
            if (inits != null) {
                String error = String.format("You already have %d clients for AppName [%s] with instanceId: [%s] running. Please double check your code where you are instantiating the Unleash SDK", inits.sum(), unleashConfig.getAppName(), unleashConfig.getInstanceId());
                if (failOnMultipleInstantiations) {
                    throw new RuntimeException(error);
                }
                LOGGER.error(error);
            }
            LongAdder a = inits == null ? new LongAdder() : inits;
            a.increment();
            return a;
        });
    }

    @Override
    public boolean isEnabled(String toggleName, boolean defaultSetting) {
        return this.isEnabled(toggleName, this.contextProvider.getContext(), defaultSetting);
    }

    @Override
    public boolean isEnabled(String toggleName, BiPredicate<String, UnleashContext> fallbackAction) {
        return this.isEnabled(toggleName, this.contextProvider.getContext(), fallbackAction);
    }

    @Override
    public boolean isEnabled(String toggleName, UnleashContext context, BiPredicate<String, UnleashContext> fallbackAction) {
        UnleashContext enhancedContext = context.applyStaticFields(this.config);
        Optional<FlatResponse<Boolean>> response = Optional.ofNullable(this.featureRepository.isEnabled(toggleName, enhancedContext));
        boolean enabled = response.flatMap(r -> Optional.ofNullable((Boolean)r.value)).orElseGet(() -> fallbackAction.test(toggleName, enhancedContext));
        this.eventDispatcher.dispatch(new ToggleEvaluated(toggleName, enabled));
        if (response.map(r -> r.impressionData).orElse(false).booleanValue()) {
            this.eventDispatcher.dispatch(new IsEnabledImpressionEvent(toggleName, enabled, context));
        }
        return enabled;
    }

    @Override
    public Variant getVariant(String toggleName, UnleashContext context) {
        return this.getVariant(toggleName, context, Variant.DISABLED_VARIANT);
    }

    @Override
    public Variant getVariant(String toggleName) {
        return this.getVariant(toggleName, this.contextProvider.getContext());
    }

    @Override
    public Variant getVariant(String toggleName, Variant defaultValue) {
        return this.getVariant(toggleName, this.contextProvider.getContext(), defaultValue);
    }

    @Override
    public Variant getVariant(String toggleName, UnleashContext context, Variant defaultValue) {
        UnleashContext enhancedContext = context.applyStaticFields(this.config);
        Optional<FlatResponse<VariantDef>> response = Optional.ofNullable(this.featureRepository.getVariant(toggleName, enhancedContext));
        Optional<VariantDef> variantDef = response.map(r -> (VariantDef)r.value);
        Variant variant = YggdrasilAdapters.adapt(variantDef, defaultValue);
        this.eventDispatcher.dispatch(new ToggleEvaluated(toggleName, variant.isFeatureEnabled()));
        if (response.map(r -> r.impressionData).orElse(false).booleanValue()) {
            this.eventDispatcher.dispatch(new VariantImpressionEvent(toggleName, variant.isFeatureEnabled(), context, variant.getName()));
        }
        return variant;
    }

    @Override
    public void shutdown() {
        this.featureRepository.shutdown();
        this.config.getScheduledExecutor().shutdown();
    }

    @Override
    public MoreOperations more() {
        return new DefaultMore();
    }

    public class DefaultMore
    implements MoreOperations {
        @Override
        public List<String> getFeatureToggleNames() {
            return DefaultUnleash.this.featureRepository.listKnownToggles().map(FeatureDefinition::getName).collect(Collectors.toList());
        }

        @Override
        public Optional<FeatureDefinition> getFeatureToggleDefinition(String toggleName) {
            return DefaultUnleash.this.featureRepository.listKnownToggles().filter(toggle -> toggle.getName().equals(toggleName)).findFirst();
        }

        @Override
        public List<EvaluatedToggle> evaluateAllToggles() {
            return this.evaluateAllToggles(DefaultUnleash.this.contextProvider.getContext());
        }

        @Override
        public List<EvaluatedToggle> evaluateAllToggles(UnleashContext context) {
            return DefaultUnleash.this.featureRepository.listKnownToggles().map(FeatureDefinition::getName).map(toggleName -> {
                UnleashContext enhancedContext = context.applyStaticFields(DefaultUnleash.this.config);
                FlatResponse<VariantDef> response = DefaultUnleash.this.featureRepository.getVariant((String)toggleName, enhancedContext);
                Optional<VariantDef> variantDef = Optional.of((VariantDef)response.value);
                Variant variant = YggdrasilAdapters.adapt(variantDef, Variant.DISABLED_VARIANT);
                return new EvaluatedToggle((String)toggleName, variant.isFeatureEnabled(), variant);
            }).collect(Collectors.toList());
        }
    }
}

