/*
 * Decompiled with CFR 0.152.
 */
package io.getunleash.event;

import io.getunleash.FeatureDefinition;
import io.getunleash.event.UnleashEvent;
import io.getunleash.event.UnleashSubscriber;
import io.getunleash.util.ClientFeaturesParser;
import java.util.List;
import java.util.Optional;

public final class ClientFeaturesResponse
implements UnleashEvent {
    private final Optional<String> clientFeatures;
    private final Status statusCode;
    private final int httpStatusCode;
    private final Optional<String> location;
    private List<FeatureDefinition> features;

    private ClientFeaturesResponse(Status status, int httpStatusCode, Optional<String> clientFeatures, Optional<String> location) {
        this.statusCode = status;
        this.clientFeatures = clientFeatures;
        this.httpStatusCode = httpStatusCode;
        this.location = location;
    }

    public static ClientFeaturesResponse notChanged() {
        return new ClientFeaturesResponse(Status.NOT_CHANGED, 304, Optional.empty(), Optional.empty());
    }

    public static ClientFeaturesResponse updated(String clientFeatures) {
        return new ClientFeaturesResponse(Status.CHANGED, 200, Optional.of(clientFeatures), Optional.empty());
    }

    public static ClientFeaturesResponse unavailable(int statusCode, Optional<String> location) {
        return new ClientFeaturesResponse(Status.UNAVAILABLE, statusCode, Optional.empty(), location);
    }

    public Optional<String> getClientFeatures() {
        return this.clientFeatures;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public Status getStatus() {
        return this.statusCode;
    }

    public List<FeatureDefinition> getFeatures() {
        if (this.clientFeatures.isPresent() && this.features == null) {
            this.features = ClientFeaturesParser.parse(this.clientFeatures.get());
        }
        return this.features;
    }

    public String getLocation() {
        return this.location.orElse(null);
    }

    public String toString() {
        return "ClientFeatureResponse: status=" + (Object)((Object)this.getStatus()) + " httpStatus=" + this.getHttpStatusCode();
    }

    @Override
    public void publishTo(UnleashSubscriber unleashSubscriber) {
        unleashSubscriber.togglesFetched(this);
    }

    public static enum Status {
        NOT_CHANGED,
        CHANGED,
        UNAVAILABLE;

    }
}

