/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.java.models;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.getstream.chat.java.models.Message;
import io.getstream.chat.java.models.Sort;
import io.getstream.chat.java.models.framework.StreamRequest;
import io.getstream.chat.java.models.framework.StreamResponseObject;
import io.getstream.chat.java.services.MessageHistoryService;
import io.getstream.chat.java.services.framework.Client;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;

public class MessageHistory {
    @NotNull
    public static MessageHistoryQueryRequestData.MessageHistoryQueryRequest query() {
        return new MessageHistoryQueryRequestData.MessageHistoryQueryRequest();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageHistory)) {
            return false;
        }
        MessageHistory other = (MessageHistory)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof MessageHistory;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "MessageHistory()";
    }

    public static class MessageHistoryQueryResponse
    extends StreamResponseObject {
        @JsonProperty(value="message_history")
        @NotNull
        private List<MessageHistoryEntry> messageHistory;
        @JsonProperty(value="next")
        @NotNull
        private String next;
        @JsonProperty(value="prev")
        @NotNull
        private String prev;

        @NotNull
        public List<MessageHistoryEntry> getMessageHistory() {
            return this.messageHistory;
        }

        @NotNull
        public String getNext() {
            return this.next;
        }

        @NotNull
        public String getPrev() {
            return this.prev;
        }

        @JsonProperty(value="message_history")
        public void setMessageHistory(@NotNull List<MessageHistoryEntry> messageHistory) {
            if (messageHistory == null) {
                throw new NullPointerException("messageHistory is marked non-null but is null");
            }
            this.messageHistory = messageHistory;
        }

        @JsonProperty(value="next")
        public void setNext(@NotNull String next) {
            if (next == null) {
                throw new NullPointerException("next is marked non-null but is null");
            }
            this.next = next;
        }

        @JsonProperty(value="prev")
        public void setPrev(@NotNull String prev) {
            if (prev == null) {
                throw new NullPointerException("prev is marked non-null but is null");
            }
            this.prev = prev;
        }

        @Override
        public String toString() {
            return "MessageHistory.MessageHistoryQueryResponse(messageHistory=" + String.valueOf(this.getMessageHistory()) + ", next=" + this.getNext() + ", prev=" + this.getPrev() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageHistoryQueryResponse)) {
                return false;
            }
            MessageHistoryQueryResponse other = (MessageHistoryQueryResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            List<MessageHistoryEntry> this$messageHistory = this.getMessageHistory();
            List<MessageHistoryEntry> other$messageHistory = other.getMessageHistory();
            if (this$messageHistory == null ? other$messageHistory != null : !((Object)this$messageHistory).equals(other$messageHistory)) {
                return false;
            }
            String this$next = this.getNext();
            String other$next = other.getNext();
            if (this$next == null ? other$next != null : !this$next.equals(other$next)) {
                return false;
            }
            String this$prev = this.getPrev();
            String other$prev = other.getPrev();
            return !(this$prev == null ? other$prev != null : !this$prev.equals(other$prev));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof MessageHistoryQueryResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            List<MessageHistoryEntry> $messageHistory = this.getMessageHistory();
            result = result * 59 + ($messageHistory == null ? 43 : ((Object)$messageHistory).hashCode());
            String $next = this.getNext();
            result = result * 59 + ($next == null ? 43 : $next.hashCode());
            String $prev = this.getPrev();
            result = result * 59 + ($prev == null ? 43 : $prev.hashCode());
            return result;
        }
    }

    public static class MessageHistoryEntry {
        @JsonProperty(value="message_id")
        @NotNull
        private String messageId;
        @JsonProperty(value="message_updated_at")
        @NotNull
        private Date messageUpdatedAt;
        @JsonProperty(value="attachments")
        @Nullable
        private List<Message.Attachment> attachments;
        @JsonProperty(value="message_updated_by_id")
        @NotNull
        private String messageUpdatedById;
        @JsonProperty(value="text")
        @Nullable
        private String text;
        @JsonIgnore
        @NotNull
        private Map<String, Object> additionalFields = new HashMap<String, Object>();

        @JsonAnyGetter
        public Map<String, Object> getAdditionalFields() {
            return this.additionalFields;
        }

        @JsonAnySetter
        public void setAdditionalField(String name, Object value) {
            this.additionalFields.put(name, value);
        }

        @NotNull
        public String getMessageId() {
            return this.messageId;
        }

        @NotNull
        public Date getMessageUpdatedAt() {
            return this.messageUpdatedAt;
        }

        @Nullable
        public List<Message.Attachment> getAttachments() {
            return this.attachments;
        }

        @NotNull
        public String getMessageUpdatedById() {
            return this.messageUpdatedById;
        }

        @Nullable
        public String getText() {
            return this.text;
        }

        @JsonProperty(value="message_id")
        public void setMessageId(@NotNull String messageId) {
            if (messageId == null) {
                throw new NullPointerException("messageId is marked non-null but is null");
            }
            this.messageId = messageId;
        }

        @JsonProperty(value="message_updated_at")
        public void setMessageUpdatedAt(@NotNull Date messageUpdatedAt) {
            if (messageUpdatedAt == null) {
                throw new NullPointerException("messageUpdatedAt is marked non-null but is null");
            }
            this.messageUpdatedAt = messageUpdatedAt;
        }

        @JsonProperty(value="attachments")
        public void setAttachments(@Nullable List<Message.Attachment> attachments) {
            this.attachments = attachments;
        }

        @JsonProperty(value="message_updated_by_id")
        public void setMessageUpdatedById(@NotNull String messageUpdatedById) {
            if (messageUpdatedById == null) {
                throw new NullPointerException("messageUpdatedById is marked non-null but is null");
            }
            this.messageUpdatedById = messageUpdatedById;
        }

        @JsonProperty(value="text")
        public void setText(@Nullable String text) {
            this.text = text;
        }

        @JsonIgnore
        public void setAdditionalFields(@NotNull Map<String, Object> additionalFields) {
            if (additionalFields == null) {
                throw new NullPointerException("additionalFields is marked non-null but is null");
            }
            this.additionalFields = additionalFields;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageHistoryEntry)) {
                return false;
            }
            MessageHistoryEntry other = (MessageHistoryEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$messageId = this.getMessageId();
            String other$messageId = other.getMessageId();
            if (this$messageId == null ? other$messageId != null : !this$messageId.equals(other$messageId)) {
                return false;
            }
            Date this$messageUpdatedAt = this.getMessageUpdatedAt();
            Date other$messageUpdatedAt = other.getMessageUpdatedAt();
            if (this$messageUpdatedAt == null ? other$messageUpdatedAt != null : !((Object)this$messageUpdatedAt).equals(other$messageUpdatedAt)) {
                return false;
            }
            List<Message.Attachment> this$attachments = this.getAttachments();
            List<Message.Attachment> other$attachments = other.getAttachments();
            if (this$attachments == null ? other$attachments != null : !((Object)this$attachments).equals(other$attachments)) {
                return false;
            }
            String this$messageUpdatedById = this.getMessageUpdatedById();
            String other$messageUpdatedById = other.getMessageUpdatedById();
            if (this$messageUpdatedById == null ? other$messageUpdatedById != null : !this$messageUpdatedById.equals(other$messageUpdatedById)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
                return false;
            }
            Map<String, Object> this$additionalFields = this.getAdditionalFields();
            Map<String, Object> other$additionalFields = other.getAdditionalFields();
            return !(this$additionalFields == null ? other$additionalFields != null : !((Object)this$additionalFields).equals(other$additionalFields));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MessageHistoryEntry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $messageId = this.getMessageId();
            result = result * 59 + ($messageId == null ? 43 : $messageId.hashCode());
            Date $messageUpdatedAt = this.getMessageUpdatedAt();
            result = result * 59 + ($messageUpdatedAt == null ? 43 : ((Object)$messageUpdatedAt).hashCode());
            List<Message.Attachment> $attachments = this.getAttachments();
            result = result * 59 + ($attachments == null ? 43 : ((Object)$attachments).hashCode());
            String $messageUpdatedById = this.getMessageUpdatedById();
            result = result * 59 + ($messageUpdatedById == null ? 43 : $messageUpdatedById.hashCode());
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            Map<String, Object> $additionalFields = this.getAdditionalFields();
            result = result * 59 + ($additionalFields == null ? 43 : ((Object)$additionalFields).hashCode());
            return result;
        }

        public String toString() {
            return "MessageHistory.MessageHistoryEntry(messageId=" + this.getMessageId() + ", messageUpdatedAt=" + String.valueOf(this.getMessageUpdatedAt()) + ", attachments=" + String.valueOf(this.getAttachments()) + ", messageUpdatedById=" + this.getMessageUpdatedById() + ", text=" + this.getText() + ", additionalFields=" + String.valueOf(this.getAdditionalFields()) + ")";
        }
    }

    public static class MessageHistoryQueryRequestData {
        @JsonProperty(value="filter")
        @Nullable
        private Map<String, Object> filter;
        @JsonProperty(value="sort")
        @Nullable
        private List<Sort> sorts;
        @JsonProperty(value="limit")
        @Nullable
        private Integer limit;
        @JsonProperty(value="next")
        @Nullable
        private String next;
        @JsonProperty(value="prev")
        @Nullable
        private String prev;

        MessageHistoryQueryRequestData(@Nullable Map<String, Object> filter, @Nullable List<Sort> sorts, @Nullable Integer limit, @Nullable String next, @Nullable String prev) {
            this.filter = filter;
            this.sorts = sorts;
            this.limit = limit;
            this.next = next;
            this.prev = prev;
        }

        public static class MessageHistoryQueryRequest
        extends StreamRequest<MessageHistoryQueryResponse> {
            private Map<String, Object> filter;
            private ArrayList<Sort> sorts;
            private Integer limit;
            private String next;
            private String prev;

            @Override
            protected Call<MessageHistoryQueryResponse> generateCall(Client client) {
                MessageHistoryQueryRequestData data = this.internalBuild();
                return client.create(MessageHistoryService.class).query(data);
            }

            MessageHistoryQueryRequest() {
            }

            @JsonProperty(value="filter")
            public MessageHistoryQueryRequest filter(@Nullable Map<String, Object> filter) {
                this.filter = filter;
                return this;
            }

            public MessageHistoryQueryRequest sort(Sort sort) {
                if (this.sorts == null) {
                    this.sorts = new ArrayList();
                }
                this.sorts.add(sort);
                return this;
            }

            @JsonProperty(value="sort")
            public MessageHistoryQueryRequest sorts(Collection<? extends Sort> sorts) {
                if (sorts == null) {
                    throw new NullPointerException("sorts cannot be null");
                }
                if (this.sorts == null) {
                    this.sorts = new ArrayList();
                }
                this.sorts.addAll(sorts);
                return this;
            }

            public MessageHistoryQueryRequest clearSorts() {
                if (this.sorts != null) {
                    this.sorts.clear();
                }
                return this;
            }

            @JsonProperty(value="limit")
            public MessageHistoryQueryRequest limit(@Nullable Integer limit) {
                this.limit = limit;
                return this;
            }

            @JsonProperty(value="next")
            public MessageHistoryQueryRequest next(@Nullable String next) {
                this.next = next;
                return this;
            }

            @JsonProperty(value="prev")
            public MessageHistoryQueryRequest prev(@Nullable String prev) {
                this.prev = prev;
                return this;
            }

            public MessageHistoryQueryRequestData internalBuild() {
                List<Sort> sorts;
                switch (this.sorts == null ? 0 : this.sorts.size()) {
                    case 0: {
                        sorts = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        sorts = Collections.singletonList(this.sorts.get(0));
                        break;
                    }
                    default: {
                        sorts = Collections.unmodifiableList(new ArrayList<Sort>(this.sorts));
                    }
                }
                return new MessageHistoryQueryRequestData(this.filter, sorts, this.limit, this.next, this.prev);
            }

            public String toString() {
                return "MessageHistory.MessageHistoryQueryRequestData.MessageHistoryQueryRequest(filter=" + String.valueOf(this.filter) + ", sorts=" + String.valueOf(this.sorts) + ", limit=" + this.limit + ", next=" + this.next + ", prev=" + this.prev + ")";
            }
        }
    }
}

