/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.java.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.getstream.chat.java.exceptions.StreamException;
import io.getstream.chat.java.models.Channel;
import io.getstream.chat.java.models.Message;
import io.getstream.chat.java.models.Sort;
import io.getstream.chat.java.models.User;
import io.getstream.chat.java.models.framework.StreamRequest;
import io.getstream.chat.java.models.framework.StreamResponseObject;
import io.getstream.chat.java.services.DraftService;
import io.getstream.chat.java.services.framework.Client;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;

public class Draft {
    @NotNull
    public static CreateDraftRequestData.CreateDraftRequest createDraft(@NotNull String type, @NotNull String id) {
        return new CreateDraftRequestData.CreateDraftRequest(type, id);
    }

    @NotNull
    public static DeleteDraftRequest deleteDraft(@NotNull String type, @NotNull String id) {
        return new DeleteDraftRequest(type, id);
    }

    @NotNull
    public static GetDraftRequest getDraft(@NotNull String type, @NotNull String id) {
        return new GetDraftRequest(type, id);
    }

    @NotNull
    public static QueryDraftsRequestData.QueryDraftsRequest queryDrafts() {
        return new QueryDraftsRequestData.QueryDraftsRequest();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Draft)) {
            return false;
        }
        Draft other = (Draft)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof Draft;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "Draft()";
    }

    public static class QueryDraftsRequestData {
        @JsonProperty(value="filter")
        @Nullable
        private Map<String, Object> filter;
        @JsonProperty(value="sort")
        @Nullable
        private List<Sort> sorts;
        @JsonProperty(value="user_id")
        @NotNull
        private String userId;
        @JsonProperty(value="limit")
        @Nullable
        private Integer limit;
        @JsonProperty(value="next")
        @Nullable
        private String next;
        @JsonProperty(value="prev")
        @Nullable
        private String prev;

        QueryDraftsRequestData(@Nullable Map<String, Object> filter, @Nullable List<Sort> sorts, @NotNull String userId, @Nullable Integer limit, @Nullable String next, @Nullable String prev) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.filter = filter;
            this.sorts = sorts;
            this.userId = userId;
            this.limit = limit;
            this.next = next;
            this.prev = prev;
        }

        public static class QueryDraftsRequest
        extends StreamRequest<QueryDraftsResponse> {
            private Map<String, Object> filter;
            private ArrayList<Sort> sorts;
            private String userId;
            private Integer limit;
            private String next;
            private String prev;

            @Override
            protected Call<QueryDraftsResponse> generateCall(Client client) throws StreamException {
                return client.create(DraftService.class).queryDrafts(this.internalBuild());
            }

            @JsonProperty(value="filter")
            public QueryDraftsRequest filter(@Nullable Map<String, Object> filter) {
                this.filter = filter;
                return this;
            }

            public QueryDraftsRequest sort(Sort sort) {
                if (this.sorts == null) {
                    this.sorts = new ArrayList();
                }
                this.sorts.add(sort);
                return this;
            }

            @JsonProperty(value="sort")
            public QueryDraftsRequest sorts(Collection<? extends Sort> sorts) {
                if (sorts == null) {
                    throw new NullPointerException("sorts cannot be null");
                }
                if (this.sorts == null) {
                    this.sorts = new ArrayList();
                }
                this.sorts.addAll(sorts);
                return this;
            }

            public QueryDraftsRequest clearSorts() {
                if (this.sorts != null) {
                    this.sorts.clear();
                }
                return this;
            }

            @JsonProperty(value="user_id")
            public QueryDraftsRequest userId(@NotNull String userId) {
                if (userId == null) {
                    throw new NullPointerException("userId is marked non-null but is null");
                }
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="limit")
            public QueryDraftsRequest limit(@Nullable Integer limit) {
                this.limit = limit;
                return this;
            }

            @JsonProperty(value="next")
            public QueryDraftsRequest next(@Nullable String next) {
                this.next = next;
                return this;
            }

            @JsonProperty(value="prev")
            public QueryDraftsRequest prev(@Nullable String prev) {
                this.prev = prev;
                return this;
            }

            public QueryDraftsRequestData internalBuild() {
                List<Sort> sorts;
                switch (this.sorts == null ? 0 : this.sorts.size()) {
                    case 0: {
                        sorts = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        sorts = Collections.singletonList(this.sorts.get(0));
                        break;
                    }
                    default: {
                        sorts = Collections.unmodifiableList(new ArrayList<Sort>(this.sorts));
                    }
                }
                return new QueryDraftsRequestData(this.filter, sorts, this.userId, this.limit, this.next, this.prev);
            }

            public String toString() {
                return "Draft.QueryDraftsRequestData.QueryDraftsRequest(filter=" + String.valueOf(this.filter) + ", sorts=" + String.valueOf(this.sorts) + ", userId=" + this.userId + ", limit=" + this.limit + ", next=" + this.next + ", prev=" + this.prev + ")";
            }
        }
    }

    public static class GetDraftRequest
    extends StreamRequest<GetDraftResponse> {
        @NotNull
        private String channelType;
        @NotNull
        private String channelId;
        @Nullable
        private String userId;
        @Nullable
        private String parentId;

        private GetDraftRequest(@NotNull String channelType, @NotNull String channelId) {
            this.channelType = channelType;
            this.channelId = channelId;
        }

        @NotNull
        public GetDraftRequest userId(@NotNull String userId) {
            this.userId = userId;
            return this;
        }

        @NotNull
        public GetDraftRequest parentId(@Nullable String parentId) {
            this.parentId = parentId;
            return this;
        }

        @Override
        protected Call<GetDraftResponse> generateCall(Client client) throws StreamException {
            return client.create(DraftService.class).getDraft(this.channelType, this.channelId, this.userId, this.parentId);
        }
    }

    public static class DeleteDraftRequest
    extends StreamRequest<StreamResponseObject> {
        @NotNull
        private String channelType;
        @NotNull
        private String channelId;
        @Nullable
        private String userId;
        @Nullable
        private String parentId;

        private DeleteDraftRequest(@NotNull String channelType, @NotNull String channelId) {
            this.channelType = channelType;
            this.channelId = channelId;
        }

        @NotNull
        public DeleteDraftRequest userId(@NotNull String userId) {
            this.userId = userId;
            return this;
        }

        @NotNull
        public DeleteDraftRequest parentId(@Nullable String parentId) {
            this.parentId = parentId;
            return this;
        }

        @Override
        protected Call<StreamResponseObject> generateCall(Client client) throws StreamException {
            return client.create(DraftService.class).deleteDraft(this.channelType, this.channelId, this.userId, this.parentId);
        }
    }

    public static class CreateDraftRequestData {
        @JsonProperty(value="message")
        @NotNull
        private Message.MessageRequestObject message;
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private User.UserRequestObject user;

        CreateDraftRequestData(@NotNull Message.MessageRequestObject message, @Nullable String userId, @Nullable User.UserRequestObject user) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.message = message;
            this.userId = userId;
            this.user = user;
        }

        public static class CreateDraftRequest
        extends StreamRequest<CreateDraftResponse> {
            private Message.MessageRequestObject message;
            private String userId;
            private User.UserRequestObject user;
            @NotNull
            private String channelType;
            @NotNull
            private String channelId;

            private CreateDraftRequest(@NotNull String channelType, @NotNull String channelId) {
                this.channelType = channelType;
                this.channelId = channelId;
            }

            @Override
            protected Call<CreateDraftResponse> generateCall(Client client) throws StreamException {
                return client.create(DraftService.class).createDraft(this.channelType, this.channelId, this.internalBuild());
            }

            @JsonProperty(value="message")
            public CreateDraftRequest message(@NotNull Message.MessageRequestObject message) {
                if (message == null) {
                    throw new NullPointerException("message is marked non-null but is null");
                }
                this.message = message;
                return this;
            }

            @JsonProperty(value="user_id")
            public CreateDraftRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public CreateDraftRequest user(@Nullable User.UserRequestObject user) {
                this.user = user;
                return this;
            }

            public CreateDraftRequestData internalBuild() {
                return new CreateDraftRequestData(this.message, this.userId, this.user);
            }

            public String toString() {
                return "Draft.CreateDraftRequestData.CreateDraftRequest(message=" + String.valueOf(this.message) + ", userId=" + this.userId + ", user=" + String.valueOf(this.user) + ")";
            }
        }
    }

    public static class QueryDraftsResponse
    extends StreamResponseObject {
        @JsonProperty(value="drafts")
        @NotNull
        private List<DraftObject> drafts;
        @JsonProperty(value="next")
        @Nullable
        private String next;

        @NotNull
        public List<DraftObject> getDrafts() {
            return this.drafts;
        }

        @Nullable
        public String getNext() {
            return this.next;
        }

        @JsonProperty(value="drafts")
        public void setDrafts(@NotNull List<DraftObject> drafts) {
            if (drafts == null) {
                throw new NullPointerException("drafts is marked non-null but is null");
            }
            this.drafts = drafts;
        }

        @JsonProperty(value="next")
        public void setNext(@Nullable String next) {
            this.next = next;
        }

        @Override
        public String toString() {
            return "Draft.QueryDraftsResponse(drafts=" + String.valueOf(this.getDrafts()) + ", next=" + this.getNext() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QueryDraftsResponse)) {
                return false;
            }
            QueryDraftsResponse other = (QueryDraftsResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            List<DraftObject> this$drafts = this.getDrafts();
            List<DraftObject> other$drafts = other.getDrafts();
            if (this$drafts == null ? other$drafts != null : !((Object)this$drafts).equals(other$drafts)) {
                return false;
            }
            String this$next = this.getNext();
            String other$next = other.getNext();
            return !(this$next == null ? other$next != null : !this$next.equals(other$next));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof QueryDraftsResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            List<DraftObject> $drafts = this.getDrafts();
            result = result * 59 + ($drafts == null ? 43 : ((Object)$drafts).hashCode());
            String $next = this.getNext();
            result = result * 59 + ($next == null ? 43 : $next.hashCode());
            return result;
        }
    }

    public static class GetDraftResponse
    extends StreamResponseObject {
        @JsonProperty(value="draft")
        @NotNull
        private DraftObject draft;

        @NotNull
        public DraftObject getDraft() {
            return this.draft;
        }

        @JsonProperty(value="draft")
        public void setDraft(@NotNull DraftObject draft) {
            if (draft == null) {
                throw new NullPointerException("draft is marked non-null but is null");
            }
            this.draft = draft;
        }

        @Override
        public String toString() {
            return "Draft.GetDraftResponse(draft=" + String.valueOf(this.getDraft()) + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetDraftResponse)) {
                return false;
            }
            GetDraftResponse other = (GetDraftResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DraftObject this$draft = this.getDraft();
            DraftObject other$draft = other.getDraft();
            return !(this$draft == null ? other$draft != null : !((Object)this$draft).equals(other$draft));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof GetDraftResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            DraftObject $draft = this.getDraft();
            result = result * 59 + ($draft == null ? 43 : ((Object)$draft).hashCode());
            return result;
        }
    }

    public static class CreateDraftResponse
    extends StreamResponseObject {
        @JsonProperty(value="draft")
        @NotNull
        private DraftObject draft;

        @NotNull
        public DraftObject getDraft() {
            return this.draft;
        }

        @JsonProperty(value="draft")
        public void setDraft(@NotNull DraftObject draft) {
            if (draft == null) {
                throw new NullPointerException("draft is marked non-null but is null");
            }
            this.draft = draft;
        }

        @Override
        public String toString() {
            return "Draft.CreateDraftResponse(draft=" + String.valueOf(this.getDraft()) + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreateDraftResponse)) {
                return false;
            }
            CreateDraftResponse other = (CreateDraftResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DraftObject this$draft = this.getDraft();
            DraftObject other$draft = other.getDraft();
            return !(this$draft == null ? other$draft != null : !((Object)this$draft).equals(other$draft));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof CreateDraftResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            DraftObject $draft = this.getDraft();
            result = result * 59 + ($draft == null ? 43 : ((Object)$draft).hashCode());
            return result;
        }
    }

    public static class DraftObject {
        @JsonProperty(value="channel_cid")
        @NotNull
        private String channelCid;
        @JsonProperty(value="created_at")
        @NotNull
        private Date createdAt;
        @JsonProperty(value="message")
        @NotNull
        private DraftMessage message;
        @JsonProperty(value="channel")
        @Nullable
        private Channel channel;
        @JsonProperty(value="parent_id")
        @Nullable
        private String parentId;
        @JsonProperty(value="parent_message")
        @Nullable
        private Message parentMessage;
        @JsonProperty(value="quoted_message")
        @Nullable
        private Message quotedMessage;

        @NotNull
        public String getChannelCid() {
            return this.channelCid;
        }

        @NotNull
        public Date getCreatedAt() {
            return this.createdAt;
        }

        @NotNull
        public DraftMessage getMessage() {
            return this.message;
        }

        @Nullable
        public Channel getChannel() {
            return this.channel;
        }

        @Nullable
        public String getParentId() {
            return this.parentId;
        }

        @Nullable
        public Message getParentMessage() {
            return this.parentMessage;
        }

        @Nullable
        public Message getQuotedMessage() {
            return this.quotedMessage;
        }

        @JsonProperty(value="channel_cid")
        public void setChannelCid(@NotNull String channelCid) {
            if (channelCid == null) {
                throw new NullPointerException("channelCid is marked non-null but is null");
            }
            this.channelCid = channelCid;
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(@NotNull Date createdAt) {
            if (createdAt == null) {
                throw new NullPointerException("createdAt is marked non-null but is null");
            }
            this.createdAt = createdAt;
        }

        @JsonProperty(value="message")
        public void setMessage(@NotNull DraftMessage message) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.message = message;
        }

        @JsonProperty(value="channel")
        public void setChannel(@Nullable Channel channel) {
            this.channel = channel;
        }

        @JsonProperty(value="parent_id")
        public void setParentId(@Nullable String parentId) {
            this.parentId = parentId;
        }

        @JsonProperty(value="parent_message")
        public void setParentMessage(@Nullable Message parentMessage) {
            this.parentMessage = parentMessage;
        }

        @JsonProperty(value="quoted_message")
        public void setQuotedMessage(@Nullable Message quotedMessage) {
            this.quotedMessage = quotedMessage;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DraftObject)) {
                return false;
            }
            DraftObject other = (DraftObject)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$channelCid = this.getChannelCid();
            String other$channelCid = other.getChannelCid();
            if (this$channelCid == null ? other$channelCid != null : !this$channelCid.equals(other$channelCid)) {
                return false;
            }
            Date this$createdAt = this.getCreatedAt();
            Date other$createdAt = other.getCreatedAt();
            if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
                return false;
            }
            DraftMessage this$message = this.getMessage();
            DraftMessage other$message = other.getMessage();
            if (this$message == null ? other$message != null : !((Object)this$message).equals(other$message)) {
                return false;
            }
            Channel this$channel = this.getChannel();
            Channel other$channel = other.getChannel();
            if (this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel)) {
                return false;
            }
            String this$parentId = this.getParentId();
            String other$parentId = other.getParentId();
            if (this$parentId == null ? other$parentId != null : !this$parentId.equals(other$parentId)) {
                return false;
            }
            Message this$parentMessage = this.getParentMessage();
            Message other$parentMessage = other.getParentMessage();
            if (this$parentMessage == null ? other$parentMessage != null : !((Object)this$parentMessage).equals(other$parentMessage)) {
                return false;
            }
            Message this$quotedMessage = this.getQuotedMessage();
            Message other$quotedMessage = other.getQuotedMessage();
            return !(this$quotedMessage == null ? other$quotedMessage != null : !((Object)this$quotedMessage).equals(other$quotedMessage));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DraftObject;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $channelCid = this.getChannelCid();
            result = result * 59 + ($channelCid == null ? 43 : $channelCid.hashCode());
            Date $createdAt = this.getCreatedAt();
            result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
            DraftMessage $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
            Channel $channel = this.getChannel();
            result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
            String $parentId = this.getParentId();
            result = result * 59 + ($parentId == null ? 43 : $parentId.hashCode());
            Message $parentMessage = this.getParentMessage();
            result = result * 59 + ($parentMessage == null ? 43 : ((Object)$parentMessage).hashCode());
            Message $quotedMessage = this.getQuotedMessage();
            result = result * 59 + ($quotedMessage == null ? 43 : ((Object)$quotedMessage).hashCode());
            return result;
        }

        public String toString() {
            return "Draft.DraftObject(channelCid=" + this.getChannelCid() + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", message=" + String.valueOf(this.getMessage()) + ", channel=" + String.valueOf(this.getChannel()) + ", parentId=" + this.getParentId() + ", parentMessage=" + String.valueOf(this.getParentMessage()) + ", quotedMessage=" + String.valueOf(this.getQuotedMessage()) + ")";
        }
    }

    public static class DraftMessage {
        @JsonProperty(value="id")
        @Nullable
        private String id;
        @JsonProperty(value="text")
        @Nullable
        private String text;
        @JsonProperty(value="html")
        @Nullable
        private String html;
        @JsonProperty(value="mml")
        @Nullable
        private String mml;
        @JsonProperty(value="parent_id")
        @Nullable
        private String parentId;
        @JsonProperty(value="show_in_channel")
        @Nullable
        private Boolean showInChannel;
        @JsonProperty(value="attachments")
        @Nullable
        private List<Message.Attachment> attachments;
        @JsonProperty(value="mentioned_users")
        @Nullable
        private List<User> mentionedUsers;
        @JsonProperty(value="custom")
        @Nullable
        private Map<String, Object> custom;
        @JsonProperty(value="quoted_message_id")
        @Nullable
        private String quotedMessageId;
        @JsonProperty(value="type")
        @Nullable
        private String type;
        @JsonProperty(value="silent")
        @Nullable
        private Boolean silent;
        @JsonProperty(value="poll_id")
        @Nullable
        private String pollId;

        @Nullable
        public String getId() {
            return this.id;
        }

        @Nullable
        public String getText() {
            return this.text;
        }

        @Nullable
        public String getHtml() {
            return this.html;
        }

        @Nullable
        public String getMml() {
            return this.mml;
        }

        @Nullable
        public String getParentId() {
            return this.parentId;
        }

        @Nullable
        public Boolean getShowInChannel() {
            return this.showInChannel;
        }

        @Nullable
        public List<Message.Attachment> getAttachments() {
            return this.attachments;
        }

        @Nullable
        public List<User> getMentionedUsers() {
            return this.mentionedUsers;
        }

        @Nullable
        public Map<String, Object> getCustom() {
            return this.custom;
        }

        @Nullable
        public String getQuotedMessageId() {
            return this.quotedMessageId;
        }

        @Nullable
        public String getType() {
            return this.type;
        }

        @Nullable
        public Boolean getSilent() {
            return this.silent;
        }

        @Nullable
        public String getPollId() {
            return this.pollId;
        }

        @JsonProperty(value="id")
        public void setId(@Nullable String id) {
            this.id = id;
        }

        @JsonProperty(value="text")
        public void setText(@Nullable String text) {
            this.text = text;
        }

        @JsonProperty(value="html")
        public void setHtml(@Nullable String html) {
            this.html = html;
        }

        @JsonProperty(value="mml")
        public void setMml(@Nullable String mml) {
            this.mml = mml;
        }

        @JsonProperty(value="parent_id")
        public void setParentId(@Nullable String parentId) {
            this.parentId = parentId;
        }

        @JsonProperty(value="show_in_channel")
        public void setShowInChannel(@Nullable Boolean showInChannel) {
            this.showInChannel = showInChannel;
        }

        @JsonProperty(value="attachments")
        public void setAttachments(@Nullable List<Message.Attachment> attachments) {
            this.attachments = attachments;
        }

        @JsonProperty(value="mentioned_users")
        public void setMentionedUsers(@Nullable List<User> mentionedUsers) {
            this.mentionedUsers = mentionedUsers;
        }

        @JsonProperty(value="custom")
        public void setCustom(@Nullable Map<String, Object> custom) {
            this.custom = custom;
        }

        @JsonProperty(value="quoted_message_id")
        public void setQuotedMessageId(@Nullable String quotedMessageId) {
            this.quotedMessageId = quotedMessageId;
        }

        @JsonProperty(value="type")
        public void setType(@Nullable String type) {
            this.type = type;
        }

        @JsonProperty(value="silent")
        public void setSilent(@Nullable Boolean silent) {
            this.silent = silent;
        }

        @JsonProperty(value="poll_id")
        public void setPollId(@Nullable String pollId) {
            this.pollId = pollId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DraftMessage)) {
                return false;
            }
            DraftMessage other = (DraftMessage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$showInChannel = this.getShowInChannel();
            Boolean other$showInChannel = other.getShowInChannel();
            if (this$showInChannel == null ? other$showInChannel != null : !((Object)this$showInChannel).equals(other$showInChannel)) {
                return false;
            }
            Boolean this$silent = this.getSilent();
            Boolean other$silent = other.getSilent();
            if (this$silent == null ? other$silent != null : !((Object)this$silent).equals(other$silent)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
                return false;
            }
            String this$html = this.getHtml();
            String other$html = other.getHtml();
            if (this$html == null ? other$html != null : !this$html.equals(other$html)) {
                return false;
            }
            String this$mml = this.getMml();
            String other$mml = other.getMml();
            if (this$mml == null ? other$mml != null : !this$mml.equals(other$mml)) {
                return false;
            }
            String this$parentId = this.getParentId();
            String other$parentId = other.getParentId();
            if (this$parentId == null ? other$parentId != null : !this$parentId.equals(other$parentId)) {
                return false;
            }
            List<Message.Attachment> this$attachments = this.getAttachments();
            List<Message.Attachment> other$attachments = other.getAttachments();
            if (this$attachments == null ? other$attachments != null : !((Object)this$attachments).equals(other$attachments)) {
                return false;
            }
            List<User> this$mentionedUsers = this.getMentionedUsers();
            List<User> other$mentionedUsers = other.getMentionedUsers();
            if (this$mentionedUsers == null ? other$mentionedUsers != null : !((Object)this$mentionedUsers).equals(other$mentionedUsers)) {
                return false;
            }
            Map<String, Object> this$custom = this.getCustom();
            Map<String, Object> other$custom = other.getCustom();
            if (this$custom == null ? other$custom != null : !((Object)this$custom).equals(other$custom)) {
                return false;
            }
            String this$quotedMessageId = this.getQuotedMessageId();
            String other$quotedMessageId = other.getQuotedMessageId();
            if (this$quotedMessageId == null ? other$quotedMessageId != null : !this$quotedMessageId.equals(other$quotedMessageId)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$pollId = this.getPollId();
            String other$pollId = other.getPollId();
            return !(this$pollId == null ? other$pollId != null : !this$pollId.equals(other$pollId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DraftMessage;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $showInChannel = this.getShowInChannel();
            result = result * 59 + ($showInChannel == null ? 43 : ((Object)$showInChannel).hashCode());
            Boolean $silent = this.getSilent();
            result = result * 59 + ($silent == null ? 43 : ((Object)$silent).hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            String $html = this.getHtml();
            result = result * 59 + ($html == null ? 43 : $html.hashCode());
            String $mml = this.getMml();
            result = result * 59 + ($mml == null ? 43 : $mml.hashCode());
            String $parentId = this.getParentId();
            result = result * 59 + ($parentId == null ? 43 : $parentId.hashCode());
            List<Message.Attachment> $attachments = this.getAttachments();
            result = result * 59 + ($attachments == null ? 43 : ((Object)$attachments).hashCode());
            List<User> $mentionedUsers = this.getMentionedUsers();
            result = result * 59 + ($mentionedUsers == null ? 43 : ((Object)$mentionedUsers).hashCode());
            Map<String, Object> $custom = this.getCustom();
            result = result * 59 + ($custom == null ? 43 : ((Object)$custom).hashCode());
            String $quotedMessageId = this.getQuotedMessageId();
            result = result * 59 + ($quotedMessageId == null ? 43 : $quotedMessageId.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $pollId = this.getPollId();
            result = result * 59 + ($pollId == null ? 43 : $pollId.hashCode());
            return result;
        }

        public String toString() {
            return "Draft.DraftMessage(id=" + this.getId() + ", text=" + this.getText() + ", html=" + this.getHtml() + ", mml=" + this.getMml() + ", parentId=" + this.getParentId() + ", showInChannel=" + this.getShowInChannel() + ", attachments=" + String.valueOf(this.getAttachments()) + ", mentionedUsers=" + String.valueOf(this.getMentionedUsers()) + ", custom=" + String.valueOf(this.getCustom()) + ", quotedMessageId=" + this.getQuotedMessageId() + ", type=" + this.getType() + ", silent=" + this.getSilent() + ", pollId=" + this.getPollId() + ")";
        }
    }
}

