/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.java.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.getstream.chat.java.models.framework.StreamRequest;
import io.getstream.chat.java.models.framework.StreamResponseObject;
import io.getstream.chat.java.services.BlocklistService;
import io.getstream.chat.java.services.framework.Client;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;

public class Blocklist {
    @JsonProperty(value="created_at")
    @NotNull
    private Date createdAt;
    @JsonProperty(value="updated_at")
    @NotNull
    private Date updatedAt;
    @JsonProperty(value="name")
    @NotNull
    private String name;
    @JsonProperty(value="words")
    @NotNull
    private List<String> words;

    @NotNull
    public static BlocklistCreateRequestData.BlocklistCreateRequest create() {
        return new BlocklistCreateRequestData.BlocklistCreateRequest();
    }

    @NotNull
    public static BlocklistGetRequest get(@NotNull String name) {
        return new BlocklistGetRequest(name);
    }

    @NotNull
    public static BlocklistUpdateRequestData.BlocklistUpdateRequest update(@NotNull String name) {
        return new BlocklistUpdateRequestData.BlocklistUpdateRequest(name);
    }

    @NotNull
    public static BlocklistDeleteRequest delete(@NotNull String name) {
        return new BlocklistDeleteRequest(name);
    }

    @NotNull
    public static BlocklistListRequest list() {
        return new BlocklistListRequest();
    }

    @NotNull
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @NotNull
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public List<String> getWords() {
        return this.words;
    }

    @JsonProperty(value="created_at")
    public void setCreatedAt(@NotNull Date createdAt) {
        if (createdAt == null) {
            throw new NullPointerException("createdAt is marked non-null but is null");
        }
        this.createdAt = createdAt;
    }

    @JsonProperty(value="updated_at")
    public void setUpdatedAt(@NotNull Date updatedAt) {
        if (updatedAt == null) {
            throw new NullPointerException("updatedAt is marked non-null but is null");
        }
        this.updatedAt = updatedAt;
    }

    @JsonProperty(value="name")
    public void setName(@NotNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    @JsonProperty(value="words")
    public void setWords(@NotNull List<String> words) {
        if (words == null) {
            throw new NullPointerException("words is marked non-null but is null");
        }
        this.words = words;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Blocklist)) {
            return false;
        }
        Blocklist other = (Blocklist)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Date this$createdAt = this.getCreatedAt();
        Date other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Date this$updatedAt = this.getUpdatedAt();
        Date other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<String> this$words = this.getWords();
        List<String> other$words = other.getWords();
        return !(this$words == null ? other$words != null : !((Object)this$words).equals(other$words));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Blocklist;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Date $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Date $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<String> $words = this.getWords();
        result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
        return result;
    }

    public String toString() {
        return "Blocklist(createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ", name=" + this.getName() + ", words=" + String.valueOf(this.getWords()) + ")";
    }

    public static class BlocklistListResponse
    extends StreamResponseObject {
        @JsonProperty(value="blocklists")
        @NotNull
        private List<Blocklist> blocklists;

        @NotNull
        public List<Blocklist> getBlocklists() {
            return this.blocklists;
        }

        @JsonProperty(value="blocklists")
        public void setBlocklists(@NotNull List<Blocklist> blocklists) {
            if (blocklists == null) {
                throw new NullPointerException("blocklists is marked non-null but is null");
            }
            this.blocklists = blocklists;
        }

        @Override
        public String toString() {
            return "Blocklist.BlocklistListResponse(blocklists=" + String.valueOf(this.getBlocklists()) + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BlocklistListResponse)) {
                return false;
            }
            BlocklistListResponse other = (BlocklistListResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            List<Blocklist> this$blocklists = this.getBlocklists();
            List<Blocklist> other$blocklists = other.getBlocklists();
            return !(this$blocklists == null ? other$blocklists != null : !((Object)this$blocklists).equals(other$blocklists));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof BlocklistListResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            List<Blocklist> $blocklists = this.getBlocklists();
            result = result * 59 + ($blocklists == null ? 43 : ((Object)$blocklists).hashCode());
            return result;
        }
    }

    public static class BlocklistGetResponse
    extends StreamResponseObject {
        @JsonProperty(value="blocklist")
        @NotNull
        private Blocklist blocklist;

        @NotNull
        public Blocklist getBlocklist() {
            return this.blocklist;
        }

        @JsonProperty(value="blocklist")
        public void setBlocklist(@NotNull Blocklist blocklist) {
            if (blocklist == null) {
                throw new NullPointerException("blocklist is marked non-null but is null");
            }
            this.blocklist = blocklist;
        }

        @Override
        public String toString() {
            return "Blocklist.BlocklistGetResponse(blocklist=" + String.valueOf(this.getBlocklist()) + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BlocklistGetResponse)) {
                return false;
            }
            BlocklistGetResponse other = (BlocklistGetResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Blocklist this$blocklist = this.getBlocklist();
            Blocklist other$blocklist = other.getBlocklist();
            return !(this$blocklist == null ? other$blocklist != null : !((Object)this$blocklist).equals(other$blocklist));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof BlocklistGetResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Blocklist $blocklist = this.getBlocklist();
            result = result * 59 + ($blocklist == null ? 43 : ((Object)$blocklist).hashCode());
            return result;
        }
    }

    public static class BlocklistListRequest
    extends StreamRequest<BlocklistListResponse> {
        @Override
        protected Call<BlocklistListResponse> generateCall(Client client) {
            return client.create(BlocklistService.class).list();
        }
    }

    public static class BlocklistDeleteRequest
    extends StreamRequest<StreamResponseObject> {
        @NotNull
        private String name;

        @Override
        protected Call<StreamResponseObject> generateCall(Client client) {
            return client.create(BlocklistService.class).delete(this.name);
        }

        public BlocklistDeleteRequest(@NotNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
        }
    }

    public static class BlocklistUpdateRequestData {
        @JsonProperty(value="words")
        @Nullable
        private List<String> words;

        BlocklistUpdateRequestData(@Nullable List<String> words) {
            this.words = words;
        }

        public static class BlocklistUpdateRequest
        extends StreamRequest<StreamResponseObject> {
            private List<String> words;
            @NotNull
            private String name;

            private BlocklistUpdateRequest(@NotNull String name) {
                this.name = name;
            }

            @Override
            protected Call<StreamResponseObject> generateCall(Client client) {
                return client.create(BlocklistService.class).update(this.name, this.internalBuild());
            }

            @JsonProperty(value="words")
            public BlocklistUpdateRequest words(@Nullable List<String> words) {
                this.words = words;
                return this;
            }

            public BlocklistUpdateRequestData internalBuild() {
                return new BlocklistUpdateRequestData(this.words);
            }

            public String toString() {
                return "Blocklist.BlocklistUpdateRequestData.BlocklistUpdateRequest(words=" + String.valueOf(this.words) + ")";
            }
        }
    }

    public static class BlocklistGetRequest
    extends StreamRequest<BlocklistGetResponse> {
        @NotNull
        private String name;

        @Override
        protected Call<BlocklistGetResponse> generateCall(Client client) {
            return client.create(BlocklistService.class).get(this.name);
        }

        public BlocklistGetRequest(@NotNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
        }
    }

    public static class BlocklistCreateRequestData {
        @JsonProperty(value="name")
        @Nullable
        private String name;
        @JsonProperty(value="words")
        @Nullable
        private List<String> words;

        BlocklistCreateRequestData(@Nullable String name, @Nullable List<String> words) {
            this.name = name;
            this.words = words;
        }

        public static class BlocklistCreateRequest
        extends StreamRequest<StreamResponseObject> {
            private String name;
            private List<String> words;

            @Override
            protected Call<StreamResponseObject> generateCall(Client client) {
                return client.create(BlocklistService.class).create(this.internalBuild());
            }

            BlocklistCreateRequest() {
            }

            @JsonProperty(value="name")
            public BlocklistCreateRequest name(@Nullable String name) {
                this.name = name;
                return this;
            }

            @JsonProperty(value="words")
            public BlocklistCreateRequest words(@Nullable List<String> words) {
                this.words = words;
                return this;
            }

            public BlocklistCreateRequestData internalBuild() {
                return new BlocklistCreateRequestData(this.name, this.words);
            }

            public String toString() {
                return "Blocklist.BlocklistCreateRequestData.BlocklistCreateRequest(name=" + this.name + ", words=" + String.valueOf(this.words) + ")";
            }
        }
    }
}

